/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import jenkins.scm.api.SCMFile;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;

class GiteaSCMFile
extends SCMFile {
    private final GiteaConnection connection;
    private final GiteaRepository repo;
    private final String ref;
    private Boolean isFile;

    GiteaSCMFile(GiteaConnection connection, GiteaRepository repo, String ref) {
        this.connection = connection;
        this.type(SCMFile.Type.DIRECTORY);
        this.repo = repo;
        this.ref = ref;
    }

    private GiteaSCMFile(@NonNull GiteaSCMFile parent, String name, Boolean isFile) {
        super((SCMFile)parent, name);
        this.connection = parent.connection;
        this.repo = parent.repo;
        this.ref = parent.ref;
        this.isFile = isFile;
    }

    @NonNull
    protected SCMFile newChild(String name, boolean assumeIsDirectory) {
        return new GiteaSCMFile(this, name, assumeIsDirectory ? Boolean.FALSE : null);
    }

    @NonNull
    public Iterable<SCMFile> children() throws IOException {
        return Collections.emptyList();
    }

    public long lastModified() throws IOException, InterruptedException {
        return 0L;
    }

    @NonNull
    protected SCMFile.Type type() throws IOException, InterruptedException {
        if (this.isFile == null) {
            this.isFile = this.connection.checkFile(this.repo, this.ref, this.getPath());
        }
        return this.isFile != false ? SCMFile.Type.REGULAR_FILE : SCMFile.Type.NONEXISTENT;
    }

    @NonNull
    public InputStream content() throws IOException, InterruptedException {
        if (this.isFile != null && !this.isFile.booleanValue()) {
            throw new FileNotFoundException(this.getPath());
        }
        try {
            byte[] content = this.connection.fetchFile(this.repo, this.ref, this.getPath());
            this.isFile = true;
            return new ByteArrayInputStream(content);
        }
        catch (FileNotFoundException e) {
            this.isFile = false;
            throw e;
        }
    }
}

