/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.security.ACL;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import jenkins.plugins.git.GitSCMBuilder;
import jenkins.plugins.git.MergeWithGitSCMExtension;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.acegisecurity.Authentication;
import org.eclipse.jgit.transport.RefSpec;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaBrowser;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.TagSCMHead;

public class GiteaSCMBuilder
extends GitSCMBuilder<GiteaSCMBuilder> {
    @CheckForNull
    private final SCMSourceOwner context;
    @NonNull
    private final String serverUrl;
    @NonNull
    private final String repoOwner;
    @NonNull
    private final String repository;
    private final String sshRemote;

    public GiteaSCMBuilder(@NonNull GiteaSCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        super(head, revision, GiteaSCMBuilder.checkoutUriTemplate(null, source.getServerUrl(), null, null).set("owner", (Object)source.getRepoOwner()).set("repository", (Object)source.getRepository()).expand(), source.getCredentialsId());
        String repoUrl;
        this.context = source.getOwner();
        this.serverUrl = source.getServerUrl();
        this.repoOwner = source.getRepoOwner();
        this.repository = source.getRepository();
        this.sshRemote = source.getSshRemote();
        this.withoutRefSpecs();
        if (head instanceof PullRequestSCMHead) {
            PullRequestSCMHead h = (PullRequestSCMHead)head;
            this.withRefSpec("+refs/pull/" + h.getId() + "/head:refs/remotes/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(h.getOriginOwner(), h.getOriginRepository());
        } else if (head instanceof TagSCMHead) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        } else if (head instanceof ReleaseSCMHead) {
            this.withRefSpec("+refs/tags/" + head.getName() + ":refs/tags/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        } else {
            this.withRefSpec("+refs/heads/" + head.getName() + ":refs/remotes/@{remote}/" + head.getName());
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        }
        this.withBrowser(new GiteaBrowser(repoUrl));
    }

    public static UriTemplate checkoutUriTemplate(@CheckForNull Item context, @NonNull String serverUrl, @CheckForNull String sshRemote, @CheckForNull String credentialsId) {
        if (credentialsId != null && sshRemote != null) {
            StandardCredentials credentials;
            URIRequirementBuilder builder = URIRequirementBuilder.create();
            URI serverUri = URI.create(serverUrl);
            if (serverUri.getHost() != null) {
                builder.withHostname(serverUri.getHost());
            }
            if ((credentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM), (List)builder.build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.instanceOf(StandardCredentials.class)}))) instanceof SSHUserPrivateKey) {
                int atIndex = sshRemote.indexOf(64);
                int colonIndex = sshRemote.indexOf(58);
                if (atIndex != -1 && colonIndex != -1 && atIndex < colonIndex) {
                    return UriTemplate.buildFromTemplate((String)("ssh://" + sshRemote.substring(0, colonIndex))).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal(".git").build();
                }
                URI sshUri = URI.create(sshRemote);
                String username = ((SSHUserPrivateKey)credentials).getUsername();
                if (username.equals(System.getProperty("user.name"))) {
                    username = "git";
                }
                return UriTemplate.buildFromTemplate((String)("ssh://" + username + "@" + sshUri.getHost() + (String)(sshUri.getPort() != 22 && sshUri.getPort() != -1 ? ":" + sshUri.getPort() : ""))).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal(".git").build();
            }
        }
        return UriTemplate.buildFromTemplate((String)serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).literal(".git").build();
    }

    public final String repositoryUrl(String owner, String repository) {
        return UriTemplate.buildFromTemplate((String)this.serverUrl).path(new VarSpec[]{UriTemplateBuilder.var((String)"owner")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"repository")}).build().set("owner", (Object)owner).set("repository", (Object)repository).expand();
    }

    @NonNull
    public final UriTemplate checkoutUriTemplate() {
        String credentialsId = this.credentialsId();
        return GiteaSCMBuilder.checkoutUriTemplate((Item)this.context, this.serverUrl, this.sshRemote, credentialsId);
    }

    @NonNull
    public final GiteaSCMBuilder withGiteaRemote() {
        String repoUrl;
        this.withRemote(this.checkoutUriTemplate().set("owner", (Object)this.repoOwner).set("repository", (Object)this.repository).expand());
        SCMHead h = this.head();
        if (h instanceof PullRequestSCMHead) {
            PullRequestSCMHead head = (PullRequestSCMHead)h;
            repoUrl = this.repositoryUrl(head.getOriginOwner(), head.getOriginRepository());
        } else {
            repoUrl = this.repositoryUrl(this.repoOwner, this.repository);
        }
        if (repoUrl != null) {
            this.withBrowser(new GiteaBrowser(repoUrl));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public GitSCM build() {
        SCMHead h = this.head();
        SCMRevision r = this.revision();
        try {
            this.withGiteaRemote();
            if (h instanceof PullRequestSCMHead) {
                PullRequestSCMHead head = (PullRequestSCMHead)h;
                if (head.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.MERGE) {
                    String name = head.getTarget().getName();
                    Object localName = "remotes/" + this.remoteName() + "/" + name;
                    HashSet<String> localNames = new HashSet<String>();
                    boolean match = false;
                    String targetSrc = "refs/heads/" + name;
                    String targetDst = "refs/remotes/" + this.remoteName() + "/" + name;
                    for (RefSpec b : this.asRefSpecs()) {
                        String dst = b.getDestination();
                        assert (dst.startsWith("refs/")) : "All git references must start with refs/";
                        if (targetSrc.equals(b.getSource())) {
                            if (targetDst.equals(dst)) {
                                match = true;
                                continue;
                            }
                            localName = dst.substring("refs/".length());
                            match = true;
                            continue;
                        }
                        localNames.add(dst.substring("refs/".length()));
                    }
                    if (!match) {
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            localName = "remotes/" + this.remoteName() + "/pr-" + head.getId() + "-upstream-" + name;
                        }
                        if (localNames.contains(localName)) {
                            while (localNames.contains(localName)) {
                                localName = "remotes/" + this.remoteName() + "/pr-" + head.getId() + "-upstream-" + name + "-" + Integer.toHexString(ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE));
                            }
                        }
                        this.withRefSpec("+refs/heads/" + name + ":refs/" + (String)localName);
                    }
                    this.withExtension((GitSCMExtension)new MergeWithGitSCMExtension((String)localName, r instanceof PullRequestSCMRevision ? ((BranchSCMRevision)((PullRequestSCMRevision)r).getTarget()).getHash() : null));
                }
                if (r instanceof PullRequestSCMRevision) {
                    this.withRevision((SCMRevision)((PullRequestSCMRevision)r).getOrigin());
                }
            }
            GitSCM gitSCM = super.build();
            return gitSCM;
        }
        finally {
            this.withHead(h);
            this.withRevision(r);
        }
    }
}

