/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceEvent;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMSourceEvent;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepositoryEvent;

public class GiteaRepositorySCMEvent
extends AbstractGiteaSCMSourceEvent<GiteaRepositoryEvent> {
    public GiteaRepositorySCMEvent(@NonNull GiteaRepositoryEvent payload, @CheckForNull String origin) {
        super(GiteaRepositorySCMEvent.typeOf(payload), payload, origin);
    }

    @NonNull
    private static SCMEvent.Type typeOf(@NonNull GiteaRepositoryEvent event) {
        switch (event.getAction()) {
            case "deleted": {
                return SCMEvent.Type.REMOVED;
            }
            case "created": {
                return SCMEvent.Type.CREATED;
            }
        }
        return SCMEvent.Type.UPDATED;
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        switch (this.getType()) {
            case CREATED: {
                return "Creation of repository " + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getName();
            }
            case REMOVED: {
                return "Deletion of repository " + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getName();
            }
        }
        return super.descriptionFor(navigator);
    }

    public String descriptionFor(SCMSource source) {
        switch (this.getType()) {
            case CREATED: {
                return "Creation of repository";
            }
            case REMOVED: {
                return "Deletion of repository";
            }
        }
        return super.descriptionFor(source);
    }

    public String description() {
        switch (this.getType()) {
            case CREATED: {
                return "Creation of repository " + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getName();
            }
            case REMOVED: {
                return "Deletion of repository " + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaRepositoryEvent)this.getPayload()).getRepository().getName();
            }
        }
        return super.description();
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaRepositorySCMEvent, GiteaRepositoryEvent> {
        @Override
        protected GiteaRepositorySCMEvent createEvent(GiteaRepositoryEvent payload, String origin) {
            return new GiteaRepositorySCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaRepositorySCMEvent event) {
            SCMSourceEvent.fireNow((SCMSourceEvent)event);
        }
    }
}

