/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import hudson.Extension;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMRevision;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMHeadEvent;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.ReleaseSCMRevision;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaReleaseEvent;
import org.jenkinsci.plugin.gitea.client.api.GiteaTag;

public class GiteaReleaseSCMEvent
extends AbstractGiteaSCMHeadEvent<GiteaReleaseEvent> {
    public static final Logger LOGGER = Logger.getLogger(GiteaReleaseSCMEvent.class.getName());

    public GiteaReleaseSCMEvent(GiteaReleaseEvent payload, String origin) {
        super(SCMEvent.Type.CREATED, payload, origin);
    }

    @Override
    protected Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource source) {
        if (((GiteaReleaseEvent)this.getPayload()).getRelease().isDraft()) {
            return Collections.emptyMap();
        }
        String ref = ((GiteaReleaseEvent)this.getPayload()).getRelease().getTagName();
        String sha = null;
        try (GiteaConnection c = source.gitea().open();){
            GiteaTag releaseTag = c.fetchTag(source.getRepoOwner(), source.getRepository(), ref);
            sha = releaseTag.getCommit().getSha();
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        ReleaseSCMHead h = new ReleaseSCMHead(ref, ((GiteaReleaseEvent)this.getPayload()).getRelease().getId());
        return Collections.singletonMap(h, new ReleaseSCMRevision(h, sha));
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaReleaseSCMEvent, GiteaReleaseEvent> {
        @Override
        protected GiteaReleaseSCMEvent createEvent(GiteaReleaseEvent payload, String origin) {
            return new GiteaReleaseSCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaReleaseSCMEvent event) {
            SCMHeadEvent.fireNow((SCMHeadEvent)event);
        }
    }
}

