/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import java.io.IOException;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMSource;
import jenkins.util.VirtualFile;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.ReleaseSCMHead;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaRepository;

public class GiteaReleaseNotifier {
    public static void publishArtifacts(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        if (build.getResult() != Result.SUCCESS) {
            listener.getLogger().format("[Gitea] do not publish assets due to build being non-Successfully%n", new Object[0]);
            return;
        }
        SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
        if (!(s instanceof GiteaSCMSource)) {
            listener.getLogger().format("[Gitea] do not publish assets due to source being no GiteaSCMSource%n", new Object[0]);
            return;
        }
        GiteaSCMSource source = (GiteaSCMSource)s;
        if (!((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).artifactToAssetMappingEnabled()) {
            return;
        }
        SCMHead head = SCMHead.HeadByItem.findHead((Item)build.getParent());
        if (head == null || !(head instanceof ReleaseSCMHead)) {
            listener.getLogger().format("[Gitea] do not publish assets due to head either being null or no ReleaseSCMHead%n", new Object[0]);
            return;
        }
        try (GiteaConnection c = source.gitea().open();){
            GiteaRepository repository = c.fetchRepository(source.getRepoOwner(), source.getRepository());
            long releaseId = ((ReleaseSCMHead)head).getId();
            for (Run.Artifact artifact : build.getArtifacts()) {
                VirtualFile file = build.getArtifactManager().root().child(artifact.relativePath);
                c.createReleaseAttachment(repository, releaseId, artifact.getFileName(), file.open());
                listener.getLogger().format("[Gitea] Published asset from archived artifact %s%n", artifact.getFileName());
            }
        }
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            try {
                GiteaReleaseNotifier.publishArtifacts(build, listener);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Could not upload assets for release"));
            }
        }
    }
}

