/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMHeadEvent;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.client.api.GiteaPushEvent;

public class GiteaPushSCMEvent
extends AbstractGiteaSCMHeadEvent<GiteaPushEvent> {
    public GiteaPushSCMEvent(@NonNull GiteaPushEvent payload, @CheckForNull String origin) {
        super(GiteaPushSCMEvent.typeOf(payload), payload, origin);
    }

    @NonNull
    private static SCMEvent.Type typeOf(@NonNull GiteaPushEvent event) {
        if (StringUtils.isBlank((String)event.getBefore()) || "0000000000000000000000000000000000000000".equals(event.getBefore())) {
            return SCMEvent.Type.CREATED;
        }
        if (StringUtils.isBlank((String)event.getAfter()) || "0000000000000000000000000000000000000000".equals(event.getAfter())) {
            return SCMEvent.Type.REMOVED;
        }
        return SCMEvent.Type.UPDATED;
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        String ref = ((GiteaPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        return "Push event to branch " + ref + " in repository " + ((GiteaPushEvent)this.getPayload()).getRepository().getName();
    }

    public String descriptionFor(SCMSource source) {
        String ref = ((GiteaPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        return "Push event to branch " + ref;
    }

    public String description() {
        String ref = ((GiteaPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        return "Push event to branch " + ref + " in repository " + ((GiteaPushEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaPushEvent)this.getPayload()).getRepository().getName();
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource source) {
        String ref = ((GiteaPushEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        BranchSCMHead h = new BranchSCMHead(ref);
        return Collections.singletonMap(h, StringUtils.isNotBlank((String)((GiteaPushEvent)this.getPayload()).getAfter()) ? new BranchSCMRevision(h, ((GiteaPushEvent)this.getPayload()).getAfter()) : null);
    }

    @Override
    public boolean isMatch(@NonNull SCM scm) {
        URIish uri;
        try {
            uri = new URIish(((GiteaPushEvent)this.getPayload()).getRepository().getHtmlUrl());
        }
        catch (URISyntaxException e) {
            return false;
        }
        String ref = ((GiteaPushEvent)this.getPayload()).getRef();
        String string = ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        if (scm instanceof GitSCM) {
            GitSCM git = (GitSCM)scm;
            if (git.getExtensions().get(IgnoreNotifyCommit.class) != null) {
                return false;
            }
            for (RemoteConfig repository : git.getRepositories()) {
                for (URIish remoteURL : repository.getURIs()) {
                    if (!GitStatus.looselyMatches((URIish)uri, (URIish)remoteURL)) continue;
                    for (BranchSpec branchSpec : git.getBranches()) {
                        if (branchSpec.getName().contains("$")) {
                            return true;
                        }
                        if (!branchSpec.matches(repository.getName() + "/" + ref)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaPushSCMEvent, GiteaPushEvent> {
        @Override
        protected GiteaPushSCMEvent createEvent(GiteaPushEvent payload, String origin) {
            return new GiteaPushSCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaPushSCMEvent event) {
            SCMHeadEvent.fireNow((SCMHeadEvent)event);
        }
    }
}

