/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMHeadEvent;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceRequest;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequest;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequestEvent;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequestEventType;

public class GiteaPullSCMEvent
extends AbstractGiteaSCMHeadEvent<GiteaPullRequestEvent> {
    public GiteaPullSCMEvent(@NonNull GiteaPullRequestEvent payload, @CheckForNull String origin) {
        super(GiteaPullSCMEvent.typeOf(payload), payload, origin);
    }

    @NonNull
    private static SCMEvent.Type typeOf(@NonNull GiteaPullRequestEvent event) {
        GiteaPullRequestEventType action = event.getAction();
        if (action != null) {
            switch (action) {
                case OPENED: {
                    return SCMEvent.Type.CREATED;
                }
                case CLOSED: {
                    return SCMEvent.Type.REMOVED;
                }
            }
            return SCMEvent.Type.UPDATED;
        }
        return SCMEvent.Type.UPDATED;
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        GiteaPullRequestEventType action = ((GiteaPullRequestEvent)this.getPayload()).getAction();
        if (action != null) {
            switch (action) {
                case OPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " opened in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
                case REOPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " reopened in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
                case CLOSED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " closed in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
            }
        }
        return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " event in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
    }

    public String descriptionFor(SCMSource source) {
        GiteaPullRequestEventType action = ((GiteaPullRequestEvent)this.getPayload()).getAction();
        if (action != null) {
            switch (action) {
                case OPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " opened";
                }
                case REOPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " reopened";
                }
                case CLOSED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " closed";
                }
            }
        }
        return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " event";
    }

    public String description() {
        GiteaPullRequestEventType action = ((GiteaPullRequestEvent)this.getPayload()).getAction();
        if (action != null) {
            switch (action) {
                case OPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " opened in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
                case REOPENED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " reopened in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
                case CLOSED: {
                    return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " closed in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
                }
            }
        }
        return "Pull request #" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + " event in repository " + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaPullRequestEvent)this.getPayload()).getRepository().getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource source) {
        HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>();
        try (GiteaSCMSourceRequest request = ((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).newRequest((SCMSource)source, null);){
            if (!request.isFetchPRs()) {
                HashMap<SCMHead, SCMRevision> hashMap = result;
                return hashMap;
            }
            GiteaPullRequest p = ((GiteaPullRequestEvent)this.getPayload()).getPullRequest();
            if (p == null) {
                EnumSet<ChangeRequestCheckoutStrategy> strategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
                if (request.isFetchForkPRs()) {
                    strategies.addAll(request.getForkPRStrategies());
                }
                if (request.isFetchOriginPRs()) {
                    strategies.addAll(request.getOriginPRStrategies());
                }
                Iterator iterator = strategies.iterator();
                while (iterator.hasNext()) {
                    ChangeRequestCheckoutStrategy strategy = (ChangeRequestCheckoutStrategy)iterator.next();
                    result.put(new PullRequestSCMHead("PR-" + ((GiteaPullRequestEvent)this.getPayload()).getNumber() + (String)(strategies.size() > 1 ? "-" + strategy.name().toLowerCase(Locale.ENGLISH) : ""), ((GiteaPullRequestEvent)this.getPayload()).getNumber(), new BranchSCMHead("dummy-name"), ChangeRequestCheckoutStrategy.MERGE, (SCMHeadOrigin)SCMHeadOrigin.DEFAULT, source.getRepoOwner(), source.getRepository(), "dummy-name"), null);
                }
                return result;
            }
            String originOwner = p.getHead().getRepo().getOwner().getUsername();
            String originRepository = p.getHead().getRepo().getName();
            Set<ChangeRequestCheckoutStrategy> strategies = request.getPRStrategies(!StringUtils.equalsIgnoreCase((String)source.getRepoOwner(), (String)originOwner) && StringUtils.equalsIgnoreCase((String)source.getRepository(), (String)originRepository));
            Iterator<ChangeRequestCheckoutStrategy> iterator = strategies.iterator();
            while (iterator.hasNext()) {
                ChangeRequestCheckoutStrategy strategy = iterator.next();
                PullRequestSCMHead h = new PullRequestSCMHead("PR-" + p.getNumber() + (String)(strategies.size() > 1 ? "-" + strategy.name().toLowerCase(Locale.ENGLISH) : ""), p.getNumber(), new BranchSCMHead(p.getBase().getRef()), strategy, (SCMHeadOrigin)(StringUtils.equalsIgnoreCase((String)originOwner, (String)source.getRepoOwner()) && StringUtils.equalsIgnoreCase((String)originRepository, (String)source.getRepository()) ? SCMHeadOrigin.DEFAULT : new SCMHeadOrigin.Fork(originOwner + "/" + originRepository)), originOwner, originRepository, p.getHead().getRef());
                result.put(h, (SCMRevision)(((GiteaPullRequestEvent)this.getPayload()).getAction() == GiteaPullRequestEventType.CLOSED ? null : new PullRequestSCMRevision(h, new BranchSCMRevision(h.getTarget(), p.getBase().getSha()), new BranchSCMRevision(new BranchSCMHead(h.getOriginName()), p.getHead().getSha()))));
            }
            return result;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaPullSCMEvent, GiteaPullRequestEvent> {
        public HandlerImpl() {
            super("pull_request");
        }

        @Override
        protected GiteaPullSCMEvent createEvent(GiteaPullRequestEvent payload, String origin) {
            return new GiteaPullSCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaPullSCMEvent event) {
            SCMHeadEvent.fireNow((SCMHeadEvent)event);
        }
    }
}

