/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.model.listeners.SCMListener;
import hudson.model.queue.QueueListener;
import hudson.model.queue.Tasks;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.LogTaskListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.jenkinsci.plugin.gitea.ReleaseSCMRevision;
import org.jenkinsci.plugin.gitea.TagSCMRevision;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitState;
import org.jenkinsci.plugin.gitea.client.api.GiteaCommitStatus;
import org.jenkinsci.plugin.gitea.client.api.GiteaConnection;
import org.jenkinsci.plugin.gitea.client.api.GiteaHttpStatusException;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;

public class GiteaNotifier {
    private static final Logger LOGGER = Logger.getLogger(GiteaNotifier.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendNotifications(Run<?, ?> build, TaskListener listener) throws IOException, InterruptedException {
        String hash;
        String url;
        SCMSource s = SCMSource.SourceByItem.findSource((Item)build.getParent());
        if (!(s instanceof GiteaSCMSource)) {
            return;
        }
        GiteaSCMSource source = (GiteaSCMSource)s;
        if (((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).notificationsDisabled()) {
            return;
        }
        try {
            url = DisplayURLProvider.get().getRunURL(build);
        }
        catch (IllegalStateException e) {
            listener.getLogger().println("Can not determine Jenkins root URL. Commit status notifications are disabled until a root URL is configured in Jenkins global configuration.");
            return;
        }
        Result result = build.getResult();
        GiteaCommitStatus status = new GiteaCommitStatus();
        status.setTargetUrl(url);
        if (Result.SUCCESS.equals(result)) {
            status.setDescription("This commit looks good");
            status.setState(GiteaCommitState.SUCCESS);
        } else if (Result.UNSTABLE.equals(result)) {
            status.setDescription("This commit is unstable");
            status.setState(GiteaCommitState.WARNING);
        } else if (Result.FAILURE.equals(result)) {
            status.setDescription("There was a failure building this commit");
            status.setState(GiteaCommitState.FAILURE);
        } else if (Result.NOT_BUILT.equals(result)) {
            status.setDescription("This commit was not built");
            status.setState(GiteaCommitState.WARNING);
        } else if (result != null) {
            status.setDescription("Something is wrong with the build of this commit");
            status.setState(GiteaCommitState.ERROR);
        } else {
            status.setDescription("Build started...");
            status.setState(GiteaCommitState.PENDING);
        }
        SCMRevision revision = SCMRevisionAction.getRevision((SCMSource)source, build);
        String statusContext = GiteaNotifier.stripBranchName(build.getParent()) + "/pipeline/";
        if (revision instanceof BranchSCMRevision) {
            listener.getLogger().format("[Gitea] Notifying branch build status: %s %s%n", status.getState().name(), status.getDescription());
            hash = ((BranchSCMRevision)revision).getHash();
            statusContext = statusContext + "head";
        } else if (revision instanceof PullRequestSCMRevision) {
            listener.getLogger().format("[Gitea] Notifying pull request build status: %s %s%n", status.getState().name(), status.getDescription());
            hash = ((PullRequestSCMRevision)revision).getOrigin().getHash();
            statusContext = statusContext + GiteaNotifier.getPrContextTarget(((PullRequestSCMRevision)revision).getTarget().getHead().getName());
        } else if (revision instanceof TagSCMRevision) {
            listener.getLogger().format("[Gitea] Notifying tag build status: %s %s%n", status.getState().name(), status.getDescription());
            hash = ((TagSCMRevision)revision).getHash();
            statusContext = statusContext + "tag";
        } else if (revision instanceof ReleaseSCMRevision) {
            listener.getLogger().format("[Gitea] Notifying release build status: %s %s%n", status.getState().name(), status.getDescription());
            hash = ((ReleaseSCMRevision)revision).getHash();
            statusContext = statusContext + "release";
        } else {
            return;
        }
        status.setContext(statusContext);
        JobScheduledListener jsl = (JobScheduledListener)((Object)ExtensionList.lookup(QueueListener.class).get(JobScheduledListener.class));
        if (jsl != null) {
            Map<Job, Long> map = jsl.resolving;
            synchronized (map) {
                jsl.resolving.remove(build.getParent());
            }
        }
        try (GiteaConnection c = source.gitea().open();){
            int tries = 3;
            while (true) {
                --tries;
                try {
                    c.createCommitStatus(source.getRepoOwner(), source.getRepository(), hash, status);
                }
                catch (GiteaHttpStatusException e) {
                    if (e.getStatusCode() == 500 && tries > 0) continue;
                    throw e;
                }
                break;
            }
            listener.getLogger().format("[Gitea] Notified%n", new Object[0]);
        }
    }

    private static String stripBranchName(Job job) {
        return job.getFullName().substring(0, job.getFullName().lastIndexOf(47));
    }

    private static String getPrContextTarget(String targetbranch) {
        return "pr-" + targetbranch;
    }

    @Extension
    public static class JobScheduledListener
    extends QueueListener {
        private final AtomicLong nonce = new AtomicLong();
        private final Map<Job, Long> resolving = new HashMap<Job, Long>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEnterWaiting(final Queue.WaitingItem wi) {
            if (!(wi.task instanceof Job)) {
                return;
            }
            final Job job = (Job)wi.task;
            SCMSource src = SCMSource.SourceByItem.findSource((Item)job);
            if (!(src instanceof GiteaSCMSource)) {
                return;
            }
            final GiteaSCMSource source = (GiteaSCMSource)src;
            if (((GiteaSCMSourceContext)new GiteaSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits())).notificationsDisabled()) {
                return;
            }
            final SCMHead head = SCMHead.HeadByItem.findHead((Item)job);
            if (head == null) {
                return;
            }
            final Long nonce = this.nonce.incrementAndGet();
            Map<Job, Long> map = this.resolving;
            synchronized (map) {
                this.resolving.put(job, nonce);
            }
            Computer.threadPoolForRemoting.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try (ACLContext context = ACL.as((Authentication)Tasks.getAuthenticationOf((Queue.Task)wi.task));){
                        String url;
                        String hash;
                        SCMRevision revision = source.fetch(head, (TaskListener)new LogTaskListener(LOGGER, Level.INFO));
                        String statusContext = GiteaNotifier.stripBranchName(job) + "/pipeline/";
                        if (revision instanceof BranchSCMRevision) {
                            LOGGER.log(Level.INFO, "Notifying branch pending build {0}", job.getFullName());
                            hash = ((BranchSCMRevision)revision).getHash();
                            statusContext = statusContext + "head";
                        } else if (revision instanceof PullRequestSCMRevision) {
                            LOGGER.log(Level.INFO, "Notifying pull request pending build {0}", job.getFullName());
                            hash = ((PullRequestSCMRevision)revision).getOrigin().getHash();
                            statusContext = statusContext + GiteaNotifier.getPrContextTarget(((PullRequestSCMRevision)revision).getTarget().getHead().getName());
                        } else if (revision instanceof TagSCMRevision) {
                            LOGGER.log(Level.INFO, "Notifying tag pending build {0}", job.getFullName());
                            statusContext = statusContext + "tag";
                            hash = ((TagSCMRevision)revision).getHash();
                        } else if (revision instanceof ReleaseSCMRevision) {
                            LOGGER.log(Level.INFO, "Notifying release pending build {0}", job.getFullName());
                            statusContext = statusContext + "release";
                            hash = ((ReleaseSCMRevision)revision).getHash();
                        } else {
                            return;
                        }
                        try {
                            url = DisplayURLProvider.get().getJobURL(job);
                        }
                        catch (IllegalStateException e) {
                            if (context != null) {
                                context.close();
                            }
                            return;
                        }
                        GiteaCommitStatus status = new GiteaCommitStatus();
                        status.setTargetUrl(url);
                        status.setContext(statusContext);
                        status.setDescription("Build queued...");
                        status.setState(GiteaCommitState.PENDING);
                        try (GiteaConnection c = source.gitea().open();){
                            Map<Job, Long> map = resolving;
                            synchronized (map) {
                                block33: {
                                    if (nonce.equals(resolving.get(job))) break block33;
                                    LOGGER.log(Level.INFO, "{0} has already started, skipping notification of queued", job.getFullName());
                                    return;
                                }
                                resolving.remove(job);
                            }
                            c.createCommitStatus(source.getRepoOwner(), source.getRepository(), hash, status);
                            LOGGER.log(Level.INFO, "{0} Notified", job.getFullName());
                        }
                    }
                    catch (IOException | InterruptedException e) {
                        LOGGER.log(Level.INFO, "Could not send commit status notification for " + job.getFullName() + " to " + source.getServerUrl(), e);
                    }
                }
            });
        }
    }

    @Extension
    public static class JobCompletedListener
    extends RunListener<Run<?, ?>> {
        public void onCompleted(Run<?, ?> build, TaskListener listener) {
            try {
                GiteaNotifier.sendNotifications(build, listener);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Could not send notifications"));
            }
        }

        public void onStarted(Run<?, ?> run, TaskListener listener) {
            try {
                GiteaNotifier.sendNotifications(run, listener);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Could not send notifications"));
            }
        }
    }

    @Extension
    public static class JobCheckOutListener
    extends SCMListener {
        public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) throws Exception {
            try {
                GiteaNotifier.sendNotifications(build, listener);
            }
            catch (IOException | InterruptedException e) {
                e.printStackTrace(listener.error("Could not send notifications"));
            }
        }
    }
}

