/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.jenkins.ui.icon.IconSpec;
import org.jenkinsci.plugin.gitea.Messages;
import org.kohsuke.stapler.Stapler;

public class GiteaLink
implements Action,
IconSpec {
    @NonNull
    private final String iconClassName;
    @NonNull
    private final String url;

    public GiteaLink(@NonNull String iconClassName, @NonNull String url) {
        this.iconClassName = iconClassName;
        this.url = url;
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public String getIconClassName() {
        return this.iconClassName;
    }

    public String getIconFileName() {
        Icon icon;
        String iconClassName = this.getIconClassName();
        if (iconClassName != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " icon-md"))) != null) {
            JellyContext ctx = new JellyContext();
            ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest2().getContextPath() + Jenkins.RESOURCE_PATH));
            return icon.getQualifiedUrl(ctx);
        }
        return null;
    }

    public String getDisplayName() {
        return Messages.GiteaLink_displayName();
    }

    public String getUrlName() {
        return this.url;
    }

    public int hashCode() {
        int result = this.iconClassName.hashCode();
        result = 31 * result + this.url.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GiteaLink that = (GiteaLink)o;
        if (!this.iconClassName.equals(that.iconClassName)) {
            return false;
        }
        return this.url.equals(that.url);
    }

    public String toString() {
        return "GiteaLink{iconClassName='" + this.iconClassName + "', url='" + this.url + "'}";
    }
}

