/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMHeadEvent;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.TagSCMHead;
import org.jenkinsci.plugin.gitea.client.api.GiteaDeleteEvent;

public class GiteaDeleteSCMEvent
extends AbstractGiteaSCMHeadEvent<GiteaDeleteEvent> {
    public GiteaDeleteSCMEvent(@NonNull GiteaDeleteEvent payload, @CheckForNull String origin) {
        super(SCMEvent.Type.REMOVED, payload, origin);
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        String ref = ((GiteaDeleteEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Delete event for " + ((GiteaDeleteEvent)this.getPayload()).getRefType() + " " + ref + " in repository " + ((GiteaDeleteEvent)this.getPayload()).getRepository().getName();
    }

    public String descriptionFor(SCMSource source) {
        String ref = ((GiteaDeleteEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Delete event for " + ((GiteaDeleteEvent)this.getPayload()).getRefType() + " " + ref;
    }

    public String description() {
        String ref = ((GiteaDeleteEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Delete event for " + ((GiteaDeleteEvent)this.getPayload()).getRefType() + " " + ref + " in repository " + ((GiteaDeleteEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaDeleteEvent)this.getPayload()).getRepository().getName();
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource source) {
        String ref = ((GiteaDeleteEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        String string = ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        if ("branch".equals(((GiteaDeleteEvent)this.getPayload()).getRefType())) {
            BranchSCMHead h = new BranchSCMHead(ref);
            return Collections.singletonMap(h, null);
        }
        if ("tag".equals(((GiteaDeleteEvent)this.getPayload()).getRefType())) {
            TagSCMHead h = new TagSCMHead(ref, System.currentTimeMillis());
            return Collections.singletonMap(h, null);
        }
        return Collections.emptyMap();
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaDeleteSCMEvent, GiteaDeleteEvent> {
        @Override
        protected GiteaDeleteSCMEvent createEvent(GiteaDeleteEvent payload, String origin) {
            return new GiteaDeleteSCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaDeleteSCMEvent event) {
            SCMHeadEvent.fireNow((SCMHeadEvent)event);
        }
    }
}

