/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.extensions.impl.IgnoreNotifyCommit;
import hudson.scm.SCM;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugin.gitea.AbstractGiteaSCMHeadEvent;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.BranchSCMRevision;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaWebhookHandler;
import org.jenkinsci.plugin.gitea.TagSCMHead;
import org.jenkinsci.plugin.gitea.TagSCMRevision;
import org.jenkinsci.plugin.gitea.client.api.GiteaCreateEvent;

public class GiteaCreateSCMEvent
extends AbstractGiteaSCMHeadEvent<GiteaCreateEvent> {
    public GiteaCreateSCMEvent(@NonNull GiteaCreateEvent payload, @CheckForNull String origin) {
        super(SCMEvent.Type.CREATED, payload, origin);
    }

    public String descriptionFor(@NonNull SCMNavigator navigator) {
        String ref = ((GiteaCreateEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Create event for " + ((GiteaCreateEvent)this.getPayload()).getRefType() + " " + ref + " in repository " + ((GiteaCreateEvent)this.getPayload()).getRepository().getName();
    }

    public String descriptionFor(SCMSource source) {
        String ref = ((GiteaCreateEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Create event for " + ((GiteaCreateEvent)this.getPayload()).getRefType() + " " + ref;
    }

    public String description() {
        String ref = ((GiteaCreateEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        return "Create event for " + ((GiteaCreateEvent)this.getPayload()).getRefType() + " " + ref + " in repository " + ((GiteaCreateEvent)this.getPayload()).getRepository().getOwner().getUsername() + "/" + ((GiteaCreateEvent)this.getPayload()).getRepository().getName();
    }

    @Override
    @NonNull
    public Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource source) {
        String ref = ((GiteaCreateEvent)this.getPayload()).getRef();
        ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        String string = ref = ref.startsWith("refs/tags/") ? ref.substring("refs/tags/".length()) : ref;
        if ("tag".equals(((GiteaCreateEvent)this.getPayload()).getRefType())) {
            TagSCMHead h = new TagSCMHead(ref, System.currentTimeMillis());
            return Collections.singletonMap(h, new TagSCMRevision(h, ((GiteaCreateEvent)this.getPayload()).getSha()));
        }
        BranchSCMHead h = new BranchSCMHead(ref);
        return Collections.singletonMap(h, new BranchSCMRevision(h, ((GiteaCreateEvent)this.getPayload()).getSha()));
    }

    @Override
    public boolean isMatch(@NonNull SCM scm) {
        URIish uri;
        try {
            uri = new URIish(((GiteaCreateEvent)this.getPayload()).getRepository().getHtmlUrl());
        }
        catch (URISyntaxException e) {
            return false;
        }
        String ref = ((GiteaCreateEvent)this.getPayload()).getRef();
        String string = ref = ref.startsWith("refs/heads/") ? ref.substring("refs/heads/".length()) : ref;
        if (scm instanceof GitSCM) {
            GitSCM git = (GitSCM)scm;
            if (git.getExtensions().get(IgnoreNotifyCommit.class) != null) {
                return false;
            }
            for (RemoteConfig repository : git.getRepositories()) {
                for (URIish remoteURL : repository.getURIs()) {
                    if (!GitStatus.looselyMatches((URIish)uri, (URIish)remoteURL)) continue;
                    for (BranchSpec branchSpec : git.getBranches()) {
                        if (branchSpec.getName().contains("$")) {
                            return true;
                        }
                        if (!branchSpec.matches(repository.getName() + "/" + ref)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Extension
    public static class HandlerImpl
    extends GiteaWebhookHandler<GiteaCreateSCMEvent, GiteaCreateEvent> {
        @Override
        protected GiteaCreateSCMEvent createEvent(GiteaCreateEvent payload, String origin) {
            return new GiteaCreateSCMEvent(payload, origin);
        }

        @Override
        protected void process(GiteaCreateSCMEvent event) {
            SCMHeadEvent.fireNow((SCMHeadEvent)event);
        }
    }
}

