/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import com.damnhandy.uri.template.UriTemplate;
import com.damnhandy.uri.template.UriTemplateBuilder;
import com.damnhandy.uri.template.impl.VarSpec;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class GiteaBrowser
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public GiteaBrowser(String repoUrl) {
        super(GiteaServers.normalizeServerUrl(repoUrl));
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(UriTemplate.buildFromTemplate((String)this.getRepoUrl()).literal("/commit").path(new VarSpec[]{UriTemplateBuilder.var((String)"changeSet")}).build().set("changeSet", (Object)changeSet.getId()).expand());
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType() != EditType.EDIT || path.getSrc() == null || path.getDst() == null || path.getChangeSet().getParentCommit() == null) {
            return null;
        }
        return this.diffLink(path);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.diffLink(path);
        }
        return new URL(UriTemplate.buildFromTemplate((String)this.getRepoUrl()).literal("/src").path(new VarSpec[]{UriTemplateBuilder.var((String)"changeSet")}).path(new VarSpec[]{UriTemplateBuilder.var((String)"path", (boolean)true)}).build().set("changeSet", (Object)path.getChangeSet().getId()).set("path", (Object)StringUtils.split((String)path.getPath(), (char)'/')).expand());
    }

    private URL diffLink(GitChangeSet.Path path) throws IOException {
        return new URL(UriTemplate.buildFromTemplate((String)this.getRepoUrl()).literal("/commit").path(new VarSpec[]{UriTemplateBuilder.var((String)"changeSet")}).fragment(new VarSpec[]{UriTemplateBuilder.var((String)"diff")}).build().set("changeSet", (Object)path.getChangeSet().getId()).set("diff", (Object)("diff-" + (this.getIndexOfPath(path) + 1))).expand());
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public String getDisplayName() {
            return Messages.GiteaBrowser_displayName();
        }

        public GiteaBrowser newInstance(StaplerRequest2 req, JSONObject jsonObject) throws Descriptor.FormException {
            return (GiteaBrowser)((Object)req.bindJSON(GiteaBrowser.class, jsonObject));
        }
    }
}

