/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.ListBoxModel;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.trait.Discovery;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceRequest;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.PullRequestSCMHead;
import org.jenkinsci.plugin.gitea.PullRequestSCMRevision;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class ForkPullRequestDiscoveryTrait
extends SCMSourceTrait {
    private final int strategyId;
    @NonNull
    private final SCMHeadAuthority<? super GiteaSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust;

    @DataBoundConstructor
    public ForkPullRequestDiscoveryTrait(int strategyId, @NonNull SCMHeadAuthority trust) {
        this.strategyId = strategyId;
        this.trust = trust;
    }

    public ForkPullRequestDiscoveryTrait(@NonNull Set<ChangeRequestCheckoutStrategy> strategies, @NonNull SCMHeadAuthority<? super GiteaSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> trust) {
        this((strategies.contains(ChangeRequestCheckoutStrategy.MERGE) ? 1 : 0) + (strategies.contains(ChangeRequestCheckoutStrategy.HEAD) ? 2 : 0), trust);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @NonNull
    public Set<ChangeRequestCheckoutStrategy> getStrategies() {
        switch (this.strategyId) {
            case 1: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.MERGE);
            }
            case 2: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD);
            }
            case 3: {
                return EnumSet.of(ChangeRequestCheckoutStrategy.HEAD, ChangeRequestCheckoutStrategy.MERGE);
            }
        }
        return EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
    }

    @NonNull
    public SCMHeadAuthority<? super GiteaSCMSourceRequest, ? extends ChangeRequestSCMHead2, ? extends SCMRevision> getTrust() {
        return this.trust;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GiteaSCMSourceContext ctx = (GiteaSCMSourceContext)context;
        ctx.wantForkPRs(true);
        ctx.withAuthority(this.trust);
        ctx.withForkPRStrategies(this.getStrategies());
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category instanceof ChangeRequestSCMHeadCategory;
    }

    public static class TrustEveryone
    extends SCMHeadAuthority<SCMSourceRequest, PullRequestSCMHead, PullRequestSCMRevision> {
        @DataBoundConstructor
        public TrustEveryone() {
        }

        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull PullRequestSCMHead head) {
            return true;
        }

        @Symbol(value={"giteaTrustEveryone"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_everyoneDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustContributors
    extends SCMHeadAuthority<GiteaSCMSourceRequest, PullRequestSCMHead, PullRequestSCMRevision> {
        @DataBoundConstructor
        public TrustContributors() {
        }

        protected boolean checkTrusted(@NonNull GiteaSCMSourceRequest request, @NonNull PullRequestSCMHead head) {
            return !head.getOrigin().equals((Object)SCMHeadOrigin.DEFAULT) && Util.fixNull(request.getCollaboratorNames()).contains(head.getOriginOwner());
        }

        @Symbol(value={"giteaTrustContributors"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_contributorsDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    public static class TrustNobody
    extends SCMHeadAuthority<SCMSourceRequest, PullRequestSCMHead, PullRequestSCMRevision> {
        @DataBoundConstructor
        public TrustNobody() {
        }

        public boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull PullRequestSCMHead head) {
            return false;
        }

        @Symbol(value={"giteaTrustNobody"})
        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public String getDisplayName() {
                return Messages.ForkPullRequestDiscoveryTrait_nobodyDisplayName();
            }

            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Fork.class.isAssignableFrom(originClass);
            }
        }
    }

    @Symbol(value={"giteaForkDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.ForkPullRequestDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GiteaSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GiteaSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.ForkPullRequestDiscoveryTrait_mergeOnly(), "1");
            result.add(Messages.ForkPullRequestDiscoveryTrait_headOnly(), "2");
            result.add(Messages.ForkPullRequestDiscoveryTrait_headAndMerge(), "3");
            return result;
        }

        @NonNull
        public List<SCMHeadAuthorityDescriptor> getTrustDescriptors() {
            return SCMHeadAuthority._for(GiteaSCMSourceRequest.class, PullRequestSCMHead.class, PullRequestSCMRevision.class, (Class[])new Class[]{SCMHeadOrigin.Fork.class});
        }

        @NonNull
        public SCMHeadAuthority<?, ?, ?> getDefaultTrust() {
            return new TrustContributors();
        }
    }
}

