/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.trait.SCMHeadAuthority;
import jenkins.scm.api.trait.SCMHeadAuthorityDescriptor;
import jenkins.scm.api.trait.SCMHeadFilter;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.trait.Discovery;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugin.gitea.BranchSCMHead;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceContext;
import org.jenkinsci.plugin.gitea.GiteaSCMSourceRequest;
import org.jenkinsci.plugin.gitea.Messages;
import org.jenkinsci.plugin.gitea.client.api.GiteaPullRequest;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchDiscoveryTrait
extends SCMSourceTrait {
    private final int strategyId;

    @DataBoundConstructor
    public BranchDiscoveryTrait(int strategyId) {
        this.strategyId = strategyId;
    }

    public BranchDiscoveryTrait(boolean buildBranch, boolean buildBranchWithPr, boolean buildBranchWithPrOrMain) {
        this.strategyId = (buildBranch ? 1 : 0) + (buildBranchWithPr ? 2 : 0) + (buildBranchWithPrOrMain ? 4 : 0);
    }

    public int getStrategyId() {
        return this.strategyId;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranch() {
        return (this.strategyId & 1) != 0;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranchesWithPR() {
        return (this.strategyId & 2) != 0;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isBuildBranchesWithPROrMain() {
        return (this.strategyId & 4) != 0;
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        GiteaSCMSourceContext ctx = (GiteaSCMSourceContext)context;
        ctx.wantBranches(true);
        ctx.withAuthority(new BranchSCMHeadAuthority());
        switch (this.strategyId) {
            case 1: {
                ctx.wantOriginPRs(true);
                ctx.withFilter(new ExcludeOriginPRBranchesSCMHeadFilter());
                break;
            }
            case 2: {
                ctx.wantOriginPRs(true);
                ctx.withFilter(new OnlyOriginPRBranchesSCMHeadFilter());
                break;
            }
            case 4: {
                ctx.wantOriginPRs(true);
                ctx.withFilter(new OriginPRBranchesOrMainSCMHeadFilter());
                break;
            }
        }
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category.isUncategorized();
    }

    public static class BranchSCMHeadAuthority
    extends SCMHeadAuthority<SCMSourceRequest, BranchSCMHead, SCMRevision> {
        protected boolean checkTrusted(@NonNull SCMSourceRequest request, @NonNull BranchSCMHead head) {
            return true;
        }

        @Extension
        public static class DescriptorImpl
        extends SCMHeadAuthorityDescriptor {
            public boolean isApplicableToOrigin(@NonNull Class<? extends SCMHeadOrigin> originClass) {
                return SCMHeadOrigin.Default.class.isAssignableFrom(originClass);
            }

            public String getDisplayName() {
                return Messages.BranchDiscoveryTrait_authorityDisplayName();
            }
        }
    }

    public static class ExcludeOriginPRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GiteaSCMSourceRequest) {
                for (GiteaPullRequest p : ((GiteaSCMSourceRequest)request).getPullRequests()) {
                    if (p.getHead() == null || p.getHead().getRepo() == null || p.getHead().getRepo().getOwner() == null || p.getHead().getRepo().getName() == null || p.getHead().getRef() == null) {
                        return true;
                    }
                    if (!StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getOwner().getUsername(), (String)p.getHead().getRepo().getOwner().getUsername()) || !StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getName(), (String)p.getHead().getRepo().getName()) || !StringUtils.equals((String)p.getHead().getRef(), (String)head.getName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class OnlyOriginPRBranchesSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GiteaSCMSourceRequest) {
                for (GiteaPullRequest p : ((GiteaSCMSourceRequest)request).getPullRequests()) {
                    if (p.getHead() == null || p.getHead().getRepo() == null || p.getHead().getRepo().getOwner() == null || p.getHead().getRepo().getName() == null || p.getHead().getRef() == null) {
                        return true;
                    }
                    if (!StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getOwner().getUsername(), (String)p.getHead().getRepo().getOwner().getUsername()) || !StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getName(), (String)p.getHead().getRepo().getName()) || !StringUtils.equals((String)p.getHead().getRef(), (String)head.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    public static class OriginPRBranchesOrMainSCMHeadFilter
    extends SCMHeadFilter {
        public boolean isExcluded(@NonNull SCMSourceRequest request, @NonNull SCMHead head) {
            if (head instanceof BranchSCMHead && request instanceof GiteaSCMSourceRequest) {
                if (head.getName().equalsIgnoreCase("master") || head.getName().equalsIgnoreCase("main")) {
                    return false;
                }
                for (GiteaPullRequest p : ((GiteaSCMSourceRequest)request).getPullRequests()) {
                    if (p.getHead() == null || p.getHead().getRepo() == null || p.getHead().getRepo().getOwner() == null || p.getHead().getRepo().getName() == null || p.getHead().getRef() == null) {
                        return true;
                    }
                    if (!StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getOwner().getUsername(), (String)p.getHead().getRepo().getOwner().getUsername()) || !StringUtils.equalsIgnoreCase((String)p.getBase().getRepo().getName(), (String)p.getHead().getRepo().getName()) || !StringUtils.equals((String)p.getHead().getRef(), (String)head.getName())) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    @Symbol(value={"giteaBranchDiscovery"})
    @Extension
    @Discovery
    public static class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return Messages.BranchDiscoveryTrait_displayName();
        }

        public Class<? extends SCMSourceContext> getContextClass() {
            return GiteaSCMSourceContext.class;
        }

        public Class<? extends SCMSource> getSourceClass() {
            return GiteaSCMSource.class;
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillStrategyIdItems() {
            ListBoxModel result = new ListBoxModel();
            result.add(Messages.BranchDiscoveryTrait_excludePRs(), "1");
            result.add(Messages.BranchDiscoveryTrait_onlyPRs(), "2");
            result.add(Messages.BranchDiscoveryTrait_allBranches(), "3");
            result.add(Messages.BranchDiscoveryTrait_onlyPRsOrMain(), "4");
            return result;
        }
    }
}

