/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceEvent;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigator;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.client.api.GiteaEvent;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;

public abstract class AbstractGiteaSCMSourceEvent<E extends GiteaEvent>
extends SCMSourceEvent<E> {
    public AbstractGiteaSCMSourceEvent(@NonNull SCMEvent.Type type, @NonNull E payload, @CheckForNull String origin) {
        super(type, payload, origin);
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        if (navigator instanceof GiteaSCMNavigator) {
            GiteaSCMNavigator nav = (GiteaSCMNavigator)navigator;
            return StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getOwner().getUsername(), (String)nav.getRepoOwner()) && GiteaServers.isEventFor(nav.getServerUrl(), ((GiteaEvent)this.getPayload()).getRepository().getHtmlUrl());
        }
        return false;
    }

    @NonNull
    public String getSourceName() {
        return ((GiteaEvent)this.getPayload()).getRepository().getName();
    }

    public boolean isMatch(@NonNull SCMSource source) {
        if (!(source instanceof GiteaSCMSource)) {
            return false;
        }
        GiteaSCMSource src = (GiteaSCMSource)source;
        return StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getOwner().getUsername(), (String)src.getRepoOwner()) && StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getName(), (String)src.getRepository()) && GiteaServers.isEventFor(src.getServerUrl(), ((GiteaEvent)this.getPayload()).getRepository().getHtmlUrl());
    }
}

