/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugin.gitea;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugin.gitea.GiteaSCMNavigator;
import org.jenkinsci.plugin.gitea.GiteaSCMSource;
import org.jenkinsci.plugin.gitea.client.api.GiteaEvent;
import org.jenkinsci.plugin.gitea.servers.GiteaServers;

public abstract class AbstractGiteaSCMHeadEvent<E extends GiteaEvent>
extends SCMHeadEvent<E> {
    public AbstractGiteaSCMHeadEvent(@NonNull SCMEvent.Type type, @NonNull E payload, @CheckForNull String origin) {
        super(type, payload, origin);
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        if (navigator instanceof GiteaSCMNavigator) {
            GiteaSCMNavigator nav = (GiteaSCMNavigator)navigator;
            return StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getOwner().getUsername(), (String)nav.getRepoOwner()) && GiteaServers.isEventFor(nav.getServerUrl(), ((GiteaEvent)this.getPayload()).getRepository().getHtmlUrl());
        }
        return false;
    }

    @NonNull
    public String getSourceName() {
        return ((GiteaEvent)this.getPayload()).getRepository().getName();
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        if (source instanceof GiteaSCMSource) {
            GiteaSCMSource src = (GiteaSCMSource)source;
            return StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getOwner().getUsername(), (String)src.getRepoOwner()) && StringUtils.equalsIgnoreCase((String)((GiteaEvent)this.getPayload()).getRepository().getName(), (String)src.getRepository()) && GiteaServers.isEventFor(src.getServerUrl(), ((GiteaEvent)this.getPayload()).getRepository().getHtmlUrl()) ? this.headsFor(src) : Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }

    @NonNull
    protected abstract Map<SCMHead, SCMRevision> headsFor(GiteaSCMSource var1);
}

