/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.extensions;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractDescribableImpl;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.Revision;
import hudson.plugins.git.extensions.GitClientType;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.plugins.git.util.BuildData;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.UnsupportedCommand;

public abstract class GitSCMExtension
extends AbstractDescribableImpl<GitSCMExtension> {
    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    @CheckForNull
    public Boolean isRevExcluded(GitSCM scm, GitClient git, GitChangeSet commit, TaskListener listener, BuildData buildData) throws IOException, InterruptedException, GitException {
        return null;
    }

    public FilePath getWorkingDirectory(GitSCM scm, Job<?, ?> context, FilePath workspace, EnvVars environment, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (context instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)context;
            return this.getWorkingDirectory(scm, project, workspace, environment, listener);
        }
        return null;
    }

    @Deprecated
    public FilePath getWorkingDirectory(GitSCM scm, AbstractProject<?, ?> context, FilePath workspace, EnvVars environment, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"getWorkingDirectory", (Class[])new Class[]{GitSCM.class, Job.class, FilePath.class, EnvVars.class, TaskListener.class})) {
            return this.getWorkingDirectory(scm, (Job<?, ?>)context, workspace, environment, listener);
        }
        return null;
    }

    public Revision decorateRevisionToBuild(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, Revision marked, Revision rev) throws IOException, InterruptedException, GitException {
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                return this.decorateRevisionToBuild(scm, abstractBuild, git, buildListener, marked, rev);
            }
        }
        return rev;
    }

    @Deprecated
    public Revision decorateRevisionToBuild(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, Revision marked, Revision rev) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"decorateRevisionToBuild", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class, Revision.class, Revision.class})) {
            return this.decorateRevisionToBuild(scm, (Run<?, ?>)build, git, (TaskListener)listener, marked, rev);
        }
        return rev;
    }

    public void beforeCheckout(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (this.requiresWorkspaceForPolling() && build != null && build.getClass().getName().startsWith("org.jenkinsci.plugins.workflow.job.")) {
            listener.getLogger().println("DEPRECATED: The extension that requires a workspace for polling is deprecated for Pipeline jobs. Use Pipeline-native SCM polling instead.");
        }
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                this.beforeCheckout(scm, abstractBuild, git, buildListener);
            }
        }
    }

    @Deprecated
    public void beforeCheckout(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"beforeCheckout", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class})) {
            this.beforeCheckout(scm, (Run<?, ?>)build, git, (TaskListener)listener);
        }
    }

    public void onCheckoutCompleted(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener) throws IOException, InterruptedException, GitException {
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                this.onCheckoutCompleted(scm, abstractBuild, git, buildListener);
            }
        }
    }

    @Deprecated
    public void onCheckoutCompleted(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"onCheckoutCompleted", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class})) {
            this.onCheckoutCompleted(scm, (Run<?, ?>)build, git, (TaskListener)listener);
        }
    }

    public void onClean(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
    }

    public GitClient decorate(GitSCM scm, GitClient git) throws IOException, InterruptedException, GitException {
        return git;
    }

    public void determineSupportForJGit(GitSCM scm, @NonNull UnsupportedCommand unsupportedCommand) {
    }

    public void decorateCloneCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                this.decorateCloneCommand(scm, abstractBuild, git, buildListener, cmd);
            }
        }
    }

    @Deprecated
    public void decorateCloneCommand(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, CloneCommand cmd) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"decorateCloneCommand", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class, CloneCommand.class})) {
            this.decorateCloneCommand(scm, (Run<?, ?>)build, git, (TaskListener)listener, cmd);
        }
    }

    @Deprecated
    public void decorateFetchCommand(GitSCM scm, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
    }

    public void decorateFetchCommand(GitSCM scm, @CheckForNull Run<?, ?> run, GitClient git, TaskListener listener, FetchCommand cmd) throws IOException, InterruptedException, GitException {
        this.decorateFetchCommand(scm, git, listener, cmd);
    }

    public void decorateMergeCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, MergeCommand cmd) throws IOException, InterruptedException, GitException {
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                this.decorateMergeCommand(scm, abstractBuild, git, buildListener, cmd);
            }
        }
    }

    @Deprecated
    public void decorateMergeCommand(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, MergeCommand cmd) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"decorateMergeCommand", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class, MergeCommand.class})) {
            this.decorateMergeCommand(scm, (Run<?, ?>)build, git, (TaskListener)listener, cmd);
        }
    }

    public void decorateCheckoutCommand(GitSCM scm, Run<?, ?> build, GitClient git, TaskListener listener, CheckoutCommand cmd) throws IOException, InterruptedException, GitException {
        if (build instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)build;
            if (listener instanceof BuildListener) {
                BuildListener buildListener = (BuildListener)listener;
                this.decorateCheckoutCommand(scm, abstractBuild, git, buildListener, cmd);
            }
        }
    }

    @Deprecated
    public void decorateCheckoutCommand(GitSCM scm, AbstractBuild<?, ?> build, GitClient git, BuildListener listener, CheckoutCommand cmd) throws IOException, InterruptedException, GitException {
        if (Util.isOverridden(GitSCMExtension.class, ((Object)((Object)this)).getClass(), (String)"decorateCheckoutCommand", (Class[])new Class[]{GitSCM.class, Run.class, GitClient.class, TaskListener.class, CheckoutCommand.class})) {
            this.decorateCheckoutCommand(scm, (Run<?, ?>)build, git, (TaskListener)listener, cmd);
        }
    }

    public void populateEnvironmentVariables(GitSCM scm, Map<String, String> env) {
    }

    public GitClientType getRequiredClient() {
        return GitClientType.ANY;
    }

    public boolean enableMultipleRevisionDetection() {
        return true;
    }

    public GitSCMExtensionDescriptor getDescriptor() {
        return (GitSCMExtensionDescriptor)super.getDescriptor();
    }
}

