/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Run;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.UserRemoteConfig;
import hudson.plugins.git.util.Build;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class BuildData
implements Action,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public Map<String, Build> buildsByBranchName = new HashMap<String, Build>();
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public Build lastBuild;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public String scmName;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Preserve API compatibility")
    public Set<String> remoteUrls = new HashSet<String>();
    @CheckForNull
    private Integer index;
    static final Logger LOGGER = Logger.getLogger(BuildData.class.getName());

    public BuildData() {
    }

    public BuildData(String scmName) {
        this.scmName = scmName;
    }

    public BuildData(String scmName, Collection<UserRemoteConfig> remoteConfigs) {
        this.scmName = scmName;
        for (UserRemoteConfig c : remoteConfigs) {
            this.remoteUrls.add(c.getUrl());
        }
    }

    public String getDisplayName() {
        if (this.scmName != null && !this.scmName.isEmpty()) {
            return "Git Build Data:" + this.scmName;
        }
        return "Git Build Data";
    }

    public String getIconFileName() {
        return "symbol-git-icon plugin-git";
    }

    public String getUrlName() {
        return this.index == null ? "git" : "git-" + this.index;
    }

    public void setIndex(Integer index) {
        this.index = index == null || index <= 1 ? null : index;
    }

    @CheckForNull
    public Integer getIndex() {
        return this.index;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public Run<?, ?> getOwningRun() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return null;
        }
        return (Run)req.findAncestorObject(Run.class);
    }

    public Object readResolve() {
        HashMap<String, Build> newBuildsByBranchName = new HashMap<String, Build>();
        for (Map.Entry<String, Build> buildByBranchName : this.buildsByBranchName.entrySet()) {
            String branchName = Util.fixNull((String)buildByBranchName.getKey());
            Build build = buildByBranchName.getValue();
            newBuildsByBranchName.put(branchName, build);
        }
        this.buildsByBranchName = newBuildsByBranchName;
        if (this.remoteUrls == null) {
            this.remoteUrls = new HashSet<String>();
        }
        return this;
    }

    public boolean hasBeenBuilt(ObjectId sha1) {
        return this.getLastBuild(sha1) != null;
    }

    public Build getLastBuild(ObjectId sha1) {
        if (sha1 == null) {
            LOGGER.log(Level.FINEST, "sha1 is null in getLastBuild, returning null");
            return null;
        }
        if (this.lastBuild != null) {
            if (this.lastBuild.revision != null) {
                ObjectId lastBuildRevisionSha1 = this.lastBuild.revision.getSha1();
                if (lastBuildRevisionSha1 != null) {
                    if (lastBuildRevisionSha1.equals((AnyObjectId)sha1)) {
                        LOGGER.log(Level.FINEST, "lastBuildRevisionSha1 matches sha1:{0}, returning lastBuild", sha1.getName());
                        return this.lastBuild;
                    }
                    LOGGER.log(Level.FINEST, "lastBuildRevisionSha1: {0} does not match sha1:{1}, checking lastBuild.marked", new Object[]{lastBuildRevisionSha1.getName(), sha1.getName()});
                } else {
                    LOGGER.log(Level.FINEST, "lastBuild.revision.getSha1() is null, checking lastBuild.marked");
                }
            } else {
                LOGGER.log(Level.FINEST, "lastBuild.revision is null, checking lastBuild.marked");
            }
            if (this.lastBuild.marked != null) {
                ObjectId lastBuildMarkedSha1 = this.lastBuild.marked.getSha1();
                if (lastBuildMarkedSha1 != null) {
                    if (lastBuildMarkedSha1.equals((AnyObjectId)sha1)) {
                        LOGGER.log(Level.FINEST, "lastBuildMarkedSha1 matches sha1:{0}, returning lastBuild", sha1.getName());
                        return this.lastBuild;
                    }
                    LOGGER.log(Level.FINEST, "lastBuildMarkedSha1: {0} does not match sha1:{1}", new Object[]{lastBuildMarkedSha1.getName(), sha1.getName()});
                } else {
                    LOGGER.log(Level.FINEST, "lastBuild.marked.getSha1() is null");
                }
            } else {
                LOGGER.log(Level.FINEST, "lastBuild.marked is null");
            }
        } else {
            LOGGER.log(Level.FINEST, "lastBuild is null");
        }
        for (Build b : this.buildsByBranchName.values()) {
            if (b == null || b.revision == null || b.revision.getSha1() == null) continue;
            if (b.revision.getSha1().equals((AnyObjectId)sha1)) {
                LOGGER.log(Level.FINEST, "b.lastBuildRevisionSha1 matches sha1:" + sha1.getName() + ", returning b");
                return b;
            }
            if (b.marked == null || b.marked.getSha1() == null || !b.marked.getSha1().equals((AnyObjectId)sha1)) continue;
            LOGGER.log(Level.FINEST, "b.lastBuildMarkedSha1 matches sha1:" + sha1.getName() + ", returning b");
            return b;
        }
        LOGGER.log(Level.FINEST, "No match found in getLastBuild for sha1:" + sha1.getName() + ", returning null");
        return null;
    }

    public void saveBuild(Build build) {
        this.lastBuild = build;
        for (Branch branch : build.marked.getBranches()) {
            this.buildsByBranchName.put(Util.fixNull((String)branch.getName()), build);
        }
        for (Branch branch : build.revision.getBranches()) {
            this.buildsByBranchName.put(Util.fixNull((String)branch.getName()), build);
        }
    }

    public Build getLastBuildOfBranch(String branch) {
        return this.buildsByBranchName.get(branch);
    }

    @Exported
    @CheckForNull
    public Revision getLastBuiltRevision() {
        return this.lastBuild == null ? null : this.lastBuild.revision;
    }

    @Exported
    public Map<String, Build> getBuildsByBranchName() {
        return this.buildsByBranchName;
    }

    public void setScmName(String scmName) {
        this.scmName = scmName;
    }

    @Exported
    public String getScmName() {
        if (this.scmName == null) {
            this.scmName = "";
        }
        return this.scmName;
    }

    public void addRemoteUrl(String remoteUrl) {
        this.remoteUrls.add(remoteUrl);
    }

    @Exported
    public Set<String> getRemoteUrls() {
        return this.remoteUrls;
    }

    public boolean hasBeenReferenced(String remoteUrl) {
        return this.remoteUrls.contains(remoteUrl);
    }

    public BuildData clone() {
        BuildData clone;
        try {
            clone = (BuildData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning BuildData", e);
        }
        IdentityHashMap<Build, Build> clonedBuilds = new IdentityHashMap<Build, Build>();
        clone.buildsByBranchName = new HashMap<String, Build>();
        clone.remoteUrls = new HashSet<String>();
        for (Map.Entry<String, Build> buildByBranchName : this.buildsByBranchName.entrySet()) {
            Build build;
            Build clonedBuild;
            String branchName = buildByBranchName.getKey();
            if (branchName == null) {
                branchName = "";
            }
            if ((clonedBuild = (Build)clonedBuilds.get(build = buildByBranchName.getValue())) == null) {
                clonedBuild = build.clone();
                clonedBuilds.put(build, clonedBuild);
            }
            clone.buildsByBranchName.put(branchName, clonedBuild);
        }
        if (this.lastBuild != null) {
            clone.lastBuild = (Build)clonedBuilds.get(this.lastBuild);
            if (clone.lastBuild == null) {
                clone.lastBuild = this.lastBuild.clone();
                clonedBuilds.put(this.lastBuild, clone.lastBuild);
            }
        }
        for (String remoteUrl : this.getRemoteUrls()) {
            clone.addRemoteUrl(remoteUrl);
        }
        return clone;
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public String toString() {
        String scmNameString = this.scmName == null ? "<null>" : this.scmName;
        return super.toString() + "[scmName=" + scmNameString + ",remoteUrls=" + String.valueOf(this.remoteUrls) + ",buildsByBranchName=" + String.valueOf(this.buildsByBranchName) + ",lastBuild=" + String.valueOf(this.lastBuild) + "]";
    }

    private String normalize(String url) {
        if (url == null) {
            return null;
        }
        String normalized = url.replaceAll("/+$", "").replaceAll("[.]git$", "");
        if (url.contains("://")) {
            try {
                URI uri = new URI(normalized);
                normalized = uri.normalize().toString();
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.FINEST, "URI syntax exception on " + url, ex);
            }
        }
        return normalized;
    }

    public boolean similarTo(BuildData that) {
        if (that == null) {
            return false;
        }
        if (this.remoteUrls == null ^ that.remoteUrls == null) {
            return false;
        }
        if (!Objects.equals(this.lastBuild, that.lastBuild)) {
            return false;
        }
        HashSet<String> thisUrls = new HashSet<String>(this.remoteUrls.size());
        for (String url : this.remoteUrls) {
            thisUrls.add(this.normalize(url));
        }
        HashSet<String> thatUrls = new HashSet<String>(that.remoteUrls.size());
        for (String url : that.remoteUrls) {
            thatUrls.add(this.normalize(url));
        }
        return thisUrls.equals(thatUrls);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildData that = (BuildData)o;
        return Objects.equals(this.remoteUrls, that.remoteUrls) && Objects.equals(this.buildsByBranchName, that.buildsByBranchName) && Objects.equals(this.lastBuild, that.lastBuild);
    }

    public int hashCode() {
        return Objects.hash(this.remoteUrls, this.buildsByBranchName, this.lastBuild);
    }
}

