/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import hudson.remoting.VirtualChannel;
import java.io.IOException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

class MergeBaseSelector
implements RepositoryCallback<String> {
    private static final long serialVersionUID = 163631519980916591L;
    private final String latestCommit;

    MergeBaseSelector(String latestCommit) {
        this.latestCommit = latestCommit;
    }

    public String invoke(Repository repository, VirtualChannel virtualChannel) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return "";
        }
        ObjectId target = repository.resolve(this.latestCommit);
        RevWalk walk = new RevWalk(repository);
        walk.setRevFilter(RevFilter.MERGE_BASE);
        walk.markStart(repository.parseCommit((AnyObjectId)head));
        walk.markStart(repository.parseCommit((AnyObjectId)target));
        RevCommit next = walk.next();
        if (next == null) {
            return this.latestCommit;
        }
        return next.getId().getName();
    }
}

