/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.blame;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.PathUtil;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.blame.Blamer;
import io.jenkins.plugins.forensics.blame.BlamerFactory;
import io.jenkins.plugins.forensics.git.blame.GitBlamer;
import io.jenkins.plugins.forensics.git.util.GitRepositoryValidator;
import java.util.Optional;
import org.jenkinsci.plugins.gitclient.GitClient;

@Extension
public class GitBlamerFactory
extends BlamerFactory {
    public Optional<Blamer> createBlamer(SCM scm, Run<?, ?> build, FilePath workTree, TaskListener listener, FilteredLog logger) {
        GitRepositoryValidator validator = new GitRepositoryValidator(scm, build, workTree, listener, logger);
        if (validator.isGitRepository()) {
            GitClient client = validator.createClient();
            logger.logInfo("-> Git blamer successfully created in working tree '%s'", new Object[]{new PathUtil().getAbsolutePath(client.getWorkTree().getRemote())});
            return Optional.of(new GitBlamer(client, validator.getHead()));
        }
        logger.logInfo("-> Git blamer could not be created for SCM '%s' in working tree '%s'", new Object[]{scm, workTree});
        return Optional.empty();
    }
}

