/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable;

import org.eclipse.collections.api.factory.set.MutableSetFactory;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.mutable.MultiReaderUnifiedSet;

public enum MultiReaderMutableSetFactory implements MutableSetFactory
{
    INSTANCE;


    public <T> MutableSet<T> empty() {
        return MultiReaderUnifiedSet.newSet();
    }

    public <T> MutableSet<T> of() {
        return this.empty();
    }

    public <T> MutableSet<T> with() {
        return this.empty();
    }

    public <T> MutableSet<T> of(T ... items) {
        return this.with(items);
    }

    public <T> MutableSet<T> with(T ... items) {
        return MultiReaderUnifiedSet.newSetWith(items);
    }

    public <T> MutableSet<T> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public <T> MutableSet<T> withInitialCapacity(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        return MultiReaderUnifiedSet.newSet(capacity);
    }

    public <T> MutableSet<T> ofAll(Iterable<? extends T> iterable) {
        return this.withAll(iterable);
    }

    public <T> MutableSet<T> withAll(Iterable<? extends T> iterable) {
        return MultiReaderUnifiedSet.newSet(iterable);
    }
}

