/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableByteBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableByteSingletonBag;

public enum ImmutableByteBagFactoryImpl implements ImmutableByteBagFactory
{
    INSTANCE;


    public ImmutableByteBag empty() {
        return ImmutableByteEmptyBag.INSTANCE;
    }

    public ImmutableByteBag of() {
        return this.empty();
    }

    public ImmutableByteBag with() {
        return this.empty();
    }

    public ImmutableByteBag of(byte one) {
        return this.with(one);
    }

    public ImmutableByteBag with(byte one) {
        return new ImmutableByteSingletonBag(one);
    }

    public ImmutableByteBag of(byte ... items) {
        return this.with(items);
    }

    public ImmutableByteBag with(byte ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableByteHashBag.newBagWith(items);
    }

    public ImmutableByteBag ofAll(ByteIterable items) {
        return this.withAll(items);
    }

    public ImmutableByteBag withAll(ByteIterable items) {
        if (items instanceof ImmutableByteBag) {
            return (ImmutableByteBag)items;
        }
        return this.with(items.toArray());
    }
}

