/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.util;

import edu.hm.hafner.util.FilteredLog;
import hudson.Extension;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.git.util.GitCommitDecorator;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import io.jenkins.plugins.forensics.util.CommitDecoratorFactory;
import java.util.Optional;

@Extension
public class GitCommitDecoratorFactory
extends CommitDecoratorFactory {
    public Optional<CommitDecorator> createCommitDecorator(SCM scm, FilteredLog logger) {
        RepositoryBrowser repositoryBrowser = scm.getEffectiveBrowser();
        if (repositoryBrowser instanceof GitRepositoryBrowser) {
            logger.logInfo("-> Git commit decorator successfully obtained '%s' to render commit links", new Object[]{repositoryBrowser});
            return Optional.of(new GitCommitDecorator((GitRepositoryBrowser)repositoryBrowser));
        }
        logger.logInfo("-> Git commit decorator could not be created for SCM '%s'", new Object[]{scm});
        if (scm instanceof GitSCM) {
            return Optional.of(new GitCommitTextDecorator());
        }
        return Optional.empty();
    }
}

