/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.reference;

import edu.hm.hafner.util.FilteredLog;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.SCMListener;
import hudson.scm.SCM;
import hudson.scm.SCMRevisionState;
import io.jenkins.plugins.forensics.git.reference.BuildCommits;
import io.jenkins.plugins.forensics.git.reference.GitCommitsCollector;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import io.jenkins.plugins.forensics.git.util.GitCommitDecoratorFactory;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import io.jenkins.plugins.forensics.git.util.GitRepositoryValidator;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import io.jenkins.plugins.forensics.util.CommitDecorator;
import io.jenkins.plugins.util.LogHandler;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

@Extension
public class GitCheckoutListener
extends SCMListener {
    private static final GitCommitTextDecorator DECORATOR = new GitCommitTextDecorator();
    private static final String NO_COMMIT_FOUND = "";

    public void onCheckout(Run<?, ?> build, SCM scm, FilePath workspace, TaskListener listener, File changelogFile, SCMRevisionState pollingBaseline) {
        FilteredLog logger = new FilteredLog("Git checkout listener errors:");
        String scmKey = scm.getKey();
        if (this.hasRecordForScm(build, scmKey)) {
            this.logSkipping(logger, scmKey);
        } else {
            GitRepositoryValidator validator = new GitRepositoryValidator(scm, build, workspace, listener, logger);
            if (validator.isGitRepository()) {
                this.recordNewCommits(build, validator, logger);
            }
        }
        LogHandler logHandler = new LogHandler(listener, "GitCheckoutListener");
        logHandler.log(logger);
    }

    private void logSkipping(FilteredLog logger, String scmKey) {
        logger.logInfo("Skipping recording, since SCM '%s' already has been processed", new Object[]{scmKey});
    }

    private boolean hasRecordForScm(Run<?, ?> build, String scmKey) {
        return GitCommitsRecord.findRecordForScm(build, scmKey).isPresent();
    }

    private void recordNewCommits(Run<?, ?> build, GitRepositoryValidator gitRepository, FilteredLog logger) {
        String id = gitRepository.getId();
        logger.logInfo("Recording commits of '%s'", new Object[]{id});
        String latestRecordedCommit = this.getLatestCommitOfPreviousBuild(build, id, logger);
        GitCommitsRecord commitsRecord = this.recordNewCommits(build, gitRepository, logger, latestRecordedCommit);
        if (this.hasRecordForScm(build, id)) {
            this.logSkipping(logger, id);
        } else {
            build.addAction((Action)commitsRecord);
        }
    }

    private String getLatestCommitOfPreviousBuild(Run<?, ?> build, String scmKey, FilteredLog logger) {
        Optional<GitCommitsRecord> record = this.getPreviousRecord(build, scmKey);
        if (record.isPresent()) {
            GitCommitsRecord previous = record.get();
            logger.logInfo("Found previous build '%s' that contains recorded Git commits", new Object[]{previous.getOwner()});
            logger.logInfo("-> Starting recording of new commits since '%s'", new Object[]{DECORATOR.asText(previous.getLatestCommit())});
            return previous.getLatestCommit();
        }
        logger.logInfo("Found no previous build with recorded Git commits");
        logger.logInfo("-> Starting initial recording of commits");
        return NO_COMMIT_FOUND;
    }

    private GitCommitsRecord recordNewCommits(Run<?, ?> build, GitRepositoryValidator gitRepository, FilteredLog logger, String latestCommit) {
        BuildCommits commits = this.recordCommitsSincePreviousBuild(latestCommit, gitRepository, logger);
        String calculatedLatestCommit = commits.getMergeOrLatestCommit();
        String id = gitRepository.getId();
        if (commits.isEmpty()) {
            logger.logInfo("-> No new commits found");
        } else if (commits.size() == 1) {
            logger.logInfo("-> Recorded one new commit", new Object[]{commits.size()});
        } else {
            logger.logInfo("-> Recorded %d new commits", new Object[]{commits.size()});
        }
        if (commits.hasMerge()) {
            logger.logInfo("-> The latest commit '%s' is a merge commit", new Object[]{calculatedLatestCommit});
        }
        CommitDecorator commitDecorator = GitCommitDecoratorFactory.findCommitDecorator((SCM)gitRepository.getScm(), (FilteredLog)logger);
        return new GitCommitsRecord(build, id, logger, commits, commitDecorator.asLink(calculatedLatestCommit));
    }

    private BuildCommits recordCommitsSincePreviousBuild(String latestCommitName, GitRepositoryValidator gitRepository, FilteredLog logger) {
        try {
            RemoteResultWrapper resultWrapper = (RemoteResultWrapper)((Object)gitRepository.createClient().withRepository((RepositoryCallback)new GitCommitsCollector(latestCommitName)));
            logger.merge((FilteredLog)resultWrapper);
            return (BuildCommits)resultWrapper.getResult();
        }
        catch (IOException | InterruptedException exception) {
            logger.logException(exception, "Unable to record commits of git repository '%s'", new Object[]{gitRepository.getId()});
            return new BuildCommits(latestCommitName);
        }
    }

    private Optional<GitCommitsRecord> getPreviousRecord(Run<?, ?> currentBuild, String scmKey) {
        for (Run build = currentBuild.getPreviousBuild(); build != null; build = build.getPreviousBuild()) {
            Optional<GitCommitsRecord> record = GitCommitsRecord.findRecordForScm(build, scmKey);
            if (!record.isPresent()) continue;
            return record;
        }
        return Optional.empty();
    }
}

