/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.git.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import io.jenkins.plugins.forensics.git.miner.MergeBaseSelector;
import io.jenkins.plugins.forensics.git.miner.RepositoryStatisticsCallback;
import io.jenkins.plugins.forensics.git.reference.GitCommitsRecord;
import io.jenkins.plugins.forensics.git.util.GitCommitTextDecorator;
import io.jenkins.plugins.forensics.git.util.GitRepositoryValidator;
import io.jenkins.plugins.forensics.git.util.RemoteResultWrapper;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.CommitStatisticsBuildAction;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import io.jenkins.plugins.forensics.reference.ReferenceFinder;
import io.jenkins.plugins.forensics.util.ScmResolver;
import io.jenkins.plugins.util.LogHandler;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CommitStatisticsStep
extends Recorder
implements SimpleBuildStep {
    private static final GitCommitTextDecorator RENDERER = new GitCommitTextDecorator();
    private String scm = "";

    @DataBoundConstructor
    public CommitStatisticsStep() {
    }

    @DataBoundSetter
    public void setScm(String scm) {
        this.scm = scm;
    }

    public String getScm() {
        return this.scm;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException {
        LogHandler logHandler = new LogHandler(listener, "Git DiffStats");
        FilteredLog logger = new FilteredLog("Errors while computing diff statistics");
        logger.logInfo("Analyzing commits to obtain diff statistics for affected repository files");
        for (SCM repository : new ScmResolver().getScms(run, this.getScm())) {
            logger.logInfo("-> Checking SCM '%s'", new Object[]{repository.getKey()});
            logHandler.log(logger);
            GitRepositoryValidator validator = new GitRepositoryValidator(repository, run, workspace, listener, logger);
            if (validator.isGitRepository()) {
                try {
                    this.computeStats(run, logger, repository, validator);
                }
                catch (IOException exception) {
                    logger.logInfo("-> Skipping due to exception: %s", new Object[]{exception});
                }
            } else {
                logger.logInfo("-> Skipping not supported repository");
            }
            logHandler.log(logger);
        }
    }

    private void computeStats(Run<?, ?> run, FilteredLog logger, SCM repository, GitRepositoryValidator validator) throws IOException, InterruptedException {
        Optional possibleReferenceBuild = new ReferenceFinder().findReference(run, logger);
        if (possibleReferenceBuild.isPresent()) {
            Run referenceBuild = (Run)possibleReferenceBuild.get();
            logger.logInfo("-> Found reference build '%s'", new Object[]{referenceBuild});
            Optional<GitCommitsRecord> referenceCommits = GitCommitsRecord.findRecordForScm(referenceBuild, this.getScm());
            if (referenceCommits.isPresent()) {
                this.computeStatsBasedOnReferenceBuild(run, logger, repository, validator, referenceCommits.get());
            } else {
                logger.logInfo("-> Skipping since reference build '%s' has no recorded commits", new Object[]{referenceBuild});
            }
        } else {
            Run previousCompletedBuild = run.getPreviousCompletedBuild();
            if (previousCompletedBuild == null) {
                logger.logInfo("-> Skipping step since no previous build has been completed yet");
            } else {
                this.computeStatsBasedOnPreviousBuild(run, logger, repository, validator, previousCompletedBuild);
            }
        }
    }

    private void computeStatsBasedOnReferenceBuild(Run<?, ?> run, FilteredLog logger, SCM repository, GitRepositoryValidator validator, GitCommitsRecord referenceCommits) throws IOException, InterruptedException {
        String latestCommit = referenceCommits.getLatestCommit();
        Optional<GitCommitsRecord> targetCommits = GitCommitsRecord.findRecordForScm(run, this.getScm());
        if (targetCommits.isPresent() && targetCommits.get().contains(latestCommit)) {
            logger.logInfo("-> Current branch already contains latest commit '%s' of target branch", new Object[]{this.renderCommit(latestCommit)});
            this.extractStats(run, repository, validator.createClient(), logger, latestCommit);
            return;
        }
        String ancestor = (String)validator.createClient().withRepository((RepositoryCallback)new MergeBaseSelector(latestCommit));
        if (StringUtils.isNotEmpty((CharSequence)ancestor)) {
            logger.logInfo("-> Found best common ancestor '%s' between HEAD and target branch commit '%s'", new Object[]{this.renderCommit(ancestor), this.renderCommit(latestCommit)});
            this.extractStats(run, repository, validator.createClient(), logger, ancestor);
            return;
        }
        logger.logInfo("-> No common ancestor between HEAD and target branch commit '%s' found", new Object[]{latestCommit});
    }

    private void computeStatsBasedOnPreviousBuild(Run<?, ?> run, FilteredLog logger, SCM repository, GitRepositoryValidator validator, Run<?, ?> previousCompletedBuild) throws IOException, InterruptedException {
        String latestCommit;
        logger.logInfo("-> No reference build found, using previous build '%s' as baseline", new Object[]{previousCompletedBuild});
        Optional<GitCommitsRecord> commitsRecord = GitCommitsRecord.findRecordForScm(previousCompletedBuild, this.getScm());
        if (commitsRecord.isPresent() && StringUtils.isNotEmpty((CharSequence)(latestCommit = commitsRecord.get().getLatestCommit()))) {
            logger.logInfo("-> Found latest previous commit '%s'", new Object[]{this.renderCommit(latestCommit)});
            this.extractStats(run, repository, validator.createClient(), logger, latestCommit);
            return;
        }
        logger.logInfo("-> Skipping since previous completed build '%s' has no recorded commits", new Object[]{previousCompletedBuild});
    }

    private void extractStats(Run<?, ?> run, SCM repository, GitClient gitClient, FilteredLog logger, String ancestor) throws IOException, InterruptedException {
        RemoteResultWrapper wrapped = (RemoteResultWrapper)((Object)gitClient.withRepository((RepositoryCallback)new RepositoryStatisticsCallback(ancestor)));
        List commits = (List)wrapped.getResult();
        logger.merge((FilteredLog)wrapped);
        CommitStatistics.logCommits((List)commits, (FilteredLog)logger);
        RepositoryStatistics repositoryStatistics = new RepositoryStatistics(ancestor);
        repositoryStatistics.addAll(commits);
        run.addAction((Action)new CommitStatisticsBuildAction(run, repository.getKey(), repositoryStatistics.getLatestStatistics()));
    }

    private String renderCommit(String ancestor) {
        return RENDERER.asText(ancestor);
    }

    public Descriptor getDescriptor() {
        return (Descriptor)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"gitDiffStat"})
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Git Diff Statistics";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

