/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient.verifier;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.TaskListener;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.security.PublicKey;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import jenkins.util.SystemProperties;
import org.eclipse.jgit.internal.transport.sshd.OpenSshServerKeyDatabase;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;
import org.jenkinsci.remoting.SerializableOnlyOverRemoting;

public abstract class AbstractJGitHostKeyVerifier
implements SerializableOnlyOverRemoting {
    private TaskListener taskListener;
    private final HostKeyVerifierFactory hostKeyVerifierFactory;

    protected AbstractJGitHostKeyVerifier(TaskListener taskListener, HostKeyVerifierFactory hostKeyVerifierFactory) {
        this.taskListener = taskListener;
        this.hostKeyVerifierFactory = hostKeyVerifierFactory;
    }

    public TaskListener getTaskListener() {
        return this.taskListener;
    }

    public HostKeyVerifierFactory getHostKeyVerifierFactory() {
        return this.hostKeyVerifierFactory;
    }

    protected abstract ServerKeyDatabase.Configuration getServerKeyDatabaseConfiguration();

    public ServerKeyDatabase getServerKeyDatabase() {
        ServerKeyDatabase.Configuration configuration = this.getServerKeyDatabaseConfiguration();
        return new JenkinsServerKeyDatabase(this.askAboutKnowHostFile(), Collections.singletonList(this.hostKeyVerifierFactory.getKnownHostsFile().toPath()), configuration);
    }

    protected boolean askAboutKnowHostFile() {
        return true;
    }

    protected static class JenkinsServerKeyDatabase
    extends OpenSshServerKeyDatabase {
        private final ServerKeyDatabase.Configuration configuration;

        public JenkinsServerKeyDatabase(boolean askAboutNewFile, List<Path> defaultFiles, ServerKeyDatabase.Configuration configuration) {
            super(askAboutNewFile, defaultFiles);
            this.configuration = configuration;
        }

        public List<PublicKey> lookup(String connectAddress, InetSocketAddress remoteAddress, ServerKeyDatabase.Configuration config) {
            return super.lookup(connectAddress, remoteAddress, this.configuration);
        }

        public boolean accept(String connectAddress, InetSocketAddress remoteAddress, PublicKey serverKey, ServerKeyDatabase.Configuration config, CredentialsProvider provider) {
            return super.accept(connectAddress, remoteAddress, serverKey, this.configuration, provider);
        }
    }

    protected static class DefaultConfiguration
    implements ServerKeyDatabase.Configuration {
        private final HostKeyVerifierFactory hostKeyVerifierFactory;
        private final Supplier<ServerKeyDatabase.Configuration.StrictHostKeyChecking> supplier;

        protected DefaultConfiguration(@NonNull HostKeyVerifierFactory hostKeyVerifierFactory, @NonNull Supplier<ServerKeyDatabase.Configuration.StrictHostKeyChecking> supplier) {
            this.hostKeyVerifierFactory = hostKeyVerifierFactory;
            this.supplier = supplier;
        }

        public List<String> getUserKnownHostsFiles() {
            return List.of(this.hostKeyVerifierFactory.getKnownHostsFile().getAbsolutePath());
        }

        public List<String> getGlobalKnownHostsFiles() {
            return Collections.emptyList();
        }

        public boolean getHashKnownHosts() {
            return false;
        }

        public String getUsername() {
            return SystemProperties.getString((String)"user.name");
        }

        public ServerKeyDatabase.Configuration.StrictHostKeyChecking getStrictHostKeyChecking() {
            return this.supplier.get();
        }
    }
}

