/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.EnvironmentSpecific;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.NodeSpecific;
import hudson.tools.ToolDescriptor;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolProperty;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class GitTool
extends ToolInstallation
implements NodeSpecific<GitTool>,
EnvironmentSpecific<GitTool> {
    public static final transient String DEFAULT = "Default";
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(GitTool.class.getName());

    @DataBoundConstructor
    public GitTool(String name, String home, List<? extends ToolProperty<?>> properties) {
        super(name, home, properties);
    }

    public String getGitExe() {
        return this.getHome();
    }

    @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"}, justification="Historical check (2013)")
    private static GitTool[] getInstallations(DescriptorImpl descriptor) {
        GitTool[] installations;
        try {
            installations = (GitTool[])descriptor.getInstallations();
        }
        catch (NullPointerException e) {
            installations = new GitTool[]{};
        }
        return installations;
    }

    public static GitTool getDefaultInstallation() {
        Jenkins jenkinsInstance = Jenkins.get();
        DescriptorImpl gitTools = (DescriptorImpl)jenkinsInstance.getDescriptorByType(DescriptorImpl.class);
        GitTool tool = gitTools.getInstallation(DEFAULT);
        if (tool != null) {
            return tool;
        }
        GitTool[] installations = (GitTool[])gitTools.getInstallations();
        if (installations.length > 0) {
            return installations[0];
        }
        GitTool.onLoaded();
        return ((GitTool[])gitTools.getInstallations())[0];
    }

    public GitTool forNode(@NonNull Node node, TaskListener log) throws IOException, InterruptedException {
        return new GitTool(this.getName(), this.translateFor(node, log), Collections.emptyList());
    }

    public GitTool forEnvironment(EnvVars environment) {
        return new GitTool(this.getName(), environment.expand(this.getHome()), Collections.emptyList());
    }

    public DescriptorImpl getDescriptor() {
        Jenkins jenkinsInstance = Jenkins.getInstanceOrNull();
        if (jenkinsInstance == null) {
            throw new AssertionError((Object)"No Jenkins instance");
        }
        return (DescriptorImpl)jenkinsInstance.getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void onLoaded() {
        Jenkins jenkinsInstance = Jenkins.get();
        DescriptorImpl descriptor = (DescriptorImpl)jenkinsInstance.getDescriptor(GitTool.class);
        GitTool[] installations = GitTool.getInstallations(descriptor);
        if (installations != null && installations.length > 0) {
            LOGGER.log(Level.FINEST, "Already initialized GitTool, no need to initialize again");
            return;
        }
        String defaultGitExe = GitTool.isWindows() ? "git.exe" : "git";
        GitTool tool = new GitTool(DEFAULT, defaultGitExe, Collections.emptyList());
        descriptor.setInstallations(new GitTool[]{tool});
        descriptor.save();
    }

    private static boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }

    @Extension
    @Symbol(value={"git"})
    public static class DescriptorImpl
    extends ToolDescriptor<GitTool> {
        public DescriptorImpl() {
            this.load();
        }

        @NonNull
        public String getDisplayName() {
            return "Git";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) {
            this.setInstallations(req.bindJSONToList(this.clazz, json.get("tool")).toArray(new GitTool[0]));
            this.save();
            return true;
        }

        @RequirePOST
        public FormValidation doCheckHome(@QueryParameter File value) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            String path = value.getPath();
            return FormValidation.validateExecutable((String)path);
        }

        public GitTool getInstallation(String name) {
            for (GitTool i : (GitTool[])this.getInstallations()) {
                if (!i.getName().equals(name)) continue;
                return i;
            }
            return null;
        }

        @Deprecated
        public List<ToolDescriptor<? extends GitTool>> getApplicableDesccriptors() {
            return this.getApplicableDescriptors();
        }

        public List<ToolDescriptor<? extends GitTool>> getApplicableDescriptors() {
            ArrayList<ToolDescriptor<? extends GitTool>> r = new ArrayList<ToolDescriptor<? extends GitTool>>();
            Jenkins jenkinsInstance = Jenkins.get();
            for (ToolDescriptor td : jenkinsInstance.getDescriptorList(ToolInstallation.class)) {
                if (!GitTool.class.isAssignableFrom(td.clazz)) continue;
                r.add((ToolDescriptor<? extends GitTool>)td);
            }
            return r;
        }
    }
}

