/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitclient;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitLockFailedException;
import hudson.plugins.git.GitObject;
import hudson.plugins.git.IndexEntry;
import hudson.plugins.git.Revision;
import hudson.util.Secret;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import jenkins.util.SystemProperties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.eclipse.jgit.api.AddNoteCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.ShowNoteCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.CanceledException;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.RenameDetector;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.errors.LockFailedException;
import org.eclipse.jgit.errors.NotSupportedException;
import org.eclipse.jgit.errors.TransportException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.transport.ssh.OpenSshConfigFile;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.MaxCountRevFilter;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchConnection;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.TagOpt;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportAmazonS3;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.http.HttpConnectionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.transport.sshd.SshdSessionFactoryBuilder;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.jenkinsci.plugins.gitclient.ChangelogCommand;
import org.jenkinsci.plugins.gitclient.CheckoutCommand;
import org.jenkinsci.plugins.gitclient.CliGitAPIImpl;
import org.jenkinsci.plugins.gitclient.CloneCommand;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.InitCommand;
import org.jenkinsci.plugins.gitclient.JGitProgressMonitor;
import org.jenkinsci.plugins.gitclient.LegacyCompatibleGitAPIImpl;
import org.jenkinsci.plugins.gitclient.MergeCommand;
import org.jenkinsci.plugins.gitclient.PushCommand;
import org.jenkinsci.plugins.gitclient.RebaseCommand;
import org.jenkinsci.plugins.gitclient.RevListCommand;
import org.jenkinsci.plugins.gitclient.SubmoduleUpdateCommand;
import org.jenkinsci.plugins.gitclient.jgit.PreemptiveAuthHttpClientConnectionFactory;
import org.jenkinsci.plugins.gitclient.jgit.SmartCredentialsProvider;
import org.jenkinsci.plugins.gitclient.verifier.HostKeyVerifierFactory;

public class JGitAPIImpl
extends LegacyCompatibleGitAPIImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JGitAPIImpl.class.getName());
    private final TaskListener listener;
    private PersonIdent author;
    private PersonIdent committer;
    private final HostKeyVerifierFactory hostKeyVerifierFactory;
    private transient CredentialsProvider provider;
    public static final String SSH_CONFIG_PATH = String.valueOf(JGitAPIImpl.class) + ".sshConfigPath";
    static final int MAX_TIMEOUT = 32768;

    JGitAPIImpl(File workspace, TaskListener listener) {
        this(workspace, listener, (HostKeyVerifierFactory)null);
    }

    @Deprecated
    JGitAPIImpl(File workspace, TaskListener listener, PreemptiveAuthHttpClientConnectionFactory httpConnectionFactory) {
        this(workspace, listener, httpConnectionFactory, null);
    }

    @Deprecated
    JGitAPIImpl(File workspace, TaskListener listener, PreemptiveAuthHttpClientConnectionFactory httpConnectionFactory, HostKeyVerifierFactory hostKeyFactory) {
        super(workspace == null ? new File(".") : workspace, hostKeyFactory);
        this.listener = listener;
        this.hostKeyVerifierFactory = hostKeyFactory;
    }

    JGitAPIImpl(File workspace, TaskListener listener, HostKeyVerifierFactory hostKeyFactory) {
        super(workspace == null ? new File(".") : workspace, hostKeyFactory);
        this.listener = listener;
        this.hostKeyVerifierFactory = hostKeyFactory;
    }

    public SshdSessionFactory buildSshdSessionFactory(@NonNull HostKeyVerifierFactory hostKeyVerifierFactory) {
        if (Files.notExists(hostKeyVerifierFactory.getKnownHostsFile().toPath(), new LinkOption[0])) {
            try {
                Files.createDirectories(hostKeyVerifierFactory.getKnownHostsFile().getParentFile().toPath(), new FileAttribute[0]);
                Files.createFile(hostKeyVerifierFactory.getKnownHostsFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "could not create known hosts file", e);
            }
        }
        SmartCredentialsProvider smartCredentialsProvider = this.getProvider();
        Optional<SSHUserPrivateKey> sshUserPrivateKey = smartCredentialsProvider.getCredentials().values().stream().filter(standardCredentials -> standardCredentials instanceof SSHUserPrivateKey).map(SSHUserPrivateKey.class::cast).findFirst();
        String user = sshUserPrivateKey.map(UsernameCredentials::getUsername).orElseGet(() -> smartCredentialsProvider.getCredentials().values().stream().filter(standardCredentials -> standardCredentials instanceof StandardUsernameCredentials).map(StandardUsernameCredentials.class::cast).findFirst().map(UsernameCredentials::getUsername).orElse(null));
        SshdSessionFactoryBuilder builder = new SshdSessionFactoryBuilder().setHomeDirectory(SystemUtils.getUserHome()).setServerKeyDatabase((file, file2) -> hostKeyVerifierFactory.forJGit(null).getServerKeyDatabase()).setSshDirectory(hostKeyVerifierFactory.getKnownHostsFile().getParentFile()).setConfigStoreFactory((homeDir, configFile, localUserName) -> {
            String configFilePath = SystemProperties.getString((String)SSH_CONFIG_PATH);
            if (configFilePath != null) {
                Path path = Path.of(configFilePath, new String[0]);
                homeDir = path.toFile().getParentFile();
                configFile = path.toFile();
            }
            return new JenkinsOpenSshConfigFile(homeDir, configFile, user);
        }).setDefaultKeysProvider(file -> {
            if (sshUserPrivateKey.isPresent()) {
                try {
                    String keys = String.join((CharSequence)System.lineSeparator(), ((SSHUserPrivateKey)sshUserPrivateKey.get()).getPrivateKeys());
                    return SecurityUtils.loadKeyPairIdentities(null, () -> "key", (InputStream)IOUtils.toInputStream((String)keys, (Charset)StandardCharsets.UTF_8), (session, resourceKey, retryIndex) -> Optional.ofNullable(((SSHUserPrivateKey)sshUserPrivateKey.get()).getPassphrase()).map(Secret::getPlainText).orElse(null));
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return Collections.emptyList();
        }).setPreferredAuthentications("publickey,password");
        return builder.build(null);
    }

    @Override
    public void clearCredentials() {
        this.asSmartCredentialsProvider().clearCredentials();
    }

    @Override
    public void addCredentials(String url, StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addCredentials(url, credentials);
    }

    @Override
    public void addDefaultCredentials(StandardCredentials credentials) {
        this.asSmartCredentialsProvider().addDefaultCredentials(credentials);
    }

    private synchronized SmartCredentialsProvider asSmartCredentialsProvider() {
        if (!(this.provider instanceof SmartCredentialsProvider)) {
            this.provider = new SmartCredentialsProvider(this.listener);
        }
        return (SmartCredentialsProvider)this.provider;
    }

    public synchronized void setCredentialsProvider(CredentialsProvider prov) {
        this.provider = prov;
    }

    public SmartCredentialsProvider getProvider() {
        return this.asSmartCredentialsProvider();
    }

    @Override
    public GitClient subGit(String subdir) {
        return new JGitAPIImpl(new File(this.workspace, subdir), this.listener);
    }

    @Override
    public void setAuthor(String name, String email) throws GitException {
        this.author = new PersonIdent(name, email);
    }

    @Override
    public void setCommitter(String name, String email) throws GitException {
        this.committer = new PersonIdent(name, email);
    }

    @Override
    public void init() throws GitException, InterruptedException {
        this.init_().workspace(this.workspace.getAbsolutePath()).execute();
    }

    private void doInit(String workspace, boolean bare) throws GitException {
        try {
            Git.init().setBare(bare).setDirectory(new File(workspace)).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public CheckoutCommand checkout() {
        return new CheckoutCommand(){
            private String ref;
            private String branch;
            private boolean deleteBranch;
            private List<String> sparseCheckoutPaths = Collections.emptyList();

            @Override
            public CheckoutCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public CheckoutCommand branch(String branch) {
                this.branch = branch;
                return this;
            }

            @Override
            public CheckoutCommand deleteBranchIfExist(boolean deleteBranch) {
                this.deleteBranch = deleteBranch;
                return this;
            }

            @Override
            public CheckoutCommand sparseCheckoutPaths(List<String> sparseCheckoutPaths) {
                this.sparseCheckoutPaths = sparseCheckoutPaths == null ? Collections.emptyList() : sparseCheckoutPaths;
                return this;
            }

            @Override
            public CheckoutCommand timeout(Integer timeout) {
                return this;
            }

            private CheckoutCommand lfsCheckoutIsNotSupported() {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support LFS checkout. This flag is ignored.");
                return this;
            }

            @Override
            public CheckoutCommand lfsRemote(String lfsRemote) {
                return this.lfsCheckoutIsNotSupported();
            }

            @Override
            public CheckoutCommand lfsCredentials(StandardCredentials lfsCredentials) {
                return this.lfsCheckoutIsNotSupported();
            }

            @Override
            public void execute() throws GitException {
                if (!this.sparseCheckoutPaths.isEmpty()) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support sparse checkout.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                if (this.branch == null) {
                    JGitAPIImpl.this.doCheckoutWithResetAndRetry(this.ref);
                } else if (this.deleteBranch) {
                    JGitAPIImpl.this.doCheckoutWithResetAndRetryAndCleanBranch(this.branch, this.ref);
                } else {
                    JGitAPIImpl.this.doCheckout(this.ref, this.branch);
                }
            }
        };
    }

    private void closeRepo(Repository repo) {
        if (repo != null) {
            repo.close();
        }
    }

    private void doCheckoutWithResetAndRetry(String ref) throws GitException {
        boolean retried = false;
        Repository repo = null;
        block12: while (true) {
            try {
                repo = this.getRepository();
                try {
                    this.git(repo).reset().setMode(ResetCommand.ResetType.HARD).call();
                }
                catch (GitAPIException e) {
                    throw new GitException("Could not reset the workspace before checkout of " + ref, e);
                }
                catch (JGitInternalException e) {
                    if (e.getCause() instanceof LockFailedException) {
                        throw new GitLockFailedException("Could not lock repository. Please try again", e);
                    }
                    throw e;
                }
                if (repo.resolve(ref) != null) {
                    this.git(repo).checkout().setName(ref).setForceRefUpdate(true).call();
                    return;
                }
                ArrayList<CallSite> remoteTrackingBranches = new ArrayList<CallSite>();
                for (String remote : repo.getRemoteNames()) {
                    String matchingRemoteBranch = "refs/remotes/" + remote + "/" + ref;
                    if (repo.exactRef(matchingRemoteBranch) == null) continue;
                    remoteTrackingBranches.add((CallSite)((Object)matchingRemoteBranch));
                }
                if (remoteTrackingBranches.isEmpty()) {
                    throw new GitException("No matching revision for " + ref + " found.");
                }
                if (remoteTrackingBranches.size() > 1) {
                    throw new GitException("Found more than one matching remote tracking branches for  " + ref + " : " + String.valueOf(remoteTrackingBranches));
                }
                String matchingRemoteBranch = (String)remoteTrackingBranches.get(0);
                this.listener.getLogger().format("[WARNING] Automatically creating a local branch '%s' tracking remote branch '%s'", ref, StringUtils.removeStart((String)matchingRemoteBranch, (String)"refs/remotes/"));
                this.git(repo).checkout().setCreateBranch(true).setName(ref).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint(matchingRemoteBranch).call();
                return;
            }
            catch (CheckoutConflictException e) {
                this.closeRepo(repo);
                if (retried) {
                    throw new GitException("Could not checkout " + ref, e);
                }
                retried = true;
                repo = this.getRepository();
                Iterator iterator = e.getConflictingPaths().iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block12;
                    String path = (String)iterator.next();
                    File conflict = new File(repo.getWorkTree(), path);
                    if (conflict.delete() || !conflict.exists()) continue;
                    this.listener.getLogger().println("[WARNING] conflicting path " + String.valueOf(conflict) + " not deleted");
                }
            }
            catch (IOException | GitAPIException e) {
                throw new GitException("Could not checkout " + ref, e);
            }
            catch (JGitInternalException e) {
                if (Pattern.matches("Cannot lock.+", e.getMessage())) {
                    throw new GitLockFailedException("Could not lock repository. Please try again", e);
                }
                throw e;
            }
            finally {
                if (repo == null) continue;
                repo.close();
                continue;
            }
            break;
        }
    }

    private void doCheckout(String ref, String branch) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).checkout().setName(branch).setCreateBranch(true).setForceRefUpdate(true).setStartPoint(ref).call();
        }
        catch (GitAPIException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
    }

    private void doCheckoutWithResetAndRetryAndCleanBranch(String branch, String ref) throws GitException {
        try (Repository repo = this.getRepository();){
            RefUpdate refUpdate = repo.updateRef("refs/heads/" + branch);
            refUpdate.setNewObjectId((AnyObjectId)repo.resolve(ref));
            switch (refUpdate.forceUpdate()) {
                case NOT_ATTEMPTED: 
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: 
                case RENAMED: {
                    throw new GitException("Could not update " + branch + " to " + ref);
                }
            }
            this.doCheckoutWithResetAndRetry(branch);
        }
        catch (IOException e) {
            throw new GitException("Could not checkout " + branch + " with start point " + ref, e);
        }
    }

    @Override
    public void add(String filePattern) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).add().addFilepattern(filePattern).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    private Git git(Repository repo) {
        return Git.wrap((Repository)repo);
    }

    @Override
    public void commit(String message) throws GitException {
        try (Repository repo = this.getRepository();){
            CommitCommand cmd = this.git(repo).commit().setMessage(message).setAuthor(this.author);
            if (this.committer != null) {
                cmd.setCommitter(new PersonIdent(this.committer, new Date()));
            }
            cmd.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void branch(String name) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).branchCreate().setName(name).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void deleteBranch(String name) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).branchDelete().setForce(true).setBranchNames(new String[]{name}).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<Branch> getBranches() throws GitException {
        return this.getBranchesInternal(ListBranchCommand.ListMode.ALL);
    }

    @Override
    public Set<Branch> getRemoteBranches() throws GitException {
        return this.getBranchesInternal(ListBranchCommand.ListMode.REMOTE);
    }

    public Set<Branch> getBranchesInternal(ListBranchCommand.ListMode mode) throws GitException {
        HashSet<Branch> hashSet;
        block9: {
            Repository repo = this.getRepository();
            try {
                List refs = this.git(repo).branchList().setListMode(mode).call();
                HashSet<Branch> branches = new HashSet<Branch>(refs.size());
                for (Ref ref : refs) {
                    branches.add(new Branch(ref));
                }
                hashSet = branches;
                if (repo == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
            }
            repo.close();
        }
        return hashSet;
    }

    @Override
    public void tag(String name, String message) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).tag().setName(name).setMessage(message).setForceUpdate(true).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public boolean tagExists(String tagName) throws GitException {
        boolean bl;
        block8: {
            Repository repo = this.getRepository();
            try {
                Ref tag = repo.exactRef("refs/tags/" + tagName);
                boolean bl2 = bl = tag != null;
                if (repo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }
            repo.close();
        }
        return bl;
    }

    private void setTransportTimeout(TransportCommand transport, String operationName, Integer timeoutInMinutes) {
        if (timeoutInMinutes == null) {
            timeoutInMinutes = CliGitAPIImpl.TIMEOUT;
        }
        if (timeoutInMinutes > 32768) {
            this.listener.getLogger().println("[WARNING] JGit ignoring timeout " + timeoutInMinutes + " > 32768 for " + operationName);
            timeoutInMinutes = 32768;
        } else if (timeoutInMinutes < 1) {
            this.listener.getLogger().println("[WARNING] JGit ignoring timeout " + timeoutInMinutes + " < 1 for " + operationName);
            timeoutInMinutes = CliGitAPIImpl.TIMEOUT;
        }
        int timeoutInSeconds = 600;
        try {
            timeoutInSeconds = Math.multiplyExact(timeoutInMinutes, 60);
        }
        catch (ArithmeticException ae) {
            this.listener.getLogger().println("[WARNING] JGit ignoring excessive " + timeoutInMinutes + " minute timeout for " + operationName);
        }
        transport.setTimeout(timeoutInSeconds);
        this.listener.getLogger().println(" > JGit " + operationName + " # timeout=" + timeoutInMinutes);
    }

    private boolean unsupportedProtocol(String url) {
        return url != null && url.startsWith("amazon-s3:");
    }

    private boolean unsupportedProtocol(URIish url) {
        return url != null && this.unsupportedProtocol(url.toString());
    }

    @Override
    public FetchCommand fetch_() {
        return new FetchCommand(){
            private URIish url;
            private List<RefSpec> refspecs;
            private boolean shallow;
            private boolean shouldPrune = false;
            private Integer timeout;
            private boolean tags = true;
            private Integer depth = 1;

            @Override
            public FetchCommand from(URIish remote, List<RefSpec> refspecs) {
                this.url = remote;
                this.refspecs = refspecs;
                return this;
            }

            @Override
            @Deprecated
            public FetchCommand prune() {
                return this.prune(true);
            }

            @Override
            public FetchCommand prune(boolean prune) {
                this.shouldPrune = prune;
                return this;
            }

            @Override
            public FetchCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            public FetchCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public FetchCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            public FetchCommand depth(Integer depth) {
                this.depth = depth;
                return this;
            }

            @Override
            public void execute() throws GitException {
                try (Repository repo = JGitAPIImpl.this.getRepository();){
                    Git git = JGitAPIImpl.this.git(repo);
                    ArrayList<RefSpec> allRefSpecs = new ArrayList<RefSpec>();
                    if (this.refspecs != null) {
                        for (RefSpec rs : this.refspecs) {
                            if (rs == null) continue;
                            allRefSpecs.add(rs);
                        }
                    }
                    org.eclipse.jgit.api.FetchCommand fetch = git.fetch();
                    fetch.setTagOpt(this.tags ? TagOpt.FETCH_TAGS : TagOpt.NO_TAGS);
                    if (allRefSpecs.isEmpty() && this.tags) {
                        allRefSpecs.add(new RefSpec("+refs/tags/*:refs/tags/*"));
                    }
                    if (this.url == null) {
                        throw new GitException("FetchCommand requires a valid repository url in remote config");
                    }
                    if (JGitAPIImpl.this.unsupportedProtocol(this.url)) {
                        throw new GitException("unsupported protocol in URL " + String.valueOf(this.url));
                    }
                    fetch.setRemote(this.url.toString());
                    fetch.setCredentialsProvider((CredentialsProvider)JGitAPIImpl.this.getProvider());
                    fetch.setTransportConfigCallback(JGitAPIImpl.this.getTransportConfigCallback());
                    fetch.setRefSpecs(allRefSpecs);
                    fetch.setRemoveDeletedRefs(this.shouldPrune);
                    JGitAPIImpl.this.setTransportTimeout((TransportCommand)fetch, "fetch", this.timeout);
                    if (this.shallow) {
                        if (this.depth == null) {
                            this.depth = 1;
                        }
                        fetch.setDepth(this.depth.intValue());
                    }
                    fetch.call();
                }
                catch (GitAPIException e) {
                    throw new GitException(e);
                }
            }
        };
    }

    @Override
    @Deprecated
    public void fetch(URIish url, List<RefSpec> refspecs) throws GitException, InterruptedException {
        this.fetch_().from(url, refspecs).execute();
    }

    @Override
    @Deprecated
    public void fetch(String remoteName, RefSpec ... refspec) throws GitException {
        try (Repository repo = this.getRepository();){
            org.eclipse.jgit.api.FetchCommand fetch = this.git(repo).fetch().setTagOpt(TagOpt.FETCH_TAGS);
            if (remoteName != null) {
                fetch.setRemote(remoteName);
            }
            fetch.setCredentialsProvider((CredentialsProvider)this.getProvider());
            fetch.setTransportConfigCallback(this.getTransportConfigCallback());
            ArrayList<RefSpec> refSpecs = new ArrayList<RefSpec>();
            if (refspec != null && refspec.length > 0) {
                for (RefSpec rs : refspec) {
                    if (rs == null) continue;
                    refSpecs.add(rs);
                }
            }
            fetch.setRefSpecs(refSpecs);
            this.setTransportTimeout((TransportCommand)fetch, "fetch", CliGitAPIImpl.TIMEOUT);
            fetch.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void fetch(String remoteName, RefSpec refspec) throws GitException {
        this.fetch(remoteName, new RefSpec[]{refspec});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void ref(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try (Repository repo = this.getRepository();){
            RefUpdate refUpdate = repo.updateRef(refName);
            refUpdate.setNewObjectId((AnyObjectId)repo.exactRef("HEAD").getObjectId());
            switch (refUpdate.forceUpdate()) {
                case NOT_ATTEMPTED: 
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: 
                case RENAMED: {
                    throw new GitException("Could not update " + refName + " to HEAD");
                }
            }
            return;
        }
        catch (IOException e) {
            throw new GitException("Could not update " + refName + " to HEAD", e);
        }
    }

    @Override
    public boolean refExists(String refName) throws GitException, InterruptedException {
        boolean bl;
        block8: {
            refName = refName.replace(' ', '_');
            Repository repo = this.getRepository();
            try {
                Ref ref = repo.findRef(refName);
                boolean bl2 = bl = ref != null;
                if (repo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GitException("Error checking ref " + refName, e);
                }
            }
            repo.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteRef(String refName) throws GitException, InterruptedException {
        refName = refName.replace(' ', '_');
        try (Repository repo = this.getRepository();){
            RefUpdate refUpdate = repo.updateRef(refName);
            refUpdate.setNewObjectId((AnyObjectId)repo.exactRef("HEAD").getObjectId());
            refUpdate.setForceUpdate(true);
            switch (refUpdate.delete()) {
                case NOT_ATTEMPTED: 
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: 
                case RENAMED: {
                    throw new GitException("Could not delete " + refName);
                }
            }
            return;
        }
        catch (IOException e) {
            throw new GitException("Could not delete " + refName, e);
        }
    }

    @Override
    public Set<String> getRefNames(String refPrefix) throws GitException, InterruptedException {
        HashSet<String> hashSet;
        block9: {
            refPrefix = refPrefix.isEmpty() ? "" : refPrefix.replace(' ', '_');
            Repository repo = this.getRepository();
            try {
                List refList = repo.getRefDatabase().getRefsByPrefix(refPrefix);
                HashSet<String> refs = new HashSet<String>(refList.size());
                for (Ref ref : refList) {
                    refs.add(ref.getName());
                }
                hashSet = refs;
                if (repo == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GitException("Error retrieving refs with prefix " + refPrefix, e);
                }
            }
            repo.close();
        }
        return hashSet;
    }

    @Override
    public Map<String, ObjectId> getHeadRev(String url) throws GitException, InterruptedException {
        return this.getRemoteReferences(url, null, true, false);
    }

    private TransportConfigCallback getTransportConfigCallback() {
        return transport -> {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory((SshSessionFactory)this.buildSshdSessionFactory(this.hostKeyVerifierFactory));
            } else if (transport instanceof TransportHttp) {
                TransportHttp transportHttp = (TransportHttp)transport;
                transportHttp.setHttpConnectionFactory((HttpConnectionFactory)new PreemptiveAuthHttpClientConnectionFactory(this.getProvider()));
            } else if (transport instanceof TransportAmazonS3) {
                throw new GitException("Unsupported protocol in URL");
            }
        };
    }

    private void decorateTransport(Transport tn) {
        if (tn instanceof SshTransport) {
            SshTransport transport = (SshTransport)tn;
            transport.setSshSessionFactory((SshSessionFactory)this.buildSshdSessionFactory(this.getHostKeyFactory()));
        } else if (tn instanceof TransportHttp) {
            TransportHttp transportHttp = (TransportHttp)tn;
            transportHttp.setHttpConnectionFactory((HttpConnectionFactory)new PreemptiveAuthHttpClientConnectionFactory(this.getProvider()));
        } else if (tn instanceof TransportAmazonS3) {
            throw new GitException("Unsupported protocol in URL");
        }
    }

    @Override
    public Map<String, ObjectId> getRemoteReferences(String url, String pattern, boolean headsOnly, boolean tagsOnly) throws GitException, InterruptedException {
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        HashMap<String, ObjectId> references = new HashMap<String, ObjectId>();
        String regexPattern = null;
        if (pattern != null) {
            regexPattern = this.createRefRegexFromGlob(pattern);
        }
        try (Repository repo = this.openDummyRepository();){
            LsRemoteCommand lsRemote = new LsRemoteCommand(repo);
            if (headsOnly) {
                lsRemote.setHeads(headsOnly);
            }
            if (tagsOnly) {
                lsRemote.setTags(tagsOnly);
            }
            lsRemote.setRemote(url);
            lsRemote.setCredentialsProvider((CredentialsProvider)this.getProvider());
            lsRemote.setTransportConfigCallback(this.getTransportConfigCallback());
            this.setTransportTimeout((TransportCommand)lsRemote, "ls-remote", CliGitAPIImpl.TIMEOUT);
            Collection refs = lsRemote.call();
            for (Ref r : refs) {
                ObjectId refObjectId;
                String refName = r.getName();
                ObjectId objectId = refObjectId = r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId();
                if (regexPattern != null) {
                    if (!refName.matches(regexPattern)) continue;
                    references.put(refName, refObjectId);
                    continue;
                }
                references.put(refName, refObjectId);
            }
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new GitException(e);
        }
        return references;
    }

    @Override
    public Map<String, String> getRemoteSymbolicReferences(String url, String pattern) throws GitException, InterruptedException {
        HashMap<String, String> references = new HashMap<String, String>();
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        String regexPattern = null;
        if (pattern != null) {
            regexPattern = this.replaceGlobCharsWithRegExChars(pattern);
        }
        if (regexPattern != null && !"HEAD".matches(regexPattern)) {
            return references;
        }
        try (Repository repo = this.openDummyRepository();){
            LsRemoteCommand lsRemote = new LsRemoteCommand(repo);
            lsRemote.setRemote(url);
            lsRemote.setCredentialsProvider((CredentialsProvider)this.getProvider());
            lsRemote.setTransportConfigCallback(this.getTransportConfigCallback());
            this.setTransportTimeout((TransportCommand)lsRemote, "ls-remote", CliGitAPIImpl.TIMEOUT);
            Collection refs = lsRemote.call();
            for (Ref r : refs) {
                if (!r.isSymbolic()) continue;
                if (regexPattern == null) {
                    references.put(r.getName(), r.getTarget().getName());
                    continue;
                }
                if (!r.getName().matches(regexPattern)) continue;
                references.put(r.getName(), r.getTarget().getName());
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException(e);
        }
        return references;
    }

    private String createRefRegexFromGlob(String glob) {
        StringBuilder out = new StringBuilder();
        out.append('^');
        if (!glob.startsWith("refs/")) {
            out.append(".*/");
        }
        out.append(this.replaceGlobCharsWithRegExChars(glob));
        out.append('$');
        return out.toString();
    }

    private String replaceGlobCharsWithRegExChars(String glob) {
        StringBuilder out = new StringBuilder();
        block6: for (int i = 0; i < glob.length(); ++i) {
            char c = glob.charAt(i);
            switch (c) {
                case '*': {
                    out.append(".*");
                    continue block6;
                }
                case '?': {
                    out.append('.');
                    continue block6;
                }
                case '.': {
                    out.append("\\.");
                    continue block6;
                }
                case '\\': {
                    out.append("\\\\");
                    continue block6;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObjectId getHeadRev(String remoteRepoUrl, String branchSpec) throws GitException {
        if (this.unsupportedProtocol(remoteRepoUrl)) {
            throw new GitException("unsupported protocol in URL " + remoteRepoUrl);
        }
        try (Repository repo = this.openDummyRepository();
             Transport tn = Transport.open((Repository)repo, (URIish)new URIish(remoteRepoUrl));){
            String branchName = this.extractBranchNameFromBranchSpec(branchSpec);
            String regexBranch = this.createRefRegexFromGlob(branchName);
            this.decorateTransport(tn);
            tn.setCredentialsProvider((CredentialsProvider)this.getProvider());
            try (FetchConnection c = tn.openFetch();){
                Ref r;
                Iterator iterator = c.getRefs().iterator();
                do {
                    if (!iterator.hasNext()) return null;
                } while (!(r = (Ref)iterator.next()).getName().matches(regexBranch));
                ObjectId objectId = r.getPeeledObjectId() != null ? r.getPeeledObjectId() : r.getObjectId();
                return objectId;
            }
        }
        catch (IOException | IllegalStateException | URISyntaxException e) {
            throw new GitException(e);
        }
    }

    private Repository openDummyRepository() throws IOException {
        File tempDir = Util.createTempDir();
        return new FileRepositoryImpl(tempDir, tempDir);
    }

    @Override
    public String getRemoteUrl(String name) throws GitException {
        try (Repository repo = this.getRepository();){
            String string = repo.getConfig().getString("remote", name, "url");
            return string;
        }
    }

    @Override
    @Deprecated
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
    @NonNull
    public Repository getRepository() throws GitException {
        try {
            return ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(this.workspace)).build();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public FilePath getWorkTree() {
        return new FilePath(this.workspace);
    }

    @Override
    public void setRemoteUrl(String name, String url) throws GitException {
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        try (Repository repo = this.getRepository();){
            StoredConfig config = repo.getConfig();
            config.setString("remote", name, "url", url);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addRemoteUrl(String name, String url) throws GitException {
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        try (Repository repo = this.getRepository();){
            StoredConfig config = repo.getConfig();
            ArrayList<String> urls = new ArrayList<String>(Arrays.asList(config.getStringList("remote", name, "url")));
            urls.add(url);
            config.setStringList("remote", name, "url", urls);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void addNote(String note, String namespace) throws GitException {
        try (Repository repo = this.getRepository();){
            ObjectId head = repo.resolve("HEAD");
            AddNoteCommand cmd = this.git(repo).notesAdd();
            cmd.setMessage(this.normalizeNote(note));
            cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
            try (ObjectReader or = repo.newObjectReader();
                 RevWalk walk = new RevWalk(or);){
                cmd.setObjectId(walk.parseAny((AnyObjectId)head));
                cmd.call();
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException(e);
        }
    }

    private String normalizeNote(String note) {
        note = ((String)note).trim();
        note = ((String)note).replaceAll("\r\n", "\n").replaceAll("\n{3,}", "\n\n");
        note = (String)note + "\n";
        return note;
    }

    private String qualifyNotesNamespace(String namespace) {
        if (!((String)namespace).startsWith("refs/")) {
            namespace = "refs/notes/" + (String)namespace;
        }
        return namespace;
    }

    @Override
    public void appendNote(String note, String namespace) throws GitException {
        try (Repository repo = this.getRepository();){
            ObjectId head = repo.resolve("HEAD");
            ShowNoteCommand cmd = this.git(repo).notesShow();
            cmd.setNotesRef(this.qualifyNotesNamespace(namespace));
            try (ObjectReader or = repo.newObjectReader();
                 RevWalk walk = new RevWalk(or);){
                cmd.setObjectId(walk.parseAny((AnyObjectId)head));
                Note n = cmd.call();
                if (n == null) {
                    this.addNote(note, namespace);
                } else {
                    ObjectLoader ol = or.open((AnyObjectId)n.getData());
                    StringWriter sw = new StringWriter();
                    IOUtils.copy((Reader)new InputStreamReader((InputStream)ol.openStream(), StandardCharsets.UTF_8), (Writer)sw);
                    sw.write("\n");
                    this.addNote(String.valueOf(sw) + this.normalizeNote(note), namespace);
                }
            }
        }
        catch (IOException | GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public ChangelogCommand changelog() throws GitException {
        return new ChangelogCommand(){
            private Repository repo;
            private ObjectReader or;
            private RevWalk walk;
            private Writer out;
            private boolean hasIncludedRev;
            {
                this.repo = JGitAPIImpl.this.getRepository();
                this.or = this.repo.newObjectReader();
                this.walk = new RevWalk(this.or);
                this.hasIncludedRev = false;
            }

            @Override
            public ChangelogCommand excludes(String rev) throws GitException {
                try {
                    return this.excludes(this.repo.resolve(rev));
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            @Override
            public ChangelogCommand excludes(ObjectId rev) throws GitException {
                try {
                    this.walk.markUninteresting(this.walk.lookupCommit((AnyObjectId)rev));
                    return this;
                }
                catch (IOException e) {
                    throw new GitException("Error: jgit excludes() in " + String.valueOf(JGitAPIImpl.this.workspace) + " " + e.getMessage(), e);
                }
            }

            @Override
            public ChangelogCommand includes(String rev) throws GitException {
                try {
                    this.includes(this.repo.resolve(rev));
                    this.hasIncludedRev = true;
                    return this;
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }

            @Override
            public ChangelogCommand includes(ObjectId rev) throws GitException {
                try {
                    this.walk.markStart(this.walk.lookupCommit((AnyObjectId)rev));
                    this.hasIncludedRev = true;
                    return this;
                }
                catch (IOException e) {
                    throw new GitException("Error: jgit includes() in " + String.valueOf(JGitAPIImpl.this.workspace) + " " + e.getMessage(), e);
                }
            }

            @Override
            public ChangelogCommand to(Writer w) {
                this.out = w;
                return this;
            }

            @Override
            public ChangelogCommand max(int n) {
                this.walk.setRevFilter(MaxCountRevFilter.create((int)n));
                return this;
            }

            private void closeResources() {
                this.walk.close();
                this.or.close();
                this.repo.close();
            }

            @Override
            public void abort() {
                this.closeResources();
            }

            @Override
            public void execute() throws GitException {
                if (this.out == null) {
                    throw new IllegalStateException();
                }
                try (PrintWriter pw = new PrintWriter(this.out, false);){
                    RawFormatter formatter = new RawFormatter();
                    if (!this.hasIncludedRev) {
                        this.includes("HEAD");
                    }
                    for (RevCommit commit : this.walk) {
                        if (commit.getParentCount() > 1) continue;
                        formatter.format(commit, null, pw, true);
                    }
                }
                catch (IOException e) {
                    throw new GitException("Error: jgit log --raw --no-merges in " + String.valueOf(JGitAPIImpl.this.workspace) + " " + e.getMessage(), e);
                }
                finally {
                    this.closeResources();
                }
            }
        };
    }

    @Override
    public void clean(boolean cleanSubmodule) throws GitException {
        try (Repository repo = this.getRepository();){
            Git git = this.git(repo);
            git.reset().setMode(ResetCommand.ResetType.HARD).call();
            git.clean().setCleanDirectories(true).setIgnore(false).setForce(cleanSubmodule).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public void clean() throws GitException {
        this.clean(false);
    }

    @Override
    public CloneCommand clone_() {
        return new CloneCommand(){
            private String url;
            private String remote = "origin";
            private String reference;
            private boolean shallow;
            private boolean shared;
            private Integer timeout;
            private boolean tags = true;
            private List<RefSpec> refspecs;
            private Integer depth = 1;

            @Override
            public CloneCommand url(String url) {
                this.url = url;
                return this;
            }

            @Override
            public CloneCommand repositoryName(String name) {
                this.remote = name;
                return this;
            }

            @Override
            @Deprecated
            public CloneCommand shallow() {
                return this.shallow(true);
            }

            @Override
            public CloneCommand shallow(boolean shallow) {
                this.shallow = shallow;
                return this;
            }

            @Override
            @Deprecated
            public CloneCommand shared() {
                return this.shared(true);
            }

            @Override
            public CloneCommand shared(boolean shared) {
                this.shared = shared;
                return this;
            }

            @Override
            public CloneCommand reference(String reference) {
                this.reference = reference;
                return this;
            }

            @Override
            public CloneCommand refspecs(List<RefSpec> refspecs) {
                this.refspecs = new ArrayList<RefSpec>(refspecs);
                return this;
            }

            @Override
            public CloneCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public CloneCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            @Deprecated
            public CloneCommand noCheckout() {
                return this;
            }

            @Override
            public CloneCommand depth(Integer depth) {
                this.depth = depth;
                return this;
            }

            @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
            private RepositoryBuilder newRepositoryBuilder() {
                RepositoryBuilder builder = new RepositoryBuilder();
                ((RepositoryBuilder)builder.setGitDir(new File(JGitAPIImpl.this.workspace, ".git"))).readEnvironment();
                return builder;
            }

            @Override
            public void execute() throws GitException {
                try (Repository repository = null;){
                    if (JGitAPIImpl.this.unsupportedProtocol(this.url)) {
                        throw new GitException("unsupported protocol in URL " + this.url);
                    }
                    if (JGitAPIImpl.this.workspace.exists()) {
                        Util.deleteContentsRecursive((File)JGitAPIImpl.this.workspace);
                    }
                    RepositoryBuilder builder = this.newRepositoryBuilder();
                    if (this.shared) {
                        if (this.reference == null || this.reference.isEmpty()) {
                            this.reference = this.url;
                        } else {
                            JGitAPIImpl.this.listener.getLogger().println("[WARNING] Both 'shared' and 'reference' are used, shared is ignored.");
                        }
                    }
                    if (this.reference != null && !this.reference.isEmpty()) {
                        builder.addAlternateObjectDirectory(new File(this.reference));
                    }
                    repository = builder.build();
                    repository.create();
                    if (this.reference != null && !this.reference.isEmpty()) {
                        File referencePath = new File(this.reference);
                        if (!referencePath.exists()) {
                            JGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path does not exist: " + this.reference);
                        } else if (!referencePath.isDirectory()) {
                            JGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path is not a directory: " + this.reference);
                        } else {
                            File objectsPath = new File(referencePath, ".git/objects");
                            if (!objectsPath.isDirectory()) {
                                objectsPath = new File(referencePath, "objects");
                            }
                            if (!objectsPath.isDirectory()) {
                                JGitAPIImpl.this.listener.getLogger().println("[WARNING] Reference path does not contain an objects directory (no git repo?): " + String.valueOf(objectsPath));
                            } else {
                                try {
                                    File alternates = new File(JGitAPIImpl.this.workspace, ".git/objects/info/alternates");
                                    String absoluteReference = objectsPath.getAbsolutePath().replace('\\', '/');
                                    JGitAPIImpl.this.listener.getLogger().println("Using reference repository: " + this.reference);
                                    try (PrintWriter w = new PrintWriter(alternates, StandardCharsets.UTF_8);){
                                        w.print(absoluteReference);
                                    }
                                }
                                catch (FileNotFoundException e) {
                                    JGitAPIImpl.this.listener.error("Failed to setup reference");
                                }
                            }
                        }
                    }
                    repository.close();
                    repository = JGitAPIImpl.this.getRepository();
                    if (this.refspecs == null) {
                        this.refspecs = Collections.singletonList(new RefSpec("+refs/heads/*:refs/remotes/" + this.remote + "/*"));
                    }
                    org.eclipse.jgit.api.FetchCommand fetch = ((org.eclipse.jgit.api.FetchCommand)((org.eclipse.jgit.api.FetchCommand)new Git(repository).fetch().setProgressMonitor((ProgressMonitor)new JGitProgressMonitor(JGitAPIImpl.this.listener)).setRemote(this.url).setCredentialsProvider((CredentialsProvider)JGitAPIImpl.this.getProvider())).setTransportConfigCallback(JGitAPIImpl.this.getTransportConfigCallback())).setTagOpt(this.tags ? TagOpt.FETCH_TAGS : TagOpt.NO_TAGS).setRefSpecs(this.refspecs);
                    JGitAPIImpl.this.setTransportTimeout((TransportCommand)fetch, "fetch", this.timeout);
                    if (this.shallow) {
                        if (this.depth == null) {
                            this.depth = 1;
                        }
                        fetch.setDepth(this.depth.intValue());
                    }
                    fetch.call();
                    StoredConfig config = repository.getConfig();
                    config.setString("remote", this.remote, "url", this.url);
                    config.setStringList("remote", this.remote, "fetch", this.refspecs.stream().map(Object::toString).collect(Collectors.toList()));
                    config.save();
                }
            }
        };
    }

    @Override
    public MergeCommand merge() {
        return new MergeCommand(){
            private ObjectId rev;
            private MergeStrategy strategy;
            private MergeCommand.FastForwardMode fastForwardMode;
            private boolean squash;
            private boolean commit = true;
            private String comment;

            @Override
            public MergeCommand setRevisionToMerge(ObjectId rev) {
                this.rev = rev;
                return this;
            }

            @Override
            public MergeCommand setStrategy(MergeCommand.Strategy strategy) {
                if (strategy != null && !strategy.toString().isEmpty() && strategy != MergeCommand.Strategy.DEFAULT) {
                    if (strategy == MergeCommand.Strategy.OURS) {
                        this.strategy = MergeStrategy.OURS;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.RESOLVE) {
                        this.strategy = MergeStrategy.RESOLVE;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.OCTOPUS) {
                        this.strategy = MergeStrategy.SIMPLE_TWO_WAY_IN_CORE;
                        return this;
                    }
                    if (strategy == MergeCommand.Strategy.RECURSIVE_THEIRS) {
                        this.strategy = MergeStrategy.THEIRS;
                        return this;
                    }
                    JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't fully support merge strategies. This flag is ignored");
                }
                return this;
            }

            @Override
            public MergeCommand setGitPluginFastForwardMode(MergeCommand.GitPluginFastForwardMode fastForwardMode) {
                if (fastForwardMode == MergeCommand.GitPluginFastForwardMode.FF) {
                    this.fastForwardMode = MergeCommand.FastForwardMode.FF;
                } else if (fastForwardMode == MergeCommand.GitPluginFastForwardMode.FF_ONLY) {
                    this.fastForwardMode = MergeCommand.FastForwardMode.FF_ONLY;
                } else if (fastForwardMode == MergeCommand.GitPluginFastForwardMode.NO_FF) {
                    this.fastForwardMode = MergeCommand.FastForwardMode.NO_FF;
                }
                return this;
            }

            @Override
            public MergeCommand setSquash(boolean squash) {
                this.squash = squash;
                return this;
            }

            @Override
            public MergeCommand setMessage(String comment) {
                this.comment = comment;
                return this;
            }

            @Override
            public MergeCommand setCommit(boolean commit) {
                this.commit = commit;
                return this;
            }

            @Override
            public void execute() throws GitException {
                try (Repository repo = JGitAPIImpl.this.getRepository();){
                    Git git = JGitAPIImpl.this.git(repo);
                    MergeResult mergeResult = this.strategy != null ? git.merge().setMessage(this.comment).setStrategy(this.strategy).setFastForward(this.fastForwardMode).setSquash(this.squash).setCommit(this.commit).include((AnyObjectId)this.rev).call() : git.merge().setMessage(this.comment).setFastForward(this.fastForwardMode).setSquash(this.squash).setCommit(this.commit).include((AnyObjectId)this.rev).call();
                    if (!mergeResult.getMergeStatus().isSuccessful()) {
                        git.reset().setMode(ResetCommand.ResetType.HARD).call();
                        throw new GitException("Failed to merge " + String.valueOf(this.rev));
                    }
                }
                catch (GitAPIException e) {
                    throw new GitException("Failed to merge " + String.valueOf(this.rev), e);
                }
            }
        };
    }

    @Override
    public InitCommand init_() {
        return new InitCommand(){
            private String workspace;
            private boolean bare;

            @Override
            public InitCommand workspace(String workspace) {
                this.workspace = workspace;
                return this;
            }

            @Override
            public InitCommand bare(boolean bare) {
                this.bare = bare;
                return this;
            }

            @Override
            public void execute() throws GitException {
                JGitAPIImpl.this.doInit(this.workspace, this.bare);
            }
        };
    }

    @Override
    public RebaseCommand rebase() {
        return new RebaseCommand(){
            private String upstream;

            @Override
            public RebaseCommand setUpstream(String upstream) {
                this.upstream = upstream;
                return this;
            }

            @Override
            public void execute() throws GitException {
                try (Repository repo = JGitAPIImpl.this.getRepository();){
                    Git git = JGitAPIImpl.this.git(repo);
                    RebaseResult rebaseResult = git.rebase().setUpstream(this.upstream).call();
                    if (!rebaseResult.getStatus().isSuccessful()) {
                        git.rebase().setOperation(RebaseCommand.Operation.ABORT).call();
                        throw new GitException("Failed to rebase " + this.upstream);
                    }
                }
                catch (GitAPIException e) {
                    throw new GitException("Failed to rebase " + this.upstream, e);
                }
            }
        };
    }

    @Override
    public void deleteTag(String tagName) throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).tagDelete().setTags(new String[]{tagName}).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getTagMessage(String tagName) throws GitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<IndexEntry> getSubmodules(String treeIsh) throws GitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addSubmodule(String remoteURL, String subdir) throws GitException {
        if (this.unsupportedProtocol(remoteURL)) {
            throw new GitException("unsupported protocol in URL " + remoteURL);
        }
        try (Repository repo = this.getRepository();){
            this.git(repo).submoduleAdd().setPath(subdir).setURI(remoteURL).call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    public Set<String> getTagNames(String tagPattern) throws GitException {
        if (tagPattern == null) {
            tagPattern = "*";
        }
        HashSet<String> tags = new HashSet<String>();
        try (Repository repo = this.getRepository();){
            FileNameMatcher matcher = new FileNameMatcher(tagPattern, null);
            Map tagList = repo.getTags();
            for (String name : tagList.keySet()) {
                matcher.reset();
                matcher.append(name);
                if (!matcher.isMatch()) continue;
                tags.add(name);
            }
        }
        catch (InvalidPatternException e) {
            throw new GitException(e);
        }
        return tags;
    }

    @Override
    public Set<String> getRemoteTagNames(String tagPattern) throws GitException {
        HashSet<String> hashSet;
        block10: {
            if (tagPattern == null) {
                tagPattern = "*";
            }
            Repository repo = this.getRepository();
            try {
                HashSet<String> tags = new HashSet<String>();
                FileNameMatcher matcher = new FileNameMatcher(tagPattern, Character.valueOf('/'));
                List refList = repo.getRefDatabase().getRefsByPrefix("refs/tags/");
                for (Ref ref : refList) {
                    String name = ref.getName().substring("refs/tags/".length());
                    matcher.reset();
                    matcher.append(name);
                    if (!matcher.isMatch()) continue;
                    tags.add(name);
                }
                hashSet = tags;
                if (repo == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | InvalidPatternException e) {
                    throw new GitException(e);
                }
            }
            repo.close();
        }
        return hashSet;
    }

    @Override
    public boolean hasGitRepo() throws GitException {
        boolean bl;
        block8: {
            Repository repo = this.getRepository();
            try {
                bl = repo.getObjectDatabase().exists();
                if (repo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (GitException e) {
                    return false;
                }
            }
            repo.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasGitRepo(boolean checkParentDirectories) throws GitException {
        if (!checkParentDirectories) {
            return this.hasGitRepo();
        }
        if (!this.hasGitRepo(".git")) return false;
        try (Repository repo = this.getRepository();){
            if (repo.getObjectDatabase().exists()) {
                boolean bl2 = true;
                return bl2;
            }
            FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
            FileRepositoryBuilder parentRepoBuilder = (FileRepositoryBuilder)repositoryBuilder.findGitDir(this.workspace);
            boolean bl = parentRepoBuilder.getGitDir() != null;
            return bl;
        }
        catch (GitException e) {
            return false;
        }
    }

    private boolean hasGitRepo(String gitDirectory) throws GitException {
        try {
            File dotGit = new File(this.workspace, gitDirectory);
            return dotGit.exists();
        }
        catch (SecurityException ex) {
            throw new GitException("Security error when trying to check for .git. Are you sure you have correct permissions?", ex);
        }
        catch (Exception e) {
            throw new GitException("Couldn't check for .git", e);
        }
    }

    @Override
    public boolean isCommitInRepo(ObjectId commit) throws GitException {
        boolean found;
        if (commit == null) {
            return false;
        }
        try (Repository repo = this.getRepository();){
            try {
                found = repo.getObjectDatabase().has((AnyObjectId)commit);
            }
            catch (IOException ioe) {
                throw new GitException(ioe);
            }
        }
        return found;
    }

    @Override
    public void prune(RemoteConfig repository) throws GitException {
        try (Repository gitRepo = this.getRepository();){
            String remote = repository.getName();
            String prefix = "refs/remotes/" + remote + "/";
            Set<String> branches = this.listRemoteBranches(remote);
            for (Ref r : new ArrayList(gitRepo.getRefDatabase().getRefs())) {
                if (!r.getName().startsWith(prefix) || branches.contains(r.getName())) continue;
                RefUpdate update = gitRepo.updateRef(r.getName());
                update.setRefLogMessage("remote branch pruned", false);
                update.setForceUpdate(true);
                update.delete();
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new GitException(e);
        }
    }

    private Set<String> listRemoteBranches(String remote) throws GitException, NotSupportedException, TransportException, URISyntaxException {
        HashSet<String> branches = new HashSet<String>();
        try (Repository repo = this.getRepository();){
            StoredConfig config = repo.getConfig();
            String remoteUrl = config.getString("remote", remote, "url");
            if (this.unsupportedProtocol(remoteUrl)) {
                throw new GitException("unsupported protocol in URL " + remoteUrl);
            }
            try (Transport tn = Transport.open((Repository)repo, (URIish)new URIish(remoteUrl));){
                this.decorateTransport(tn);
                tn.setCredentialsProvider((CredentialsProvider)this.getProvider());
                try (FetchConnection c = tn.openFetch();){
                    for (Ref r : c.getRefs()) {
                        if (!r.getName().startsWith("refs/heads/")) continue;
                        branches.add("refs/remotes/" + remote + "/" + r.getName().substring("refs/heads/".length()));
                    }
                }
            }
        }
        return branches;
    }

    @Override
    public PushCommand push() {
        return new PushCommand(){
            private URIish remote;
            private String refspec;
            private boolean force;
            private boolean tags;
            private Integer timeout;

            @Override
            public PushCommand to(URIish remote) {
                this.remote = remote;
                return this;
            }

            @Override
            public PushCommand ref(String refspec) {
                this.refspec = refspec;
                return this;
            }

            @Override
            @Deprecated
            public PushCommand force() {
                return this.force(true);
            }

            @Override
            public PushCommand force(boolean force) {
                this.force = force;
                return this;
            }

            @Override
            public PushCommand tags(boolean tags) {
                this.tags = tags;
                return this;
            }

            @Override
            public PushCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public void execute() throws GitException {
                if (JGitAPIImpl.this.unsupportedProtocol(this.remote)) {
                    throw new GitException("unsupported protocol in URL " + String.valueOf(this.remote));
                }
                try (Repository repo = JGitAPIImpl.this.getRepository();){
                    RefSpec ref = this.refspec != null ? new RefSpec(this.fixRefSpec(this.refspec, repo)) : Transport.REFSPEC_PUSH_ALL;
                    JGitAPIImpl.this.listener.getLogger().println("RefSpec is \"" + String.valueOf(ref) + "\".");
                    Git g = JGitAPIImpl.this.git(repo);
                    StoredConfig config = g.getRepository().getConfig();
                    if (this.remote == null) {
                        throw new GitException("PushCommand requires a remote repository URL");
                    }
                    config.setString("remote", "org_jenkinsci_plugins_gitclient_JGitAPIImpl", "url", this.remote.toPrivateASCIIString());
                    org.eclipse.jgit.api.PushCommand pc = ((org.eclipse.jgit.api.PushCommand)((org.eclipse.jgit.api.PushCommand)g.push().setRemote("org_jenkinsci_plugins_gitclient_JGitAPIImpl").setRefSpecs(new RefSpec[]{ref}).setProgressMonitor((ProgressMonitor)new JGitProgressMonitor(JGitAPIImpl.this.listener)).setCredentialsProvider((CredentialsProvider)JGitAPIImpl.this.getProvider())).setTransportConfigCallback(JGitAPIImpl.this.getTransportConfigCallback())).setForce(this.force);
                    if (this.tags) {
                        pc.setPushTags();
                    }
                    JGitAPIImpl.this.setTransportTimeout((TransportCommand)pc, "push", this.timeout);
                    Iterable results = pc.call();
                    for (PushResult result : results) {
                        for (RemoteRefUpdate update : result.getRemoteUpdates()) {
                            RemoteRefUpdate.Status status = update.getStatus();
                            if (RemoteRefUpdate.Status.OK.equals((Object)status) || RemoteRefUpdate.Status.UP_TO_DATE.equals((Object)status)) continue;
                            throw new GitException(update.getMessage() + " " + String.valueOf(status) + " for '" + String.valueOf(ref) + "' refspec '" + this.refspec + "' to " + this.remote.toPrivateASCIIString());
                        }
                    }
                    config.unset("remote", "org_jenkinsci_plugins_gitclient_JGitAPIImpl", "url");
                }
                catch (IOException | GitAPIException | JGitInternalException e) {
                    throw new GitException(e);
                }
            }

            private String fixRefSpec(@NonNull String srcRefspec, Repository repository) throws IOException {
                int colon = srcRefspec.indexOf(58);
                String[] specs = new String[]{(colon != -1 ? srcRefspec.substring(0, colon) : srcRefspec).trim(), srcRefspec.substring(colon + 1).trim()};
                block6: for (int spec = 0; spec < specs.length; ++spec) {
                    if (specs[spec].isEmpty() || "HEAD".equalsIgnoreCase(specs[spec])) {
                        switch (spec) {
                            default: {
                                break;
                            }
                            case 1: {
                                specs[spec] = repository.getFullBranch();
                                break;
                            }
                        }
                        continue;
                    }
                    if (specs[spec].startsWith("refs/") || specs[spec].startsWith("+refs/")) continue;
                    switch (spec) {
                        default: {
                            Ref ref = repository.findRef(specs[spec]);
                            if (ref == null) {
                                throw new IOException("Ref %s not found.".formatted(specs[spec]));
                            }
                            specs[spec] = ref.getTarget().getName();
                            continue block6;
                        }
                        case 1: {
                            if (!specs[spec].startsWith("/")) {
                                specs[spec] = "/" + specs[spec];
                            }
                            if (!(specs[spec].startsWith("/heads/") || specs[spec].startsWith("/remotes/") || specs[spec].startsWith("/tags/"))) {
                                specs[spec] = "/heads" + specs[spec];
                            }
                            specs[spec] = "refs" + specs[spec];
                        }
                    }
                }
                return specs[0] + ":" + specs[1];
            }
        };
    }

    @Override
    public RevListCommand revList_() {
        return new RevListCommand(){
            private boolean all;
            private boolean nowalk;
            private boolean firstParent;
            private String refspec;
            private List<ObjectId> out;

            @Override
            @Deprecated
            public RevListCommand all() {
                return this.all(true);
            }

            @Override
            public RevListCommand all(boolean all) {
                this.all = all;
                return this;
            }

            @Override
            public RevListCommand nowalk(boolean nowalk) {
                this.nowalk = nowalk;
                return this;
            }

            @Override
            @Deprecated
            public RevListCommand firstParent() {
                return this.firstParent(true);
            }

            @Override
            public RevListCommand firstParent(boolean firstParent) {
                this.firstParent = firstParent;
                return this;
            }

            @Override
            public RevListCommand to(List<ObjectId> revs) {
                this.out = revs;
                return this;
            }

            @Override
            public RevListCommand reference(String reference) {
                this.refspec = reference;
                return this;
            }

            @Override
            public void execute() throws GitException {
                if (this.firstParent) {
                    throw new UnsupportedOperationException("not implemented yet");
                }
                try (Repository repo = JGitAPIImpl.this.getRepository();
                     ObjectReader or = repo.newObjectReader();
                     RevWalk walk = new RevWalk(or);){
                    if (this.nowalk) {
                        if (this.out == null) {
                            throw new GitException("RevListCommand requires a 'to' value");
                        }
                        RevCommit c = walk.parseCommit((AnyObjectId)repo.resolve(this.refspec));
                        this.out.add(c.copy());
                        if (this.all) {
                            for (Ref r : repo.getRefDatabase().getRefs()) {
                                c = walk.parseCommit((AnyObjectId)r.getObjectId());
                                this.out.add(c.copy());
                            }
                        }
                        return;
                    }
                    if (this.all) {
                        JGitAPIImpl.this.markAllRefs(walk);
                    } else if (this.refspec != null) {
                        walk.markStart(walk.parseCommit((AnyObjectId)repo.resolve(this.refspec)));
                    }
                    walk.setRetainBody(false);
                    walk.sort(RevSort.COMMIT_TIME_DESC);
                    if (this.out == null) {
                        throw new GitException("RevListCommand requires a 'to' value");
                    }
                    for (RevCommit c : walk) {
                        this.out.add(c.copy());
                    }
                }
                catch (IOException e) {
                    throw new GitException(e);
                }
            }
        };
    }

    @Override
    public List<ObjectId> revListAll() throws GitException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.all(true);
        revListCommand.to(oidList);
        try {
            revListCommand.execute();
        }
        catch (InterruptedException e) {
            throw new GitException(e);
        }
        return oidList;
    }

    @Override
    public List<ObjectId> revList(String ref) throws GitException {
        ArrayList<ObjectId> oidList = new ArrayList<ObjectId>();
        RevListCommand revListCommand = this.revList_();
        revListCommand.reference(ref);
        revListCommand.to(oidList);
        try {
            revListCommand.execute();
        }
        catch (InterruptedException e) {
            throw new GitException(e);
        }
        return oidList;
    }

    @Override
    public ObjectId revParse(String revName) throws GitException {
        ObjectId objectId;
        block9: {
            Repository repo = this.getRepository();
            try {
                ObjectId id = repo.resolve(revName + "^{commit}");
                if (id == null) {
                    throw new GitException("Unknown git object " + revName);
                }
                objectId = id;
                if (repo == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new GitException("Failed to resolve git reference " + revName, e);
                }
            }
            repo.close();
        }
        return objectId;
    }

    @Override
    public List<String> showRevision(ObjectId from, ObjectId to) throws GitException {
        return this.showRevision(from, to, true);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> showRevision(ObjectId from, ObjectId to, Boolean useRawOutput) throws GitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Iterable<JGitAPIImpl> submodules() throws GitException, IOException {
        ArrayList<JGitAPIImpl> submodules = new ArrayList<JGitAPIImpl>();
        try (Repository repo = this.getRepository();){
            SubmoduleWalk generator = SubmoduleWalk.forIndex((Repository)repo);
            while (generator.next()) {
                submodules.add(new JGitAPIImpl(generator.getDirectory(), this.listener));
            }
        }
        return submodules;
    }

    @Override
    public void submoduleClean(boolean recursive) throws GitException {
        try {
            for (JGitAPIImpl sub : this.submodules()) {
                sub.clean();
                if (!recursive) continue;
                sub.submoduleClean(true);
            }
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    public SubmoduleUpdateCommand submoduleUpdate() {
        return new SubmoduleUpdateCommand(){
            private boolean recursive = false;
            private boolean remoteTracking = false;
            private String ref = null;
            private Integer timeout;

            @Override
            public SubmoduleUpdateCommand recursive(boolean recursive) {
                this.recursive = recursive;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand remoteTracking(boolean remoteTracking) {
                this.remoteTracking = remoteTracking;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand parentCredentials(boolean parentCredentials) {
                return this;
            }

            @Override
            public SubmoduleUpdateCommand ref(String ref) {
                this.ref = ref;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand timeout(Integer timeout) {
                this.timeout = timeout;
                return this;
            }

            @Override
            public SubmoduleUpdateCommand shallow(boolean shallow) {
                if (shallow) {
                    JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit submodules do not support shallow clone. This flag is ignored");
                }
                return this;
            }

            @Override
            public SubmoduleUpdateCommand depth(Integer depth) {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit submodules do not support shallow clone and therefore depth is meaningless. This flag is ignored");
                return this;
            }

            @Override
            public SubmoduleUpdateCommand threads(int threads) {
                JGitAPIImpl.this.listener.getLogger().println("[WARNING] JGit doesn't support updating submodules in parallel. This flag is ignored");
                return this;
            }

            @Override
            public SubmoduleUpdateCommand useBranch(String submodule, String branchname) {
                return this;
            }

            @Override
            public void execute() throws GitException, InterruptedException {
                if (this.remoteTracking) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support remoteTracking submodules yet.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                if (this.ref != null && !this.ref.isEmpty()) {
                    JGitAPIImpl.this.listener.getLogger().println("[ERROR] JGit doesn't support submodule update --reference yet.");
                    throw new UnsupportedOperationException("not implemented yet");
                }
                try (Repository repo = JGitAPIImpl.this.getRepository();){
                    org.eclipse.jgit.api.SubmoduleUpdateCommand update = JGitAPIImpl.this.git(repo).submoduleUpdate();
                    update.setCredentialsProvider((CredentialsProvider)JGitAPIImpl.this.getProvider());
                    update.setTransportConfigCallback(JGitAPIImpl.this.getTransportConfigCallback());
                    JGitAPIImpl.this.setTransportTimeout((TransportCommand)update, "update", this.timeout);
                    update.call();
                    if (this.recursive) {
                        for (JGitAPIImpl sub : JGitAPIImpl.this.submodules()) {
                            sub.submoduleUpdate(this.recursive);
                        }
                    }
                }
                catch (IOException | GitAPIException e) {
                    throw new GitException(e);
                }
            }
        };
    }

    @Override
    @Deprecated
    public void merge(String refSpec) throws GitException, InterruptedException {
        try (Repository repo = this.getRepository();){
            this.merge(repo.resolve(refSpec));
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void push(RemoteConfig repository, String refspec) throws GitException, InterruptedException {
        this.push(repository.getName(), refspec);
    }

    @Override
    @Deprecated
    public List<Branch> getBranchesContaining(String revspec) throws GitException, InterruptedException {
        return this.getBranchesContaining(revspec, false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<Branch> getBranchesContaining(String revspec, boolean allBranches) throws GitException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Ref> getAllBranchRefs(boolean originBranches) throws GitException {
        ArrayList<Ref> branches = new ArrayList<Ref>();
        try (Repository repo = this.getRepository();){
            List refs;
            try {
                refs = repo.getRefDatabase().getRefs();
            }
            catch (IOException ioe) {
                throw new GitException(ioe);
            }
            for (Ref r : refs) {
                String branchName = r.getName();
                if (!branchName.startsWith("refs/heads/") && (!originBranches || !branchName.startsWith("refs/remotes/"))) continue;
                branches.add(r);
            }
        }
        return branches;
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public ObjectId mergeBase(ObjectId id1, ObjectId id2) throws GitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public String getAllLogEntries(String branch) throws GitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void markAllRefs(RevWalk walk) throws GitException, IOException {
        this.markRefs(walk, unused -> true);
    }

    private void markRefs(RevWalk walk, Predicate<Ref> filter) throws GitException, IOException {
        try (Repository repo = this.getRepository();){
            for (Ref r : repo.getRefDatabase().getRefs()) {
                if (!filter.test(r)) continue;
                RevCommit c = walk.parseCommit((AnyObjectId)r.getObjectId());
                walk.markStart(c);
            }
        }
    }

    @Override
    @Deprecated
    public void submoduleInit() throws GitException, InterruptedException {
        try (Repository repo = this.getRepository();){
            this.git(repo).submoduleInit().call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void submoduleSync() throws GitException {
        try (Repository repo = this.getRepository();){
            this.git(repo).submoduleSync().call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public String getSubmoduleUrl(String name) throws GitException, InterruptedException {
        String v = null;
        try (Repository repo = this.getRepository();){
            v = repo.getConfig().getString("submodule", name, "url");
        }
        if (v == null) {
            throw new GitException("No such submodule: " + name);
        }
        return v.trim();
    }

    @Override
    @Deprecated
    public void setSubmoduleUrl(String name, String url) throws GitException {
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        try (Repository repo = this.getRepository();){
            StoredConfig config = repo.getConfig();
            config.setString("submodule", name, "url", url);
            config.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    public void setupSubmoduleUrls(Revision rev, TaskListener listener) throws GitException {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    @Deprecated
    public void fixSubmoduleUrls(String remote, TaskListener listener) throws GitException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String describe(String tip) throws GitException, InterruptedException {
        try (Repository repo = this.getRepository();){
            RevCommit c;
            final ObjectReader or = repo.newObjectReader();
            final RevWalk w = new RevWalk(or);
            w.setRetainBody(false);
            HashMap<ObjectId, Ref> tags = new HashMap<ObjectId, Ref>();
            for (Ref r : repo.getRefDatabase().getRefsByPrefix("refs/tags/")) {
                ObjectId key = repo.getRefDatabase().peel(r).getPeeledObjectId();
                if (key == null) {
                    key = r.getObjectId();
                }
                tags.put(key, r);
            }
            final RevFlagSet allFlags = new RevFlagSet();
            class Candidate {
                final Ref tag;
                final RevFlag flag;
                int depth;

                Candidate(RevCommit commit, Ref tag) {
                    this.tag = tag;
                    this.flag = w.newFlag(tag.getName());
                    allFlags.add(this.flag);
                    w.carry(this.flag);
                    commit.add(this.flag);
                    commit.carry(this.flag);
                }

                public boolean reaches(RevCommit c) {
                    return c.has(this.flag);
                }

                public String describe(ObjectId tip) throws IOException {
                    return "%s-%d-g%s".formatted(this.tag.getName().substring("refs/tags/".length()), this.depth, or.abbreviate((AnyObjectId)tip).name());
                }
            }
            ArrayList<Candidate> candidates = new ArrayList<Candidate>();
            ObjectId tipId = repo.resolve(tip);
            Ref lucky = (Ref)tags.get(tipId);
            if (lucky != null) {
                String string2 = lucky.getName().substring("refs/tags/".length());
                return string2;
            }
            w.markStart(w.parseCommit((AnyObjectId)tipId));
            int maxCandidates = 10;
            int seen = 0;
            while ((c = w.next()) != null) {
                Ref t;
                if (!c.hasAny(allFlags) && (t = (Ref)tags.get(c)) != null) {
                    Candidate cd = new Candidate(c, t);
                    candidates.add(cd);
                    cd.depth = seen;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
                if (candidates.size() >= maxCandidates) break;
                ++seen;
            }
            while ((c = w.next()) != null) {
                if (c.hasAll(allFlags)) {
                    for (RevCommit p : c.getParents()) {
                        p.add(RevFlag.SEEN);
                    }
                    continue;
                }
                for (Candidate cd : candidates) {
                    if (cd.reaches(c)) continue;
                    ++cd.depth;
                }
            }
            if (candidates.isEmpty()) {
                throw new GitException("No tags can describe " + tip);
            }
            candidates.sort(Comparator.comparingInt(o -> o.depth));
            String string = ((Candidate)candidates.get(0)).describe(tipId);
            return string;
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Deprecated
    public List<IndexEntry> lsTree(String treeIsh, boolean recursive) throws GitException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @Deprecated
    public void reset(boolean hard) throws GitException, InterruptedException {
        try (Repository repo = this.getRepository();){
            ResetCommand reset = new ResetCommand(repo);
            reset.setMode(hard ? ResetCommand.ResetType.HARD : ResetCommand.ResetType.MIXED);
            reset.call();
        }
        catch (GitAPIException e) {
            throw new GitException(e);
        }
    }

    @Override
    @Deprecated
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
    public boolean isBareRepository(String GIT_DIR) throws GitException, InterruptedException {
        Repository repo = null;
        boolean isBare = false;
        if (GIT_DIR == null) {
            throw new GitException("Not a git repository");
        }
        try {
            repo = StringUtils.isBlank((String)GIT_DIR) || !new File(GIT_DIR).isAbsolute() ? (new File(this.workspace, ".git").exists() ? this.getRepository() : ((RepositoryBuilder)new RepositoryBuilder().setGitDir(this.workspace)).build()) : ((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(GIT_DIR))).build();
            isBare = repo.isBare();
        }
        catch (IOException ioe) {
            throw new GitException(ioe);
        }
        finally {
            if (repo != null) {
                repo.close();
            }
        }
        return isBare;
    }

    @Override
    @Deprecated
    public String getDefaultRemote(String _default_) throws GitException, InterruptedException {
        Set remotes = this.getConfig(null).getSubsections("remote");
        if (remotes.contains(_default_)) {
            return _default_;
        }
        return remotes.stream().findFirst().orElse(null);
    }

    @Override
    @Deprecated
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
    public void setRemoteUrl(String name, String url, String GIT_DIR) throws GitException, InterruptedException {
        if (this.unsupportedProtocol(url)) {
            throw new GitException("unsupported protocol in URL " + url);
        }
        try (Repository repo = ((RepositoryBuilder)new RepositoryBuilder().setGitDir(new File(GIT_DIR))).build();){
            StoredConfig config = repo.getConfig();
            config.setString("remote", name, "url", url);
            config.save();
        }
        catch (IOException ioe) {
            throw new GitException(ioe);
        }
    }

    @Override
    @Deprecated
    public String getRemoteUrl(String name, String GIT_DIR) throws GitException, InterruptedException {
        return this.getConfig(GIT_DIR).getString("remote", name, "url");
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="JGit interaction with spotbugs")
    private StoredConfig getConfig(String GIT_DIR) throws GitException {
        StoredConfig storedConfig;
        block8: {
            Repository repo = StringUtils.isBlank((String)GIT_DIR) ? this.getRepository() : ((RepositoryBuilder)new RepositoryBuilder().setWorkTree(new File(GIT_DIR))).build();
            try {
                storedConfig = repo.getConfig();
                if (repo == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (repo != null) {
                        try {
                            repo.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioe) {
                    throw new GitException(ioe);
                }
            }
            repo.close();
        }
        return storedConfig;
    }

    @Override
    public Set<GitObject> getTags() throws GitException {
        HashSet<GitObject> peeledTags = new HashSet<GitObject>();
        HashSet<String> tagNames = new HashSet<String>();
        try (Repository repo = this.getRepository();){
            Map tagsRead = repo.getTags();
            for (Map.Entry entry : tagsRead.entrySet()) {
                String tagName = (String)entry.getKey();
                Ref tagRef = (Ref)entry.getValue();
                if (!tagRef.isPeeled()) {
                    try {
                        Ref peeledRef = repo.getRefDatabase().peel(tagRef);
                        if (peeledRef.getPeeledObjectId() != null) {
                            tagRef = peeledRef;
                        }
                    }
                    catch (IOException ioe) {
                        throw new GitException(ioe);
                    }
                }
                if (tagRef.isPeeled() && tagRef.getPeeledObjectId() != null) {
                    peeledTags.add(new GitObject(tagName, tagRef.getPeeledObjectId()));
                } else if (!tagNames.contains(tagName)) {
                    peeledTags.add(new GitObject(tagName, tagRef.getObjectId()));
                }
                tagNames.add(tagName);
            }
        }
        return peeledTags;
    }

    @Override
    public boolean maintenance(String task) {
        this.listener.getLogger().println("JGIT doesn't support git maintenance. Use CLIGIT to execute maintenance tasks.");
        return false;
    }

    @Override
    public void config(GitClient.ConfigLevel configLevel, String key, String value) throws GitException, InterruptedException {
        String name;
        String section;
        if (configLevel != GitClient.ConfigLevel.LOCAL) {
            throw new GitException("JGit only supports local level config");
        }
        String[] keys = key.split("\\.");
        String subsection = null;
        if (keys.length < 2 || keys.length > 3) {
            throw new GitException("key '" + key + "' not in expected format of 'section[.subsection].name'");
        }
        if (keys.length == 2) {
            section = keys[0];
            name = keys[1];
        } else {
            section = keys[0];
            subsection = keys[1];
            name = keys[2];
        }
        StoredConfig storedConfig = this.getRepository().getConfig();
        if (value != null) {
            storedConfig.setString(section, subsection, name, value);
        } else {
            storedConfig.unset(section, subsection, name);
        }
        try {
            storedConfig.save();
        }
        catch (IOException e) {
            throw new GitException(e);
        }
    }

    private static class FileRepositoryImpl
    extends FileRepository {
        private final File tempDir;

        public FileRepositoryImpl(File gitDir, File tempDir) throws IOException {
            super(gitDir);
            this.tempDir = tempDir;
        }

        public void close() {
            super.close();
            try {
                Util.deleteRecursive((File)this.tempDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class RawFormatter {
        public static final String ISO_8601 = "yyyy-MM-dd'T'HH:mm:ssZ";

        RawFormatter() {
        }

        private boolean hasNewPath(DiffEntry d) {
            return d.getChangeType() == DiffEntry.ChangeType.COPY || d.getChangeType() == DiffEntry.ChangeType.RENAME;
        }

        private String statusOf(DiffEntry d) {
            switch (d.getChangeType()) {
                case ADD: {
                    return "A";
                }
                case MODIFY: {
                    return "M";
                }
                case DELETE: {
                    return "D";
                }
                case RENAME: {
                    return "R" + d.getScore();
                }
                case COPY: {
                    return "C" + d.getScore();
                }
            }
            throw new AssertionError((Object)("Unexpected change type: " + String.valueOf(d.getChangeType())));
        }

        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Windows git implementation requires specific line termination")
        void format(RevCommit commit, RevCommit parent, PrintWriter pw, Boolean useRawOutput) throws GitException, IOException {
            if (parent != null) {
                pw.printf("commit %s (from %s)\n", commit.name(), parent.name());
            } else {
                pw.printf("commit %s\n", commit.name());
            }
            pw.printf("tree %s\n", commit.getTree().name());
            for (RevCommit p : commit.getParents()) {
                pw.printf("parent %s\n", p.name());
            }
            FastDateFormat iso = FastDateFormat.getInstance((String)ISO_8601);
            PersonIdent a = commit.getAuthorIdent();
            pw.printf("author %s <%s> %s\n", a.getName(), a.getEmailAddress(), iso.format(a.getWhen()));
            PersonIdent c = commit.getCommitterIdent();
            pw.printf("committer %s <%s> %s\n", c.getName(), c.getEmailAddress(), iso.format(c.getWhen()));
            Object msg = commit.getFullMessage();
            if (((String)msg).endsWith("\n")) {
                msg = ((String)msg).substring(0, ((String)msg).length() - 1);
            }
            msg = ((String)msg).replace("\n", "\n    ");
            msg = "\n    " + (String)msg + "\n";
            pw.println((String)msg);
            try (Repository repo = JGitAPIImpl.this.getRepository();
                 ObjectReader or = repo.newObjectReader();
                 TreeWalk tw = new TreeWalk(or);){
                List diffs;
                if (parent != null) {
                    tw.reset(new AnyObjectId[]{parent.getTree(), commit.getTree()});
                } else if (commit.getParentCount() > 0) {
                    tw.reset(new AnyObjectId[]{commit.getParent(0).getTree(), commit.getTree()});
                } else {
                    tw.reset(new AnyObjectId[]{commit.getTree(), commit.getTree()});
                }
                tw.setRecursive(true);
                tw.setFilter(TreeFilter.ANY_DIFF);
                RenameDetector rd = new RenameDetector(repo);
                rd.reset();
                rd.addAll((Collection)DiffEntry.scan((TreeWalk)tw));
                try {
                    diffs = rd.compute(or, null);
                }
                catch (CanceledException e) {
                    throw new IOException(e);
                }
                if (useRawOutput.booleanValue()) {
                    for (DiffEntry diff : diffs) {
                        pw.printf(":%06o %06o %s %s %s\t%s", diff.getOldMode().getBits(), diff.getNewMode().getBits(), diff.getOldId().name(), diff.getNewId().name(), this.statusOf(diff), diff.getChangeType() == DiffEntry.ChangeType.ADD ? diff.getNewPath() : diff.getOldPath());
                        if (this.hasNewPath(diff)) {
                            pw.printf(" %s", diff.getNewPath());
                        }
                        pw.println();
                        pw.println();
                    }
                }
            }
        }
    }

    private static class JenkinsOpenSshConfigFile
    extends OpenSshConfigFile {
        private String userName;

        public JenkinsOpenSshConfigFile(File home, File config, String userName) {
            super(home, config, userName);
            this.userName = userName;
        }

        public OpenSshConfigFile.HostEntry lookup(String hostName, int port, String userName) {
            OpenSshConfigFile.HostEntry hostEntry = super.lookup(hostName, port, userName);
            Optional.ofNullable(this.userName).ifPresent(s -> hostEntry.setValue("User", s));
            return hostEntry;
        }

        public String getLocalUserName() {
            return this.userName;
        }
    }
}

