/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.HashtagsChanged;
import hudson.Extension;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginHashtagsChangedEvent
extends PluginGerritEvent
implements Serializable {
    private static final long serialVersionUID = -7504226521891459396L;
    private String hashtagChanged;
    private static final Logger logger = LoggerFactory.getLogger(PluginHashtagsChangedEvent.class);

    public PluginHashtagsChangedEvent() {
    }

    @DataBoundConstructor
    public PluginHashtagsChangedEvent(String hashtagChanged) {
        this.hashtagChanged = hashtagChanged;
    }

    public String getHashtagChanged() {
        return this.hashtagChanged;
    }

    @Override
    public Class getCorrespondingEventClass() {
        return HashtagsChanged.class;
    }

    @Override
    public boolean shouldTriggerOn(GerritTriggeredEvent event) {
        if (event instanceof HashtagsChanged) {
            return this.match((HashtagsChanged)event);
        }
        return false;
    }

    private boolean match(HashtagsChanged event) {
        Pattern p = Pattern.compile(this.hashtagChanged);
        logger.debug("Hashtags after change {}, added hashtags {}, removed hashtags {}", new Object[]{event.getHashtags(), event.getAddedHashtags(), event.getRemovedHashtags()});
        return event.getAddedHashtags().stream().anyMatch(tag -> p.matcher((CharSequence)tag).find()) || event.getRemovedHashtags().stream().anyMatch(tag -> p.matcher((CharSequence)tag).find());
    }

    @Extension
    @Symbol(value={"hashtagChanged"})
    public static class PluginHashtagsChangedEventDescriptor
    extends PluginGerritEvent.PluginGerritEventDescriptor {
        public String getDisplayName() {
            return Messages.HashtagChangedDisplayName();
        }
    }
}

