/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class GerritSlave
extends AbstractDescribableImpl<GerritSlave> {
    public static final int DISABLED_TIMEOUT_VALUE = 0;
    private static final String ID_JSON_KEY = "id";
    private static final String NAME_JSON_KEY = "name";
    private static final String HOST_JSON_KEY = "host";
    private static final String TIMEOUT_JSON_KEY = "timeout";
    private String id;
    private String name;
    private String host;
    private int timeoutInSeconds;

    @DataBoundConstructor
    public GerritSlave(String id, String name, String host, int timeoutInSeconds) {
        this.id = id == null || id.isEmpty() ? UUID.randomUUID().toString() : id;
        this.name = name;
        this.host = host;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public GerritSlave(String name, String host, int timeout) {
        this(null, name, host, timeout);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return this.host;
    }

    public int getTimeoutInSeconds() {
        return this.timeoutInSeconds;
    }

    public static GerritSlave createGerritSlaveFromJSON(JSONObject obj) {
        String id = obj.getString(ID_JSON_KEY);
        String name = obj.getString(NAME_JSON_KEY);
        String host = obj.getString(HOST_JSON_KEY);
        int timeout = obj.getInt(TIMEOUT_JSON_KEY);
        return new GerritSlave(id, name, host, timeout);
    }

    @Extension
    public static class GerritSlaveDescriptor
    extends Descriptor<GerritSlave> {
        public String getDisplayName() {
            return "";
        }
    }
}

