/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Branch;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.FilePath;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Hashtag;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.Topic;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import hudson.Extension;
import hudson.RelativePath;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.ComboBoxModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class GerritProject
implements Describable<GerritProject> {
    private static final String MAGIC_FILE_NAME_COMMIT_MSG = "/COMMIT_MSG";
    private static final String MAGIC_FILE_NAME_MERGE_LIST = "/MERGE_LIST";
    private static final String MAGIC_FILE_NAME_PATCHSET_LEVEL = "/PATCHSET_LEVEL";
    private CompareType compareType;
    private String pattern;
    private List<Branch> branches;
    private List<FilePath> filePaths;
    private List<Topic> topics;
    private List<Hashtag> hashtags;
    private List<FilePath> forbiddenFilePaths;
    private boolean disableStrictForbiddenFileVerification;

    public GerritProject() {
    }

    @DataBoundConstructor
    public GerritProject(CompareType compareType, String pattern, List<Branch> branches, List<Topic> topics, List<FilePath> filePaths, List<FilePath> forbiddenFilePaths, boolean disableStrictForbiddenFileVerification) {
        this.compareType = compareType;
        this.pattern = pattern;
        this.branches = branches;
        this.topics = topics;
        this.filePaths = filePaths;
        this.forbiddenFilePaths = forbiddenFilePaths;
        this.disableStrictForbiddenFileVerification = disableStrictForbiddenFileVerification;
    }

    public boolean isDisableStrictForbiddenFileVerification() {
        return this.disableStrictForbiddenFileVerification;
    }

    public void setDisableStrictForbiddenFileVerification(boolean disableStrictForbiddenFileVerification) {
        this.disableStrictForbiddenFileVerification = disableStrictForbiddenFileVerification;
    }

    public CompareType getCompareType() {
        return this.compareType;
    }

    public void setCompareType(CompareType compareType) {
        this.compareType = compareType;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public List<Branch> getBranches() {
        return this.branches;
    }

    public void setBranches(List<Branch> branches) {
        this.branches = branches;
    }

    public List<FilePath> getFilePaths() {
        return this.filePaths;
    }

    public void setFilePaths(List<FilePath> filePaths) {
        this.filePaths = filePaths;
    }

    public List<Topic> getTopics() {
        return this.topics;
    }

    public void setTopics(List<Topic> topics) {
        this.topics = topics;
    }

    public List<Hashtag> getHashtags() {
        return this.hashtags;
    }

    @DataBoundSetter
    public void setHashtags(List<Hashtag> hashtags) {
        this.hashtags = hashtags;
    }

    public List<FilePath> getForbiddenFilePaths() {
        return this.forbiddenFilePaths;
    }

    public void setForbiddenFilePaths(List<FilePath> forbiddenFilePaths) {
        this.forbiddenFilePaths = forbiddenFilePaths;
    }

    @Deprecated
    public boolean isInteresting(String project, String branch, String topic, Supplier<List<String>> files) {
        if (this.isInteresting(project, branch, topic)) {
            return this.isInterestingFile(files.get());
        }
        return false;
    }

    @Deprecated
    public boolean isInteresting(String project, String branch, String topic) {
        Change change = new Change();
        change.setProject(project);
        change.setBranch(branch);
        change.setTopic(topic);
        return this.isInteresting(change);
    }

    public boolean isInteresting(Change change, Supplier<List<String>> files) {
        if (this.isInteresting(change)) {
            return this.isInterestingFile(files.get());
        }
        return false;
    }

    public boolean isInteresting(Change change) {
        if (this.compareType.matches(this.pattern, change.getProject())) {
            for (Branch b : this.branches) {
                if (!b.isInteresting(change.getBranch())) continue;
                return this.isInterestingTopic(change.getTopic()) && this.isInterestingHashtags(change.getHashtags());
            }
        }
        return false;
    }

    private boolean isInterestingTopic(String topic) {
        if (this.topics != null && this.topics.size() > 0) {
            for (Topic t : this.topics) {
                if (!t.isInteresting(topic)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isInterestingHashtags(List<String> tags) {
        if (this.hashtags != null && this.hashtags.size() > 0) {
            return this.hashtags.stream().anyMatch(h -> h.isInteresting(tags));
        }
        return true;
    }

    private boolean isInterestingFile(List<String> files) {
        ArrayList<String> tmpFiles = new ArrayList<String>(files);
        tmpFiles.remove(MAGIC_FILE_NAME_COMMIT_MSG);
        tmpFiles.remove(MAGIC_FILE_NAME_MERGE_LIST);
        tmpFiles.remove(MAGIC_FILE_NAME_PATCHSET_LEVEL);
        boolean foundInterestingForbidden = false;
        if (this.forbiddenFilePaths != null) {
            Iterator i = tmpFiles.iterator();
            block0: while (i.hasNext()) {
                String file = (String)i.next();
                for (FilePath ffp : this.forbiddenFilePaths) {
                    if (!ffp.isInteresting(file)) continue;
                    if (!this.disableStrictForbiddenFileVerification) {
                        return false;
                    }
                    foundInterestingForbidden = true;
                    i.remove();
                    continue block0;
                }
            }
        }
        if (foundInterestingForbidden && tmpFiles.isEmpty()) {
            return false;
        }
        if (this.filePaths != null && this.filePaths.size() > 0) {
            for (FilePath f : this.filePaths) {
                if (!f.isInteresting(tmpFiles)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Descriptor<GerritProject> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<GerritProject> {
        public ComboBoxModel doFillPatternItems(@AncestorInPath Item project, @QueryParameter(value="serverName") @RelativePath(value="..") String serverName) {
            if (project == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                project.checkPermission(Item.CONFIGURE);
            }
            HashSet<String> projects = new HashSet<String>();
            if (serverName != null && !serverName.isEmpty()) {
                if ("__ANY__".equals(serverName)) {
                    for (GerritServer server : PluginImpl.getServers_()) {
                        projects.addAll(server.getGerritProjects());
                    }
                } else {
                    GerritServer server = PluginImpl.getServer_(serverName);
                    if (server != null) {
                        projects.addAll(server.getGerritProjects());
                    }
                }
            }
            return new ComboBoxModel(projects);
        }

        public String getDisplayName() {
            return "";
        }
    }
}

