/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareUtil;
import java.util.LinkedList;
import java.util.List;

public enum CompareType {
    PLAIN(new CompareUtil.PlainCompareUtil()),
    ANT(new CompareUtil.AntCompareUtil()),
    REG_EXP(new CompareUtil.RegExpCompareUtil());

    private CompareUtil util;

    public static List<String> getDisplayNames() {
        LinkedList<String> list = new LinkedList<String>();
        for (CompareType t : CompareType.values()) {
            list.add(t.getDisplayName());
        }
        return list;
    }

    public static CompareType findByDisplayName(String displayName) {
        for (CompareType t : CompareType.values()) {
            if (!t.getDisplayName().equals(displayName)) continue;
            return t;
        }
        return PLAIN;
    }

    public static CompareType findByOperator(char operator) {
        for (CompareType t : CompareType.values()) {
            if (t.getOperator() != operator) continue;
            return t;
        }
        return PLAIN;
    }

    private CompareType(CompareUtil util) {
        this.util = util;
    }

    public boolean matches(String pattern, String str) {
        return this.util.matches(pattern, str);
    }

    public String getDisplayName() {
        return this.util.getName();
    }

    public char getOperator() {
        return this.util.getOperator();
    }

    public String toString() {
        return this.getDisplayName();
    }
}

