/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class BuildCancellationPolicy
extends AbstractDescribableImpl<BuildCancellationPolicy> {
    private boolean enabled = false;
    private boolean abortNewPatchsets = false;
    private boolean abortManualPatchsets = false;
    private boolean abortSameTopic = false;
    private boolean abortAbandonedPatchsets = false;

    @DataBoundConstructor
    public BuildCancellationPolicy(boolean abortNewPatchsets, boolean abortManualPatchsets, boolean abortSameTopic, boolean abortAbandonedPatchsets) {
        this.enabled = true;
        this.abortNewPatchsets = abortNewPatchsets;
        this.abortManualPatchsets = abortManualPatchsets;
        this.abortSameTopic = abortSameTopic;
        this.abortAbandonedPatchsets = abortAbandonedPatchsets;
    }

    public BuildCancellationPolicy() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isAbortNewPatchsets() {
        return this.abortNewPatchsets;
    }

    public void setAbortNewPatchsets(boolean abortNewPatchsets) {
        this.abortNewPatchsets = abortNewPatchsets;
    }

    public boolean isAbortManualPatchsets() {
        return this.abortManualPatchsets;
    }

    public void setAbortManualPatchsets(boolean abortManualPatchsets) {
        this.abortManualPatchsets = abortManualPatchsets;
    }

    public boolean isAbortSameTopic() {
        return this.abortSameTopic;
    }

    public void setAbortSameTopic(boolean abortSameTopic) {
        this.abortSameTopic = abortSameTopic;
    }

    public boolean isAbortAbandonedPatchsets() {
        return this.abortAbandonedPatchsets;
    }

    public void setAbortAbandonedPatchsets(boolean abortAbandonedPatchsets) {
        this.abortAbandonedPatchsets = abortAbandonedPatchsets;
    }

    public static BuildCancellationPolicy createPolicyFromJSON(JSONObject obj) {
        boolean newPatchsets = obj.getBoolean("abortNewPatchsets");
        boolean manualPatchsets = obj.getBoolean("abortManualPatchsets");
        boolean abortSameTopic = obj.optBoolean("abortSameTopic");
        boolean abortAbandonedPatchsets = obj.optBoolean("abortAbandonedPatchsets");
        BuildCancellationPolicy policy = new BuildCancellationPolicy();
        policy.setEnabled(true);
        policy.setAbortNewPatchsets(newPatchsets);
        policy.setAbortManualPatchsets(manualPatchsets);
        policy.setAbortSameTopic(abortSameTopic);
        policy.setAbortAbandonedPatchsets(abortAbandonedPatchsets);
        return policy;
    }

    @Extension
    @Symbol(value={"buildCancellationPolicy"})
    public static class DescriptorImpl
    extends Descriptor<BuildCancellationPolicy> {
        public BuildCancellationPolicy newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            if (formData.has("buildCancellationPolicy")) {
                return (BuildCancellationPolicy)super.newInstance(req, formData.getJSONObject("buildCancellationPolicy"));
            }
            return null;
        }
    }
}

