/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.AbandonedPatchsetInterruption;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.NewPatchSetInterruption;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.BuildCancellationPolicy;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.model.Cause;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningJobs {
    private final GerritTrigger trigger;
    private Item job;
    private final Set<GerritTriggeredEvent> runningJobs = Collections.synchronizedSet(new HashSet());
    private static final Logger logger = LoggerFactory.getLogger(RunningJobs.class);

    public RunningJobs(GerritTrigger trigger, Item job) {
        this.trigger = trigger;
        this.job = job;
    }

    public Item getJob() {
        return this.job;
    }

    public void setJob(Item job) {
        this.job = job;
    }

    public void cancelTriggeredJob(ChangeBasedEvent event, String jobName, BuildCancellationPolicy policy) {
        if (policy == null || !policy.isEnabled()) {
            return;
        }
        if (event instanceof ManualPatchsetCreated && !policy.isAbortManualPatchsets()) {
            return;
        }
        this.cancelOutDatedEvents(event, policy, jobName);
    }

    public void scheduled(ChangeBasedEvent event) {
        IGerritHudsonTriggerConfig serverConfig = PluginImpl.getServerConfig((GerritTriggeredEvent)event);
        if (serverConfig == null) {
            this.runningJobs.add((GerritTriggeredEvent)event);
            return;
        }
        BuildCancellationPolicy serverBuildCurrentPatchesOnly = serverConfig.getBuildCurrentPatchesOnly();
        if (!serverBuildCurrentPatchesOnly.isEnabled() || event instanceof ManualPatchsetCreated && !serverBuildCurrentPatchesOnly.isAbortManualPatchsets()) {
            this.runningJobs.add((GerritTriggeredEvent)event);
            return;
        }
        this.cancelOutDatedEvents(event, serverBuildCurrentPatchesOnly, this.getJob().getFullName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelOutDatedEvents(ChangeBasedEvent event, BuildCancellationPolicy policy, String jobName) {
        ArrayList<ChangeBasedEvent> outdatedEvents = new ArrayList<ChangeBasedEvent>();
        CauseOfInterruption cause = new NewPatchSetInterruption();
        Set<GerritTriggeredEvent> set = this.runningJobs;
        synchronized (set) {
            Iterator<GerritTriggeredEvent> it = this.runningJobs.iterator();
            while (it.hasNext()) {
                ChangeBasedEvent runningChangeBasedEvent;
                GerritTriggeredEvent runningEvent = it.next();
                if (!(runningEvent instanceof ChangeBasedEvent) || this.shouldIgnoreEvent(event, policy, runningChangeBasedEvent = (ChangeBasedEvent)runningEvent)) continue;
                outdatedEvents.add(runningChangeBasedEvent);
                it.remove();
            }
            if (!outdatedEvents.contains(event)) {
                if (this.trigger.isOnlyAbortRunningBuild((GerritTriggeredEvent)event)) {
                    cause = new AbandonedPatchsetInterruption();
                } else {
                    this.runningJobs.add((GerritTriggeredEvent)event);
                }
            }
        }
        for (ChangeBasedEvent outdatedEvent : outdatedEvents) {
            logger.debug("Cancelling build for " + String.valueOf(outdatedEvent));
            try {
                this.cancelMatchingJobs((GerritTriggeredEvent)outdatedEvent, jobName, cause);
            }
            catch (Exception e) {
                logger.error("Error canceling job", (Throwable)e);
            }
        }
    }

    private boolean shouldIgnoreEvent(ChangeBasedEvent event, BuildCancellationPolicy policy, ChangeBasedEvent runningChangeBasedEvent) {
        boolean isAbortAbandonedPatchset;
        boolean shouldCancelManual;
        boolean abortBecauseOfTopic = this.trigger.abortBecauseOfTopic(event, policy, runningChangeBasedEvent);
        Change change = runningChangeBasedEvent.getChange();
        if (!abortBecauseOfTopic && !change.equals((Object)event.getChange())) {
            return true;
        }
        boolean bl = shouldCancelManual = !(runningChangeBasedEvent instanceof ManualPatchsetCreated) || policy.isAbortManualPatchsets();
        if (!abortBecauseOfTopic && !shouldCancelManual) {
            return true;
        }
        boolean hasPatchSets = runningChangeBasedEvent.getPatchSet() != null && event.getPatchSet() != null;
        boolean hasPatchNumbers = hasPatchSets && runningChangeBasedEvent.getPatchSet().getNumber() != null && event.getPatchSet().getNumber() != null;
        boolean isOldPatch = hasPatchSets && hasPatchNumbers && Integer.parseInt(runningChangeBasedEvent.getPatchSet().getNumber()) < Integer.parseInt(event.getPatchSet().getNumber());
        boolean shouldCancelPatchsetNumber = policy.isAbortNewPatchsets() || isOldPatch;
        boolean bl2 = isAbortAbandonedPatchset = policy.isAbortAbandonedPatchsets() && event instanceof ChangeAbandoned;
        return !abortBecauseOfTopic && !shouldCancelPatchsetNumber && !isAbortAbandonedPatchset;
    }

    private void cancelMatchingJobs(GerritTriggeredEvent event, String jobName, CauseOfInterruption cause) {
        try {
            if (!(this.job instanceof Queue.Task)) {
                logger.error("Error canceling job. The job is not of type Task. Job name: " + this.getJob().getName());
                return;
            }
            List itemsInQueue = Queue.getInstance().getItems((Queue.Task)this.getJob());
            for (Queue.Item item : itemsInQueue) {
                Job tJob;
                if (!this.checkCausedByGerrit(event, item.getCauses()) || !jobName.equals((tJob = (Job)item.task).getFullName())) continue;
                Queue.getInstance().cancel(item);
            }
            Jenkins jenkins = Jenkins.get();
            for (Computer c : jenkins.getComputers()) {
                for (Executor e : c.getAllExecutors()) {
                    String runningJobName;
                    Run run;
                    Queue.Executable currentExecutable = e.getCurrentExecutable();
                    if (!(currentExecutable instanceof Run) || !this.checkCausedByGerrit(event, (run = (Run)currentExecutable).getCauses()) || !jobName.equals(runningJobName = run.getParent().getFullName())) continue;
                    e.interrupt(Result.ABORTED, new CauseOfInterruption[]{cause});
                }
            }
        }
        catch (Exception e) {
            logger.error("Error canceling job", (Throwable)e);
        }
    }

    private boolean checkCausedByGerrit(GerritTriggeredEvent event, Collection<Cause> causes) {
        for (Cause c : causes) {
            GerritCause gc;
            if (!(c instanceof GerritCause) || (gc = (GerritCause)c).getEvent() != event) continue;
            return true;
        }
        return false;
    }

    public void add(ChangeBasedEvent event) {
        this.runningJobs.add((GerritTriggeredEvent)event);
    }

    public boolean remove(ChangeBasedEvent event) {
        logger.debug("Removing future job associated with " + event.getChange().getId());
        return this.runningJobs.remove(event);
    }
}

