/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimerTask;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import jenkins.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritTriggerTimer {
    protected static final long DELAY_MILLISECONDS = 5000L;
    private static final Logger logger = LoggerFactory.getLogger(GerritTriggerTimer.class);
    private static volatile GerritTriggerTimer instance = null;
    private Map<String, ScheduledFuture> scheduledTasks = new HashMap<String, ScheduledFuture>();

    private GerritTriggerTimer() {
    }

    public static GerritTriggerTimer getInstance() {
        if (instance == null) {
            instance = new GerritTriggerTimer();
        }
        return instance;
    }

    private long calculateDynamicConfigRefreshInterval(@NonNull GerritTrigger trigger) {
        if (trigger.isAnyServer()) {
            List<GerritServer> servers = PluginImpl.getServers_();
            if (servers.isEmpty()) {
                return 30L;
            }
            return this.calculateAverageDynamicConfigRefreshInterval();
        }
        GerritServer server = PluginImpl.getServer_(trigger.getServerName());
        if (server != null) {
            return server.getConfig().getDynamicConfigRefreshInterval();
        }
        return this.calculateAverageDynamicConfigRefreshInterval();
    }

    long calculateAverageDynamicConfigRefreshInterval() {
        long total = 0L;
        for (GerritServer server : PluginImpl.getServers_()) {
            total += (long)server.getConfig().getDynamicConfigRefreshInterval();
        }
        long average = total / (long)Math.max(1, PluginImpl.getServers_().size());
        return Math.max(5L, average);
    }

    public void schedule(GerritTriggerTimerTask timerTask, @NonNull GerritTrigger trigger) {
        long timerPeriod = TimeUnit.SECONDS.toMillis(this.calculateDynamicConfigRefreshInterval(trigger));
        try {
            this.cancel(timerTask);
            logger.debug("Schedule task " + String.valueOf((Object)timerTask) + " for every " + timerPeriod + "ms");
            this.scheduledTasks.put(timerTask.toString(), Timer.get().scheduleWithFixedDelay((Runnable)((Object)timerTask), 5000L, timerPeriod, TimeUnit.MILLISECONDS));
        }
        catch (IllegalArgumentException iae) {
            logger.error("Attempted use of negative delay", (Throwable)iae);
        }
        catch (IllegalStateException ise) {
            logger.error("Attempted re-use of TimerTask", (Throwable)ise);
        }
    }

    public void cancel(GerritTriggerTimerTask timerTask) {
        if (this.scheduledTasks.get(timerTask.toString()) != null) {
            boolean mayNotInterruptIfRunning;
            this.scheduledTasks.get(timerTask.toString()).cancel(!(mayNotInterruptIfRunning = true));
            this.scheduledTasks.remove(timerTask.toString());
            logger.debug("Canceling and removing timer for " + String.valueOf((Object)timerTask));
        }
    }
}

