/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.ReplicationConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.DependencyQueueTaskDispatcher;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Notify;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Symbol(value={"gerrit"})
public final class GerritTriggerDescriptor
extends TriggerDescriptor {
    private static final Logger logger = LoggerFactory.getLogger(GerritTriggerDescriptor.class);

    public boolean isUnsuccessfulMessageFileSupported(Job job) {
        return job instanceof AbstractProject;
    }

    public AutoCompletionCandidates doAutoCompleteDependencyJobsNames(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
        return AutoCompletionCandidates.ofJobNames(Job.class, (String)value, (Item)self, (ItemGroup)container);
    }

    public FormValidation doCheckDependencyJobsNames(@AncestorInPath Item project, @QueryParameter String value) {
        StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
        while (tokens.hasMoreTokens()) {
            Jenkins jenkins;
            Item item;
            String projectName = tokens.nextToken().trim();
            if (projectName.equals("") || (item = (jenkins = Jenkins.get()).getItem(projectName, project, Item.class)) != null && item instanceof Job) continue;
            AbstractProject nearest = AbstractProject.findNearest((String)projectName);
            String path = "<null>";
            if (nearest != null) {
                path = nearest.getFullName();
            }
            return FormValidation.error((String)Messages.NoSuchJobExists(projectName, path));
        }
        HashSet<Job> explored = new HashSet<Job>();
        List<Job> directDependencies = DependencyQueueTaskDispatcher.getProjectsFromString(value, project);
        if (directDependencies == null) {
            return FormValidation.ok();
        }
        for (Job directDependency : directDependencies) {
            if (directDependency.getFullName().equals(project.getFullName())) {
                return FormValidation.error((String)Messages.CannotAddSelfAsDependency());
            }
            LinkedList<Job> toExplore = new LinkedList<Job>();
            toExplore.add(directDependency);
            while (toExplore.size() > 0) {
                String currentDependenciesString;
                List<Job> currentDependencies;
                Job currentlyExploring = (Job)toExplore.remove();
                explored.add(currentlyExploring);
                GerritTrigger currentTrigger = GerritTrigger.getTrigger(currentlyExploring);
                if (currentTrigger == null || (currentDependencies = DependencyQueueTaskDispatcher.getProjectsFromString(currentDependenciesString = GerritTrigger.getTrigger(currentlyExploring).getDependencyJobsNames(), project)) == null) continue;
                for (Job dependency : currentDependencies) {
                    if (dependency.getFullName().equals(project.getFullName())) {
                        return FormValidation.error((String)Messages.AddingDependentProjectWouldCreateLoop(directDependency.getFullName(), currentlyExploring.getFullName()));
                    }
                    if (explored.contains(dependency)) continue;
                    toExplore.add(dependency);
                }
            }
        }
        return FormValidation.ok();
    }

    public ListBoxModel doFillServerNameItems(@AncestorInPath Item project) {
        if (project == null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        } else {
            project.checkPermission(Item.CONFIGURE);
        }
        ListBoxModel items = new ListBoxModel();
        items.add(Messages.AnyServer(), "__ANY__");
        List<String> serverNames = PluginImpl.getServerNames_();
        for (String s : serverNames) {
            items.add(s);
        }
        return items;
    }

    public boolean isSlaveSelectionAllowedInJobs() {
        for (GerritServer server : PluginImpl.getServers_()) {
            ReplicationConfig replicationConfig = server.getConfig().getReplicationConfig();
            if (replicationConfig == null || !replicationConfig.isEnableSlaveSelectionInJobs()) continue;
            return true;
        }
        return false;
    }

    public ListBoxModel doFillGerritSlaveIdItems(@QueryParameter(value="serverName") String serverName) {
        ListBoxModel items = new ListBoxModel();
        if ("__ANY__".equals(serverName)) {
            items.add(Messages.SlaveSelectionNotAllowedAnyServer(Messages.AnyServer()), "");
            return items;
        }
        GerritServer server = PluginImpl.getServer_(serverName);
        if (server == null) {
            logger.warn(Messages.CouldNotFindServer(serverName));
            items.add(Messages.CouldNotFindServer(serverName), "");
            return items;
        }
        ReplicationConfig replicationConfig = server.getConfig().getReplicationConfig();
        if (replicationConfig == null) {
            items.add(Messages.ReplicationNotConfigured(), "");
            return items;
        }
        if (!replicationConfig.isEnableReplication()) {
            items.add(Messages.ReplicationNotConfigured(), "");
            return items;
        }
        if (!replicationConfig.isEnableSlaveSelectionInJobs()) {
            items.add(Messages.SlaveSelectionInJobsDisabled(), "");
            return items;
        }
        for (GerritSlave slave : replicationConfig.getGerritSlaves()) {
            if (slave.getId().equals(replicationConfig.getDefaultSlaveId())) {
                items.add(0, (Object)new ListBoxModel.Option(slave.getName(), slave.getId()));
                continue;
            }
            items.add(slave.getName(), slave.getId());
        }
        return items;
    }

    public FormValidation doUrlCheck(@QueryParameter(value="value") String value) {
        if (value == null || value.isEmpty()) {
            return FormValidation.error((String)Messages.EmptyError());
        }
        try {
            URL url = new URL(value);
            url.toURI();
            return FormValidation.ok();
        }
        catch (MalformedURLException | URISyntaxException e) {
            return FormValidation.error((String)Messages.BadUrlError());
        }
    }

    public ListBoxModel doFillNotificationLevelItems(@QueryParameter(value="serverName") String serverName) {
        Map<Notify, String> levelTextsById = GerritServer.notificationLevelTextsById();
        ListBoxModel items = new ListBoxModel(levelTextsById.size() + 1);
        items.add((Object)GerritTriggerDescriptor.getOptionForNotificationLevelDefault(serverName, levelTextsById));
        for (Map.Entry<Notify, String> level : levelTextsById.entrySet()) {
            items.add((Object)new ListBoxModel.Option(level.getValue(), level.getKey().toString()));
        }
        return items;
    }

    private static ListBoxModel.Option getOptionForNotificationLevelDefault(String serverName, Map<Notify, String> levelTextsById) {
        Notify level;
        GerritServer server;
        if ("__ANY__".equals(serverName)) {
            return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValue(), "");
        }
        if (serverName != null && (server = PluginImpl.getServer_(serverName)) != null && (level = server.getConfig().getNotificationLevel()) != null) {
            String levelText = levelTextsById.get(level);
            if (levelText == null) {
                levelText = level.toString();
            }
            return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValueFromServer(levelText), "");
        }
        String defaultText = levelTextsById.get(Config.DEFAULT_NOTIFICATION_LEVEL);
        return new ListBoxModel.Option(Messages.NotificationLevel_DefaultValueFromServer(defaultText), "");
    }

    public GerritTriggerDescriptor() {
        super(GerritTrigger.class);
    }

    public boolean isApplicable(Item item) {
        return item instanceof ParameterizedJobMixIn.ParameterizedJob;
    }

    public String getDisplayName() {
        return Messages.TriggerDisplayName();
    }

    public String getHelpFile() {
        return "/plugin/gerrit-trigger/help-whatIsGerritTrigger.html";
    }

    public CompareType[] getCompareTypes() {
        return CompareType.values();
    }

    public List<PluginGerritEvent.PluginGerritEventDescriptor> getGerritEventDescriptors() {
        ExtensionList extensionList = Jenkins.get().getExtensionList(PluginGerritEvent.PluginGerritEventDescriptor.class);
        return extensionList;
    }
}

