/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.VerdictCategory;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.ReplicationConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.DependencyQueueTaskDispatcher;
import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.DynamicConfigurationCacheProxy;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.EventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritProjectList;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerDescriptor;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerParameters;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTriggerTimerTask;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritUserCause;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.RunningJobs;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.actions.GerritTriggerInformationAction;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.BuildCancellationPolicy;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.SkipVote;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TopicAssociation;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContext;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginChangeAbandonedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginCommentAddedContainsEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginCommentAddedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginDraftPublishedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginGerritEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.events.PluginPatchsetCreatedEvent;
import com.sonyericsson.hudson.plugins.gerrit.trigger.version.GerritVersionChecker;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.GerritQueryHandler;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Approval;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Change;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeAbandoned;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.CommentAdded;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.RefUpdated;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.TopicChanged;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.WipStateChanged;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.Topic;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.apache.commons.collections.IteratorUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritTrigger
extends Trigger<Job> {
    private static final Logger logger = LoggerFactory.getLogger(GerritTrigger.class);
    private static final int DYNAMIC_CONFIG_TIMEOUT_S = 10;
    private transient RunningJobs runningJobs;
    private transient CountDownLatch projectListIsReady;
    private List<GerritProject> gerritProjects;
    private List<GerritProject> dynamicGerritProjects;
    private SkipVote skipVote;
    private Integer gerritBuildStartedVerifiedValue;
    private Integer gerritBuildStartedCodeReviewValue;
    private Integer gerritBuildSuccessfulVerifiedValue;
    private Integer gerritBuildSuccessfulCodeReviewValue;
    private Integer gerritBuildFailedVerifiedValue;
    private Integer gerritBuildFailedCodeReviewValue;
    private Integer gerritBuildUnstableVerifiedValue;
    private Integer gerritBuildUnstableCodeReviewValue;
    private Integer gerritBuildNotBuiltVerifiedValue;
    private Integer gerritBuildNotBuiltCodeReviewValue;
    private Integer gerritBuildAbortedVerifiedValue;
    private Integer gerritBuildAbortedCodeReviewValue;
    private boolean silentMode;
    @Deprecated
    private transient boolean enableTopicAssociation;
    private TopicAssociation topicAssociation;
    private String notificationLevel;
    private boolean silentStartMode;
    private boolean escapeQuotes;
    private BuildCancellationPolicy buildCancellationPolicy;
    private GerritTriggerParameters.ParameterMode nameAndEmailParameterMode;
    private String dependencyJobsNames;
    private GerritTriggerParameters.ParameterMode commitMessageParameterMode;
    private GerritTriggerParameters.ParameterMode changeSubjectParameterMode;
    private GerritTriggerParameters.ParameterMode commentTextParameterMode;
    private String buildStartMessage;
    private String buildFailureMessage;
    private String buildSuccessfulMessage;
    private String buildUnstableMessage;
    private String buildNotBuiltMessage;
    private String buildAbortedMessage;
    private String buildUnsuccessfulFilepath;
    private String customUrl;
    private String serverName;
    private String gerritSlaveId;
    private List<PluginGerritEvent> triggerOnEvents;
    private boolean dynamicTriggerConfiguration;
    private String triggerConfigURL;
    private GerritTriggerTimerTask gerritTriggerTimerTask;
    private GerritTriggerInformationAction triggerInformationAction;
    @Deprecated
    private transient boolean noNameAndEmailParameters;
    @Deprecated
    private transient boolean readableMessage;
    @Deprecated
    private transient boolean allowTriggeringUnreviewedPatches;

    @DataBoundConstructor
    public GerritTrigger(List<GerritProject> gerritProjects) {
        this.runningJobs = new RunningJobs(this, this.job);
        this.projectListIsReady = new CountDownLatch(0);
        this.enableTopicAssociation = false;
        this.gerritProjects = gerritProjects;
        this.gerritTriggerTimerTask = null;
        this.triggerInformationAction = new GerritTriggerInformationAction();
        this.skipVote = new SkipVote(false, false, false, false, false);
        this.escapeQuotes = true;
        this.serverName = "__ANY__";
        try {
            ListBoxModel options;
            GerritTriggerDescriptor descriptor = (GerritTriggerDescriptor)this.getDescriptor();
            if (descriptor != null && !(options = descriptor.doFillNotificationLevelItems(this.serverName)).isEmpty()) {
                this.notificationLevel = ((ListBoxModel.Option)options.get((int)0)).value;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (this.notificationLevel == null) {
            this.notificationLevel = "";
        }
        this.commitMessageParameterMode = GerritTriggerParameters.ParameterMode.BASE64;
        this.nameAndEmailParameterMode = GerritTriggerParameters.ParameterMode.PLAIN;
        this.changeSubjectParameterMode = GerritTriggerParameters.ParameterMode.PLAIN;
        this.commentTextParameterMode = GerritTriggerParameters.ParameterMode.BASE64;
        this.dependencyJobsNames = "";
        this.buildStartMessage = "";
        this.buildSuccessfulMessage = "";
        this.buildUnstableMessage = "";
        this.buildFailureMessage = "";
        this.buildNotBuiltMessage = "";
        this.buildAbortedMessage = "";
        this.buildUnsuccessfulFilepath = "";
        this.triggerConfigURL = "";
    }

    @Deprecated
    public GerritTrigger(List<GerritProject> gerritProjects, SkipVote skipVote, Integer gerritBuildStartedVerifiedValue, Integer gerritBuildStartedCodeReviewValue, Integer gerritBuildSuccessfulVerifiedValue, Integer gerritBuildSuccessfulCodeReviewValue, Integer gerritBuildFailedVerifiedValue, Integer gerritBuildFailedCodeReviewValue, Integer gerritBuildUnstableVerifiedValue, Integer gerritBuildUnstableCodeReviewValue, Integer gerritBuildNotBuiltVerifiedValue, Integer gerritBuildNotBuiltCodeReviewValue, boolean silentMode, boolean silentStartMode, boolean escapeQuotes, boolean noNameAndEmailParameters, boolean readableMessage, String dependencyJobsNames, String buildStartMessage, String buildSuccessfulMessage, String buildUnstableMessage, String buildFailureMessage, String buildNotBuiltMessage, String buildUnsuccessfulFilepath, String customUrl, String serverName, String gerritSlaveId, List<PluginGerritEvent> triggerOnEvents, boolean dynamicTriggerConfiguration, String triggerConfigURL, String notificationLevel) {
        this.runningJobs = new RunningJobs(this, this.job);
        this.projectListIsReady = new CountDownLatch(0);
        this.enableTopicAssociation = false;
        this.gerritProjects = gerritProjects;
        this.skipVote = skipVote;
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
        this.silentMode = silentMode;
        this.silentStartMode = silentStartMode;
        this.escapeQuotes = escapeQuotes;
        this.nameAndEmailParameterMode = noNameAndEmailParameters ? GerritTriggerParameters.ParameterMode.NONE : GerritTriggerParameters.ParameterMode.PLAIN;
        this.commitMessageParameterMode = readableMessage ? GerritTriggerParameters.ParameterMode.PLAIN : GerritTriggerParameters.ParameterMode.BASE64;
        this.changeSubjectParameterMode = GerritTriggerParameters.ParameterMode.PLAIN;
        this.commentTextParameterMode = GerritTriggerParameters.ParameterMode.BASE64;
        this.dependencyJobsNames = dependencyJobsNames;
        this.buildStartMessage = buildStartMessage;
        this.buildSuccessfulMessage = buildSuccessfulMessage;
        this.buildUnstableMessage = buildUnstableMessage;
        this.buildFailureMessage = buildFailureMessage;
        this.buildNotBuiltMessage = buildNotBuiltMessage;
        this.buildUnsuccessfulFilepath = buildUnsuccessfulFilepath;
        this.customUrl = customUrl;
        this.serverName = serverName;
        this.gerritSlaveId = gerritSlaveId;
        this.triggerOnEvents = triggerOnEvents;
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
        this.triggerConfigURL = triggerConfigURL;
        this.gerritTriggerTimerTask = null;
        this.triggerInformationAction = new GerritTriggerInformationAction();
        this.notificationLevel = notificationLevel;
    }

    @NonNull
    public GerritTriggerParameters.ParameterMode getNameAndEmailParameterMode() {
        return this.nameAndEmailParameterMode;
    }

    @DataBoundSetter
    public void setNameAndEmailParameterMode(@NonNull GerritTriggerParameters.ParameterMode nameAndEmailParameterMode) {
        this.nameAndEmailParameterMode = nameAndEmailParameterMode;
    }

    @NonNull
    public GerritTriggerParameters.ParameterMode getCommitMessageParameterMode() {
        return this.commitMessageParameterMode;
    }

    @DataBoundSetter
    public void setCommitMessageParameterMode(@NonNull GerritTriggerParameters.ParameterMode commitMessageParameterMode) {
        this.commitMessageParameterMode = commitMessageParameterMode;
    }

    @NonNull
    public GerritTriggerParameters.ParameterMode getChangeSubjectParameterMode() {
        return this.changeSubjectParameterMode;
    }

    @DataBoundSetter
    public void setChangeSubjectParameterMode(@NonNull GerritTriggerParameters.ParameterMode changeSubjectParameterMode) {
        this.changeSubjectParameterMode = changeSubjectParameterMode;
    }

    @NonNull
    public GerritTriggerParameters.ParameterMode getCommentTextParameterMode() {
        return this.commentTextParameterMode;
    }

    @DataBoundSetter
    public void setCommentTextParameterMode(@NonNull GerritTriggerParameters.ParameterMode commentTextParameterMode) {
        this.commentTextParameterMode = commentTextParameterMode;
    }

    @DataBoundSetter
    public void setSkipVote(SkipVote skipVote) {
        this.skipVote = skipVote;
    }

    Job getJob() {
        return (Job)this.job;
    }

    public String getServerName() {
        return this.serverName;
    }

    @DataBoundSetter
    public void setServerName(String name) {
        ListBoxModel options;
        this.serverName = name;
        if (this.notificationLevel == null && !(options = ((GerritTriggerDescriptor)this.getDescriptor()).doFillNotificationLevelItems(this.serverName)).isEmpty()) {
            this.notificationLevel = ((ListBoxModel.Option)options.get((int)0)).value;
        }
    }

    public String getGerritSlaveId() {
        return this.gerritSlaveId;
    }

    @DataBoundSetter
    public void setGerritSlaveId(String gerritSlaveId) {
        this.gerritSlaveId = gerritSlaveId;
    }

    void onJobRenamed(String oldFullName, String newFullName) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin != null) {
            GerritHandler handler = plugin.getHandler();
            handler.removeListener((GerritEventListener)new EventListener(oldFullName));
            handler.addListener((GerritEventListener)this.createListener());
        }
    }

    public static GerritTrigger getTrigger(@Nullable Job project) {
        if (project == null) {
            return null;
        }
        return (GerritTrigger)ParameterizedJobMixIn.getTrigger((Job)project, GerritTrigger.class);
    }

    public void cancelTimer() {
        if (this.gerritTriggerTimerTask != null) {
            String name = "N/A";
            if (this.job != null) {
                name = ((Job)this.job).getName();
            }
            logger.trace("GerritTrigger.cancelTimer(): {}", (Object)name);
            this.gerritTriggerTimerTask.cancel();
            this.gerritTriggerTimerTask = null;
        }
    }

    private void addThisTriggerAsListener(Job project) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin != null) {
            GerritHandler handler = plugin.getHandler();
            handler.addListener((GerritEventListener)GerritTrigger.createListener(project));
        } else {
            logger.warn("The plugin instance could not be found! Project {} will not be triggered!", (Object)project.getFullDisplayName());
        }
    }

    static EventListener createListener(Job<?, ?> project) {
        return new EventListener(project);
    }

    EventListener createListener() {
        if (this.job == null) {
            throw new IllegalStateException("job is not set");
        }
        return GerritTrigger.createListener((Job)this.job);
    }

    public void start(Job project, boolean newInstance) {
        logger.debug("Start project: {}", (Object)project);
        super.start((Item)project, newInstance);
        this.initializeServerName();
        this.initializeTriggerOnEvents();
        try {
            this.addThisTriggerAsListener(project);
        }
        catch (IllegalStateException e) {
            logger.error("I am too early!", (Throwable)e);
        }
        if (this.dynamicTriggerConfiguration) {
            logger.debug("Start project: {}; dynamic project list; setting latch to 1", (Object)project);
            this.projectListIsReady = new CountDownLatch(1);
            this.gerritTriggerTimerTask = new GerritTriggerTimerTask(this);
        } else {
            logger.debug("Start project: {}; static project list; setting latch to 0", (Object)project);
            this.projectListIsReady = new CountDownLatch(0);
        }
        GerritProjectList.removeTriggerFromProjectList(this);
    }

    public void stop() {
        logger.debug("Stop");
        GerritProjectList.removeTriggerFromProjectList(this);
        super.stop();
        try {
            this.removeListener();
        }
        catch (IllegalStateException e) {
            logger.error("I am too late!", (Throwable)e);
        }
        this.cancelTimer();
    }

    private void removeListener() {
        GerritHandler handler = PluginImpl.getHandler_();
        if (handler != null) {
            if (this.job != null) {
                handler.removeListener((GerritEventListener)this.createListener());
            }
        } else {
            logger.error("The Gerrit handler has not been initialized. BUG!");
        }
    }

    private Provider initializeProvider(GerritTriggeredEvent tEvent) {
        Provider provider = tEvent.getProvider();
        if (!this.isAnyServer()) {
            if (provider == null) {
                provider = new Provider();
                provider.setName(this.serverName);
            } else if (provider.getName() == null) {
                provider.setName(this.serverName);
            }
        }
        return provider;
    }

    boolean isAnyServer() {
        return GerritServer.isAnyServer(this.serverName);
    }

    private boolean shouldTriggerOnEventType(GerritTriggeredEvent event) {
        if (this.triggerOnEvents == null || this.triggerOnEvents.isEmpty()) {
            return false;
        }
        if (event instanceof ChangeAbandoned) {
            if (this.buildCancellationPolicy != null && this.buildCancellationPolicy.isEnabled() && this.buildCancellationPolicy.isAbortAbandonedPatchsets()) {
                return true;
            }
            IGerritHudsonTriggerConfig config = PluginImpl.getServerConfig(event);
            if (config != null && config.getBuildCurrentPatchesOnly().isEnabled() && config.getBuildCurrentPatchesOnly().isAbortAbandonedPatchsets()) {
                return true;
            }
        }
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (!e.shouldTriggerOn(event)) continue;
            if (event instanceof WipStateChanged) {
                return !((WipStateChanged)event).getChange().isWip();
            }
            return true;
        }
        return false;
    }

    @Deprecated
    protected void schedule(GerritCause cause, GerritTriggeredEvent event) {
        this.createListener().schedule(this, cause, event, (Job)this.job);
    }

    @Deprecated
    protected void schedule(GerritCause cause, GerritTriggeredEvent event, Job project) {
        this.createListener().schedule(this, cause, event, project);
    }

    @Deprecated
    protected ParametersAction createParameters(GerritTriggeredEvent event, Job project) {
        return this.createListener().createParameters(event, project);
    }

    private List<VerdictCategory> getVerdictCategoriesList() {
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server != null) {
            return server.getConfig().getCategories();
        }
        logger.error("Could not find server {}", (Object)this.serverName);
        return new LinkedList<VerdictCategory>();
    }

    public ListBoxModel doFillVerdictCategoryItems() {
        ListBoxModel m = new ListBoxModel();
        List<VerdictCategory> list = this.getVerdictCategoriesList();
        for (VerdictCategory v : list) {
            m.add(v.getVerdictDescription(), v.getVerdictValue());
        }
        return m;
    }

    synchronized RunningJobs getRunningJobs(Job job) {
        if (this.runningJobs == null) {
            this.runningJobs = new RunningJobs(this, this.job);
        } else {
            this.runningJobs.setJob((Item)job);
        }
        return this.runningJobs;
    }

    public void notifyBuildEnded(GerritTriggeredEvent event) {
        IGerritHudsonTriggerConfig serverConfig;
        if (event instanceof ChangeBasedEvent && ((serverConfig = PluginImpl.getServerConfig(event)) != null && serverConfig.isGerritBuildCurrentPatchesOnly() || this.getBuildCancellationPolicy() != null && this.getBuildCancellationPolicy().isEnabled())) {
            this.getRunningJobs((Job)this.job).remove((ChangeBasedEvent)event);
        }
    }

    public int getBuildScheduleDelay() {
        if (this.isAnyServer()) {
            int max = 0;
            for (GerritServer server : PluginImpl.getServers_()) {
                if (server.getConfig() == null) continue;
                max = Math.max(max, server.getConfig().getBuildScheduleDelay());
            }
            return max;
        }
        GerritServer server = PluginImpl.getServer_(this.serverName);
        if (server == null || server.getConfig() == null) {
            return 3;
        }
        int buildScheduleDelay = server.getConfig().getBuildScheduleDelay();
        return Math.max(0, buildScheduleDelay);
    }

    public void retriggerThisBuild(TriggerContext context) {
        ToGerritRunListener listener;
        if (context.getThisBuild().getProject().isBuildable() && (listener = ToGerritRunListener.getInstance()) != null && !listener.isBuilding(context.getThisBuild().getProject(), context.getEvent())) {
            Provider provider = this.initializeProvider(context.getEvent());
            if (!this.isAnyServer() && !PluginImpl.containsServer_(provider.getName())) {
                provider.setName(this.serverName);
            }
            if (!this.silentMode) {
                listener.onRetriggered(context.getThisBuild().getProject(), context.getEvent(), context.getOtherBuilds());
            }
            GerritUserCause cause = new GerritUserCause(context.getEvent(), this.silentMode);
            this.createListener().schedule(this, cause, context.getEvent(), context.getThisBuild().getProject());
        }
    }

    public void retriggerAllBuilds(TriggerContext context) {
        ToGerritRunListener listener;
        DependencyQueueTaskDispatcher dependencyQueueTaskDispatcher = DependencyQueueTaskDispatcher.getInstance();
        if (dependencyQueueTaskDispatcher != null && (listener = ToGerritRunListener.getInstance()) != null && !listener.isBuilding(context.getEvent())) {
            dependencyQueueTaskDispatcher.onTriggeringAll(context.getEvent());
            this.retrigger(context.getThisBuild().getProject(), context.getEvent());
            for (Run build : context.getOtherBuilds()) {
                GerritTrigger trigger = GerritTrigger.getTrigger(build.getParent());
                if (trigger == null) continue;
                trigger.retrigger(build.getParent(), context.getEvent());
            }
            dependencyQueueTaskDispatcher.onDoneTriggeringAll(context.getEvent());
        }
    }

    private void retrigger(Job project, GerritTriggeredEvent event) {
        if (project.isBuildable()) {
            ToGerritRunListener listener;
            this.initializeProvider(event);
            if (!this.silentMode && (listener = ToGerritRunListener.getInstance()) != null) {
                listener.onRetriggered(project, event, null);
            }
            GerritUserCause cause = new GerritUserCause(event, this.silentMode);
            this.schedule(cause, event, project);
        }
    }

    public int hashCode() {
        if (this.job == null) {
            return super.hashCode();
        }
        return ((Job)this.job).getFullName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GerritTrigger) {
            GerritTrigger that = (GerritTrigger)((Object)obj);
            if (this.job == null || that.job == null) {
                return super.equals(obj);
            }
            return ((Job)this.job).getFullName().equals(((Job)that.job).getFullName());
        }
        return false;
    }

    private boolean isChangeInteresting(Change change, GerritProject project, GerritQueryHandler gerritQueryHandler) {
        boolean containsFilePathsOrForbiddenFilePaths;
        boolean shouldTrigger = false;
        boolean bl = containsFilePathsOrForbiddenFilePaths = project.getFilePaths() != null && project.getFilePaths().size() > 0 || project.getForbiddenFilePaths() != null && project.getForbiddenFilePaths().size() > 0;
        if (this.isFileTriggerEnabled() && containsFilePathsOrForbiddenFilePaths) {
            if (project.isInteresting(change, () -> change.getFiles(gerritQueryHandler))) {
                shouldTrigger = true;
            }
        } else if (project.isInteresting(change)) {
            shouldTrigger = true;
        }
        if (shouldTrigger) {
            logger.trace("({},{},{}) is interesting; {}", new Object[]{change.getProject(), change.getBranch(), change.getTopic(), change});
        }
        return shouldTrigger;
    }

    private boolean isTopicInteresting(Topic topic, GerritProject project, ChangeBasedEvent event) {
        if (this.topicAssociation == null) {
            return false;
        }
        GerritServer server = PluginImpl.getServer_((GerritTriggeredEvent)event);
        if (server == null) {
            return false;
        }
        logger.trace("query topic {} from {} ({}:{})", new Object[]{topic, server.getName(), server.getHostName(), server.getSshPort()});
        Map changes = topic.getChanges(server.getQueryHandler());
        logger.trace("found {} changes with topic {} from {}", new Object[]{changes.size(), topic, server.getName()});
        for (Change change : changes.keySet()) {
            if (change.equals((Object)event.getChange()) || !this.isChangeInteresting(change, project, server.getQueryHandler()) || !this.topicAssociation.isInterestingChangeStatus(change)) continue;
            logger.trace("topic: {} and change status: {} is interesting", (Object)topic, (Object)change.getStatus());
            return true;
        }
        return false;
    }

    private GerritQueryHandler getGerritQueryHandler(GerritTriggeredEvent event) {
        Provider provider = event.getProvider();
        if (provider == null) {
            return null;
        }
        GerritServer server = PluginImpl.getServer_(provider.getName());
        if (server == null) {
            return null;
        }
        return server.getQueryHandler();
    }

    private boolean isChangeBasedEventInteresting(ChangeBasedEvent event, GerritProject project) {
        Change change = event.getChange();
        if (this.isChangeInteresting(change, project, this.getGerritQueryHandler((GerritTriggeredEvent)event))) {
            return true;
        }
        return this.isTopicAssociationInteresting(event, project);
    }

    private boolean isTopicAssociationInteresting(ChangeBasedEvent event, GerritProject project) {
        if (this.topicAssociation == null) {
            return false;
        }
        Change change = event.getChange();
        Topic topic = change.getTopicObject();
        if (topic == null) {
            return false;
        }
        return this.isTopicInteresting(topic, project, event);
    }

    public boolean isOnlyAbortRunningBuild(GerritTriggeredEvent event) {
        if (!(event instanceof ChangeBasedEvent)) {
            return false;
        }
        if (!(event instanceof ChangeAbandoned)) {
            return false;
        }
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (!(e instanceof PluginChangeAbandonedEvent)) continue;
            return false;
        }
        if (this.buildCancellationPolicy != null && this.buildCancellationPolicy.isEnabled() && this.buildCancellationPolicy.isAbortAbandonedPatchsets()) {
            return true;
        }
        IGerritHudsonTriggerConfig serverConfig = PluginImpl.getServerConfig(event);
        return serverConfig != null && serverConfig.isGerritBuildCurrentPatchesOnly() && serverConfig.getBuildCurrentPatchesOnly().isAbortAbandonedPatchsets();
    }

    public boolean isInteresting(GerritTriggeredEvent event) {
        if (this.job == null) {
            logger.trace("Job is not fully initialised.");
            return false;
        }
        if (!((Job)this.job).isBuildable()) {
            logger.trace("Disabled.");
            return false;
        }
        ToGerritRunListener listener = ToGerritRunListener.getInstance();
        if (listener != null) {
            if (listener.isProjectTriggeredAndIncomplete((Job)this.job, event)) {
                logger.trace("Already triggered and incomplete.");
                return false;
            }
            if (listener.isTriggered((Job)this.job, event)) {
                logger.trace("Already triggered.");
                return false;
            }
        }
        if (!this.isServerInteresting(event)) {
            return false;
        }
        if (!this.shouldTriggerOnEventType(event)) {
            return false;
        }
        logger.trace("entering isInteresting for the event: {}", (Object)event);
        Iterator<GerritProject> allGerritProjects = this.getAllGerritProjectsIterator();
        while (allGerritProjects.hasNext()) {
            GerritProject p = allGerritProjects.next();
            try {
                if (event instanceof ChangeBasedEvent) {
                    ChangeBasedEvent changeBasedEvent = (ChangeBasedEvent)event;
                    if (!this.isChangeBasedEventInteresting(changeBasedEvent, p)) continue;
                    return true;
                }
                if (!(event instanceof RefUpdated)) continue;
                RefUpdated refUpdated = (RefUpdated)event;
                Change change = new Change();
                change.setProject(refUpdated.getRefUpdate().getProject());
                change.setBranch(refUpdated.getRefUpdate().getRefName());
                if (!p.isInteresting(change)) continue;
                logger.trace("According to {} the event is interesting; event: {}", (Object)p, (Object)event);
                return true;
            }
            catch (PatternSyntaxException pse) {
                String name = "null";
                if (this.job != null) {
                    name = ((Job)this.job).getName();
                }
                logger.error(MessageFormat.format("Exception caught for project {0} and pattern {1}, message: {2}", name, p.getPattern(), pse.getMessage()));
            }
        }
        logger.trace("Event is not interesting; event: {}", (Object)event);
        return false;
    }

    private boolean isServerInteresting(GerritTriggeredEvent event) {
        if (this.isAnyServer()) {
            return true;
        }
        Provider provider = this.initializeProvider(event);
        return provider.getName().equals(this.serverName);
    }

    boolean commentAddedMatch(CommentAdded event) {
        PluginCommentAddedEvent commentAdded = null;
        for (PluginGerritEvent e : this.triggerOnEvents) {
            if (e instanceof PluginCommentAddedEvent) {
                commentAdded = (PluginCommentAddedEvent)e;
                for (Approval approval : event.getApprovals()) {
                    if (!(GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.commentAlwaysApproval, this.serverName, true) ? approval.isUpdated() != false && approval.getType().equals(commentAdded.getVerdictCategory()) && (approval.getValue().equals(commentAdded.getCommentAddedTriggerApprovalValue()) || ("+" + approval.getValue()).equals(commentAdded.getCommentAddedTriggerApprovalValue())) : approval.getType().equals(commentAdded.getVerdictCategory()) && (approval.getValue().equals(commentAdded.getCommentAddedTriggerApprovalValue()) || ("+" + approval.getValue()).equals(commentAdded.getCommentAddedTriggerApprovalValue())))) continue;
                    return true;
                }
            }
            if (!(e instanceof PluginCommentAddedContainsEvent) || !((PluginCommentAddedContainsEvent)e).match((GerritTriggeredEvent)event)) continue;
            return true;
        }
        return false;
    }

    public List<GerritProject> getGerritProjects() {
        if (this.gerritProjects == null) {
            return null;
        }
        return Collections.unmodifiableList(this.gerritProjects);
    }

    public List<GerritProject> getDynamicGerritProjects() {
        if (this.dynamicGerritProjects == null) {
            return null;
        }
        return Collections.unmodifiableList(this.dynamicGerritProjects);
    }

    public void setGerritProjects(List<GerritProject> gerritProjects) {
        this.gerritProjects = gerritProjects;
    }

    public Integer getGerritBuildFailedCodeReviewValue() {
        return this.gerritBuildFailedCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildFailedCodeReviewValue(Integer gerritBuildFailedCodeReviewValue) {
        this.gerritBuildFailedCodeReviewValue = gerritBuildFailedCodeReviewValue;
    }

    public Integer getGerritBuildFailedVerifiedValue() {
        return this.gerritBuildFailedVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildFailedVerifiedValue(Integer gerritBuildFailedVerifiedValue) {
        this.gerritBuildFailedVerifiedValue = gerritBuildFailedVerifiedValue;
    }

    public Integer getGerritBuildStartedCodeReviewValue() {
        return this.gerritBuildStartedCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildStartedCodeReviewValue(Integer gerritBuildStartedCodeReviewValue) {
        this.gerritBuildStartedCodeReviewValue = gerritBuildStartedCodeReviewValue;
    }

    public Integer getGerritBuildStartedVerifiedValue() {
        return this.gerritBuildStartedVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildStartedVerifiedValue(Integer gerritBuildStartedVerifiedValue) {
        this.gerritBuildStartedVerifiedValue = gerritBuildStartedVerifiedValue;
    }

    public Integer getGerritBuildSuccessfulCodeReviewValue() {
        return this.gerritBuildSuccessfulCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildSuccessfulCodeReviewValue(Integer gerritBuildSuccessfulCodeReviewValue) {
        this.gerritBuildSuccessfulCodeReviewValue = gerritBuildSuccessfulCodeReviewValue;
    }

    public Integer getGerritBuildSuccessfulVerifiedValue() {
        return this.gerritBuildSuccessfulVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildSuccessfulVerifiedValue(Integer gerritBuildSuccessfulVerifiedValue) {
        this.gerritBuildSuccessfulVerifiedValue = gerritBuildSuccessfulVerifiedValue;
    }

    public Integer getGerritBuildUnstableCodeReviewValue() {
        return this.gerritBuildUnstableCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildUnstableCodeReviewValue(Integer gerritBuildUnstableCodeReviewValue) {
        this.gerritBuildUnstableCodeReviewValue = gerritBuildUnstableCodeReviewValue;
    }

    public Integer getGerritBuildUnstableVerifiedValue() {
        return this.gerritBuildUnstableVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildUnstableVerifiedValue(Integer gerritBuildUnstableVerifiedValue) {
        this.gerritBuildUnstableVerifiedValue = gerritBuildUnstableVerifiedValue;
    }

    public Integer getGerritBuildNotBuiltCodeReviewValue() {
        return this.gerritBuildNotBuiltCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildNotBuiltCodeReviewValue(Integer gerritBuildNotBuiltCodeReviewValue) {
        this.gerritBuildNotBuiltCodeReviewValue = gerritBuildNotBuiltCodeReviewValue;
    }

    public Integer getGerritBuildNotBuiltVerifiedValue() {
        return this.gerritBuildNotBuiltVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildNotBuiltVerifiedValue(Integer gerritBuildNotBuiltVerifiedValue) {
        this.gerritBuildNotBuiltVerifiedValue = gerritBuildNotBuiltVerifiedValue;
    }

    public Integer getGerritBuildAbortedCodeReviewValue() {
        return this.gerritBuildAbortedCodeReviewValue;
    }

    @DataBoundSetter
    public void setGerritBuildAbortedCodeReviewValue(Integer gerritBuildAbortedCodeReviewValue) {
        this.gerritBuildAbortedCodeReviewValue = gerritBuildAbortedCodeReviewValue;
    }

    public Integer getGerritBuildAbortedVerifiedValue() {
        return this.gerritBuildAbortedVerifiedValue;
    }

    @DataBoundSetter
    public void setGerritBuildAbortedVerifiedValue(Integer gerritBuildAbortedVerifiedValue) {
        this.gerritBuildAbortedVerifiedValue = gerritBuildAbortedVerifiedValue;
    }

    @DataBoundSetter
    public void setBuildUnsuccessfulFilepath(String buildUnsuccessfulFilepath) {
        this.buildUnsuccessfulFilepath = buildUnsuccessfulFilepath;
    }

    public List<PluginGerritEvent> getTriggerOnEvents() {
        this.initializeTriggerOnEvents();
        return this.triggerOnEvents;
    }

    @DataBoundSetter
    public void setTriggerOnEvents(List<PluginGerritEvent> triggerOnEvents) {
        this.triggerOnEvents = triggerOnEvents;
    }

    private Iterator<GerritProject> getAllGerritProjectsIterator() {
        if (this.gerritProjects != null && this.dynamicGerritProjects != null) {
            return IteratorUtils.chainedIterator(this.gerritProjects.iterator(), this.dynamicGerritProjects.iterator());
        }
        if (this.gerritProjects == null && this.dynamicGerritProjects != null) {
            return this.dynamicGerritProjects.iterator();
        }
        if (this.gerritProjects != null) {
            return this.gerritProjects.iterator();
        }
        return IteratorUtils.emptyIterator();
    }

    private void initializeTriggerOnEvents() {
        if (this.triggerOnEvents == null) {
            this.triggerOnEvents = new LinkedList<PluginGerritEvent>();
        }
        if (this.triggerOnEvents.isEmpty()) {
            this.triggerOnEvents.add(new PluginPatchsetCreatedEvent());
            if (this.isTriggerOnDraftPublishedEnabled()) {
                this.triggerOnEvents.add(new PluginDraftPublishedEvent());
            }
        }
    }

    private void initializeServerName() {
        if (this.serverName == null) {
            this.serverName = "__ANY__";
        }
    }

    public boolean isDynamicTriggerConfiguration() {
        return this.dynamicTriggerConfiguration;
    }

    @DataBoundSetter
    public void setDynamicTriggerConfiguration(boolean dynamicTriggerConfiguration) {
        if (!dynamicTriggerConfiguration) {
            this.dynamicGerritProjects = Collections.emptyList();
        }
        this.dynamicTriggerConfiguration = dynamicTriggerConfiguration;
    }

    public String getTriggerConfigURL() {
        return this.triggerConfigURL;
    }

    @DataBoundSetter
    public void setTriggerConfigURL(String triggerConfigURL) {
        this.triggerConfigURL = triggerConfigURL;
    }

    public String getDependencyJobsNames() {
        return this.dependencyJobsNames;
    }

    @DataBoundSetter
    public void setDependencyJobsNames(String dependencyJobsNames) {
        this.dependencyJobsNames = dependencyJobsNames;
    }

    public boolean isSilentMode() {
        return this.silentMode;
    }

    public boolean isSilentStartMode() {
        return this.silentStartMode;
    }

    public String getNotificationLevel() {
        return this.notificationLevel;
    }

    public boolean isEscapeQuotes() {
        return this.escapeQuotes;
    }

    @DataBoundSetter
    public void setEscapeQuotes(boolean escapeQuotes) {
        this.escapeQuotes = escapeQuotes;
    }

    @Deprecated
    public boolean isNoNameAndEmailParameters() {
        return this.nameAndEmailParameterMode == GerritTriggerParameters.ParameterMode.NONE;
    }

    @Deprecated
    public void setNoNameAndEmailParameters(boolean noNameAndEmailParameters) {
        this.nameAndEmailParameterMode = noNameAndEmailParameters ? GerritTriggerParameters.ParameterMode.NONE : GerritTriggerParameters.ParameterMode.PLAIN;
    }

    @Deprecated
    public boolean isReadableMessage() {
        return this.commitMessageParameterMode == GerritTriggerParameters.ParameterMode.PLAIN;
    }

    @Deprecated
    public void setReadableMessage(boolean readableMessage) {
        this.commitMessageParameterMode = readableMessage ? GerritTriggerParameters.ParameterMode.PLAIN : GerritTriggerParameters.ParameterMode.BASE64;
    }

    public String getBuildStartMessage() {
        return this.buildStartMessage;
    }

    @DataBoundSetter
    public void setBuildStartMessage(String buildStartMessage) {
        this.buildStartMessage = buildStartMessage;
    }

    public BuildCancellationPolicy getBuildCancellationPolicy() {
        return this.buildCancellationPolicy;
    }

    public boolean isBuildCurrentPatchesOnly() {
        return this.buildCancellationPolicy != null && this.buildCancellationPolicy.isEnabled();
    }

    @DataBoundSetter
    public void setBuildCancellationPolicy(BuildCancellationPolicy buildCancellationPolicy) {
        this.buildCancellationPolicy = buildCancellationPolicy;
    }

    public String getBuildSuccessfulMessage() {
        return this.buildSuccessfulMessage;
    }

    @DataBoundSetter
    public void setBuildSuccessfulMessage(String buildSuccessfulMessage) {
        this.buildSuccessfulMessage = buildSuccessfulMessage;
    }

    public String getBuildUnstableMessage() {
        return this.buildUnstableMessage;
    }

    @DataBoundSetter
    public void setBuildUnstableMessage(String buildUnstableMessage) {
        this.buildUnstableMessage = buildUnstableMessage;
    }

    public String getBuildFailureMessage() {
        return this.buildFailureMessage;
    }

    @DataBoundSetter
    public void setBuildFailureMessage(String buildFailureMessage) {
        this.buildFailureMessage = buildFailureMessage;
    }

    public String getBuildNotBuiltMessage() {
        return this.buildNotBuiltMessage;
    }

    @DataBoundSetter
    public void setBuildNotBuiltMessage(String buildNotBuiltMessage) {
        this.buildNotBuiltMessage = buildNotBuiltMessage;
    }

    public String getBuildAbortedMessage() {
        return this.buildAbortedMessage;
    }

    @DataBoundSetter
    public void setBuildAbortedMessage(String buildAbortedMessage) {
        this.buildAbortedMessage = buildAbortedMessage;
    }

    public String getBuildUnsuccessfulFilepath() {
        return this.buildUnsuccessfulFilepath;
    }

    @DataBoundSetter
    public void setSilentMode(boolean silentMode) {
        this.silentMode = silentMode;
    }

    @Deprecated
    public void setEnableTopicAssociation(boolean enable) {
        this.topicAssociation = enable ? new TopicAssociation() : null;
    }

    @Deprecated
    public boolean isEnableTopicAssociation() {
        return this.topicAssociation != null;
    }

    @DataBoundSetter
    public void setTopicAssociation(TopicAssociation topicAssociation) {
        this.topicAssociation = topicAssociation;
    }

    @CheckForNull
    public TopicAssociation getTopicAssociation() {
        return this.topicAssociation;
    }

    @DataBoundSetter
    public void setSilentStartMode(boolean silentStartMode) {
        this.silentStartMode = silentStartMode;
    }

    @DataBoundSetter
    public void setNotificationLevel(String notificationLevel) {
        this.notificationLevel = notificationLevel;
    }

    public String getCustomUrl() {
        return this.customUrl;
    }

    @DataBoundSetter
    public void setCustomUrl(String customUrl) {
        this.customUrl = customUrl;
    }

    public boolean isFileTriggerEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.fileTrigger, this.serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTriggerConfigURL() {
        if (this.triggerInformationAction == null) {
            this.triggerInformationAction = new GerritTriggerInformationAction();
        }
        this.triggerInformationAction.setErrorMessage("");
        try {
            this.dynamicGerritProjects = !this.dynamicTriggerConfiguration || this.job == null || !((Job)this.job).isBuildable() ? Collections.emptyList() : DynamicConfigurationCacheProxy.getInstance().fetchThroughCache(this.triggerConfigURL);
        }
        catch (ParseException pe) {
            String logErrorMessage = MessageFormat.format("ParseException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, pe.getMessage());
            logger.error(logErrorMessage, (Throwable)pe);
            String triggerInformationMessage = MessageFormat.format("ParseException when fetching dynamic trigger url: {0}", pe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (MalformedURLException mue) {
            String logErrorMessage = MessageFormat.format("MalformedURLException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, mue.getMessage());
            logger.error(logErrorMessage, (Throwable)mue);
            String triggerInformationMessage = MessageFormat.format("MalformedURLException when fetching dynamic trigger url: {0}", mue.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (SocketTimeoutException ste) {
            String logErrorMessage = MessageFormat.format("SocketTimeoutException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, ste.getMessage());
            logger.error(logErrorMessage, (Throwable)ste);
            String triggerInformationMessage = MessageFormat.format("SocketTimeoutException when fetching dynamic trigger url: {0}", ste.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        catch (IOException ioe) {
            String logErrorMessage = MessageFormat.format("IOException for project: {0} and URL: {1} Message: {2}", ((Job)this.job).getName(), this.triggerConfigURL, ioe.getMessage());
            logger.error(logErrorMessage, (Throwable)ioe);
            String triggerInformationMessage = MessageFormat.format("IOException when fetching dynamic trigger url: {0}", ioe.getMessage());
            this.triggerInformationAction.setErrorMessage(triggerInformationMessage);
        }
        finally {
            if (this.projectListIsReady.getCount() > 0L) {
                String name = "null";
                if (this.job != null) {
                    name = ((Job)this.job).getName();
                }
                logger.debug("Trigger config URL updated: {}; latch is currently {}; decrementing it.", (Object)name, (Object)this.projectListIsReady.getCount());
            }
            this.projectListIsReady.countDown();
        }
    }

    public boolean isTriggerOnDraftPublishedEnabled() {
        return GerritVersionChecker.isCorrectVersion(GerritVersionChecker.Feature.triggerOnDraftPublished, this.serverName);
    }

    public List<GerritSlave> gerritSlavesToWaitFor(String gerritServerName) {
        ArrayList<GerritSlave> gerritSlaves = new ArrayList<GerritSlave>();
        GerritServer gerritServer = PluginImpl.getServer_(gerritServerName);
        if (gerritServer == null) {
            logger.warn("Could not find server: {}", (Object)this.serverName);
            return gerritSlaves;
        }
        ReplicationConfig replicationConfig = gerritServer.getConfig().getReplicationConfig();
        if (replicationConfig != null && replicationConfig.isEnableReplication()) {
            if (replicationConfig.isEnableSlaveSelectionInJobs()) {
                GerritSlave gerritSlave = replicationConfig.getGerritSlave(this.gerritSlaveId, true);
                if (gerritSlave != null) {
                    gerritSlaves.add(gerritSlave);
                }
            } else {
                List<GerritSlave> globalSlaves = replicationConfig.getGerritSlaves();
                if (globalSlaves != null) {
                    gerritSlaves.addAll(globalSlaves);
                }
            }
        }
        return gerritSlaves;
    }

    public List<Action> getProjectActions() {
        LinkedList<Action> list = new LinkedList<Action>();
        list.add(this.triggerInformationAction);
        return list;
    }

    public SkipVote getSkipVote() {
        return this.skipVote;
    }

    public void waitForProjectListToBeReady() throws InterruptedException {
        if (!this.projectListIsReady.await(10L, TimeUnit.SECONDS)) {
            logger.trace("Timeout at await");
        }
    }

    public Object readResolve() throws ObjectStreamException {
        this.initializeServerName();
        this.initializeTriggerOnEvents();
        if (this.commitMessageParameterMode == null) {
            this.commitMessageParameterMode = this.readableMessage ? GerritTriggerParameters.ParameterMode.PLAIN : GerritTriggerParameters.ParameterMode.BASE64;
        }
        if (this.nameAndEmailParameterMode == null) {
            this.nameAndEmailParameterMode = this.noNameAndEmailParameters ? GerritTriggerParameters.ParameterMode.NONE : GerritTriggerParameters.ParameterMode.PLAIN;
        }
        if (this.changeSubjectParameterMode == null) {
            this.changeSubjectParameterMode = GerritTriggerParameters.ParameterMode.PLAIN;
        }
        if (this.commentTextParameterMode == null) {
            this.commentTextParameterMode = GerritTriggerParameters.ParameterMode.PLAIN;
        }
        if (this.projectListIsReady == null) {
            this.projectListIsReady = new CountDownLatch(0);
        }
        if (this.topicAssociation == null && this.enableTopicAssociation) {
            this.topicAssociation = new TopicAssociation();
        }
        return super.readResolve();
    }

    public TriggerDescriptor getDescriptor() {
        return (TriggerDescriptor)Jenkins.get().getDescriptorByType(GerritTriggerDescriptor.class);
    }

    protected boolean abortBecauseOfTopic(ChangeBasedEvent event, BuildCancellationPolicy policy, ChangeBasedEvent runningChange) {
        String topicName = event.getChange().getTopic();
        if (event instanceof TopicChanged) {
            topicName = ((TopicChanged)event).getOldTopic();
        }
        return policy.isAbortSameTopic() && topicName != null && !topicName.isEmpty() && topicName.equals(runningChange.getChange().getTopic());
    }
}

