/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.gerritnotifier.ToGerritRunListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritCause;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import hudson.Extension;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.QueueListener;
import hudson.util.LogTaskListener;
import java.util.logging.Level;
import java.util.logging.Logger;

@Extension
public class GerritQueueListener
extends QueueListener {
    private static final Logger logger = Logger.getLogger(GerritQueueListener.class.getName());

    public void onLeft(Queue.LeftItem item) {
        if (item.isCancelled() && item.task instanceof Job) {
            for (Cause cause : item.getCauses()) {
                if (!(cause instanceof GerritCause) || ((GerritCause)cause).isSilentMode()) continue;
                GerritCause gerritCause = (GerritCause)cause;
                GerritTriggeredEvent event = gerritCause.getEvent();
                ToGerritRunListener runListener = ToGerritRunListener.getInstance();
                runListener.setQueueCancelled((Job)item.task, event);
                LogTaskListener taskListener = new LogTaskListener(logger, Level.WARNING);
                runListener.allBuildsCompleted(event, gerritCause, (TaskListener)taskListener);
            }
        }
    }
}

