/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.CompareType;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritProject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GerritProjectList {
    private static GerritProjectList instance = new GerritProjectList();
    private static final Logger logger = LoggerFactory.getLogger(GerritProjectList.class);
    private Map<String, ArrayList<GerritTrigger>> projectList = new HashMap<String, ArrayList<GerritTrigger>>();

    private GerritProjectList() {
    }

    public static GerritProjectList getInstance() {
        return instance;
    }

    private String createKeyString(GerritProject project) {
        if (project != null && project.getCompareType() == CompareType.PLAIN) {
            return project.getPattern();
        }
        return null;
    }

    public static void removeTriggerFromProjectList(GerritTrigger trigger) {
        GerritProjectList inst = GerritProjectList.getInstance();
        Iterator<Map.Entry<String, ArrayList<GerritTrigger>>> entries = inst.projectList.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, ArrayList<GerritTrigger>> entry = entries.next();
            String projectName = entry.getKey();
            ArrayList<GerritTrigger> triggers = entry.getValue();
            if (triggers == null || projectName == null || projectName.isEmpty()) {
                logger.warn("Invalid parameters: Triggers: " + String.valueOf(triggers) + " ProjectName: " + projectName);
                continue;
            }
            Iterator<GerritTrigger> i = triggers.iterator();
            while (i.hasNext()) {
                GerritTrigger trig = i.next();
                if (trig != trigger) continue;
                i.remove();
            }
            if (triggers != null && !triggers.isEmpty()) continue;
            entries.remove();
        }
    }

    public static void addProject(GerritProject project, GerritTrigger trigger) {
        GerritProjectList inst = GerritProjectList.getInstance();
        String key = inst.createKeyString(project);
        if (key != null) {
            inst.projectList.computeIfAbsent(key, unused -> new ArrayList());
            inst.projectList.get(key).add(trigger);
        }
    }

    public static Map<String, ArrayList<GerritTrigger>> getGerritProjects() {
        return GerritProjectList.getInstance().projectList;
    }
}

