/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger.config;

import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.GerritSlave;
import hudson.model.Failure;
import java.util.LinkedList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;

public class ReplicationConfig {
    private static final String DEFAULT_SLAVE_ID_JSON_KEY = "defaultSlaveId";
    private static final String ENABLE_REPLICATION_JSON_KEY = "enableReplication";
    private static final String ENABLE_SLAVE_SELECTION_IN_JOBS_JSON_KEY = "enableSlaveSelectionInJobs";
    private static final String SLAVES_JSON_KEY = "slaves";
    private boolean enableReplication;
    private List<GerritSlave> slaves;
    private boolean enableSlaveSelectionInJobs;
    private String defaultSlaveId;

    private ReplicationConfig(boolean enableReplication, List<GerritSlave> slaves, boolean enableSlaveSelectionInJobs, String defaultSlaveId) {
        this.enableReplication = enableReplication;
        this.slaves = slaves;
        this.enableSlaveSelectionInJobs = enableSlaveSelectionInJobs;
        this.defaultSlaveId = defaultSlaveId;
    }

    public ReplicationConfig(ReplicationConfig config) {
        this.enableReplication = config.isEnableReplication();
        if (config.getGerritSlaves() != null) {
            this.slaves = new LinkedList<GerritSlave>();
            for (GerritSlave slave : config.getGerritSlaves()) {
                GerritSlave slaveCopy = new GerritSlave(slave.getName(), slave.getHost(), slave.getTimeoutInSeconds());
                this.slaves.add(slaveCopy);
                if (!slave.getId().equals(config.getDefaultSlaveId())) continue;
                this.defaultSlaveId = slaveCopy.getId();
            }
        }
        this.enableSlaveSelectionInJobs = config.isEnableSlaveSelectionInJobs();
    }

    @DataBoundConstructor
    public ReplicationConfig() {
        this(false, new LinkedList<GerritSlave>(), false, null);
    }

    public boolean isEnableReplication() {
        return this.enableReplication;
    }

    public void setEnableReplication(boolean enableReplication) {
        this.enableReplication = enableReplication;
    }

    public List<GerritSlave> getGerritSlaves() {
        return this.slaves;
    }

    public List<GerritSlave> getReplicas() {
        return this.slaves;
    }

    public void setReplicas(List<GerritSlave> replicas) {
        this.slaves = replicas;
    }

    public boolean isEnableSlaveSelectionInJobs() {
        return this.enableSlaveSelectionInJobs;
    }

    public boolean isEnableReplicaSelectionInJobs() {
        return this.enableSlaveSelectionInJobs;
    }

    public void setEnableReplicaSelectionInJobs(boolean enableReplicaSelectionInJobs) {
        this.enableSlaveSelectionInJobs = enableReplicaSelectionInJobs;
    }

    public String getDefaultSlaveId() {
        return this.defaultSlaveId;
    }

    public String getDefaultReplicaId() {
        return this.defaultSlaveId;
    }

    public void setDefaultReplicaId(String replicaId) {
        this.defaultSlaveId = replicaId;
    }

    public GerritSlave getGerritSlave(String id, boolean defaultSlave) {
        for (GerritSlave slave : this.slaves) {
            if (!slave.getId().equals(id)) continue;
            return slave;
        }
        if (defaultSlave) {
            return this.getGerritSlave(this.defaultSlaveId, false);
        }
        return null;
    }

    public static ReplicationConfig createReplicationConfigFromJSON(JSONObject formData) {
        ReplicationConfig replicationConfig;
        LinkedList<GerritSlave> slaves = new LinkedList<GerritSlave>();
        boolean enableReplication = formData.has(ENABLE_REPLICATION_JSON_KEY);
        if (enableReplication) {
            JSONObject replicationConfigAsJSON = formData.getJSONObject(ENABLE_REPLICATION_JSON_KEY);
            Object slavesAsJSON = replicationConfigAsJSON.get(SLAVES_JSON_KEY);
            if (slavesAsJSON instanceof JSONArray) {
                for (Object jsonObject : (JSONArray)slavesAsJSON) {
                    slaves.add(GerritSlave.createGerritSlaveFromJSON((JSONObject)jsonObject));
                }
            } else if (slavesAsJSON instanceof JSONObject) {
                slaves.add(GerritSlave.createGerritSlaveFromJSON((JSONObject)slavesAsJSON));
            }
            if (slaves.size() == 0) {
                throw new Failure(Messages.OneSlaveMustBeDefined());
            }
            boolean enableSlaveSelectionInJobs = replicationConfigAsJSON.has(ENABLE_SLAVE_SELECTION_IN_JOBS_JSON_KEY);
            String defaultSlaveId = "";
            if (enableSlaveSelectionInJobs) {
                JSONObject defaultSlaveAsJSON = replicationConfigAsJSON.getJSONObject(ENABLE_SLAVE_SELECTION_IN_JOBS_JSON_KEY);
                defaultSlaveId = defaultSlaveAsJSON.getString(DEFAULT_SLAVE_ID_JSON_KEY);
                if (defaultSlaveId == null || defaultSlaveId.trim().isEmpty()) {
                    enableSlaveSelectionInJobs = false;
                } else {
                    boolean defaultSlaveExist = false;
                    for (GerritSlave gerritSlave : slaves) {
                        if (!defaultSlaveId.equals(gerritSlave.getId())) continue;
                        defaultSlaveExist = true;
                    }
                    if (!defaultSlaveExist) {
                        throw new Failure(Messages.CannotDeleteDefaultSlave());
                    }
                }
            }
            replicationConfig = new ReplicationConfig(true, slaves, enableSlaveSelectionInJobs, defaultSlaveId);
        } else {
            replicationConfig = new ReplicationConfig();
        }
        return replicationConfig;
    }
}

