/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.JenkinsAwareGerritHandler;
import com.sonyericsson.hudson.plugins.gerrit.trigger.Messages;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.Config;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.PluginConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.dependency.DependencyQueueTaskDispatcher;
import com.sonyericsson.hudson.plugins.gerrit.trigger.events.ManualPatchsetCreated;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.GerritTrigger;
import com.sonyericsson.hudson.plugins.gerrit.trigger.hudsontrigger.data.TriggerContextConverter;
import com.sonyericsson.hudson.plugins.gerrit.trigger.replication.ReplicationQueueTaskDispatcher;
import com.sonymobile.tools.gerrit.gerritevents.GerritHandler;
import com.sonymobile.tools.gerrit.gerritevents.GerritSendCommandQueue;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.workers.GerritWorkersConfig;
import com.thoughtworks.xstream.converters.Converter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.init.TermMilestone;
import hudson.init.Terminator;
import hudson.model.Api;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.security.Permission;
import hudson.security.PermissionGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportedBean
@Extension
@Symbol(value={"gerrit-trigger"})
public class PluginImpl
extends GlobalConfiguration {
    public static final String DISPLAY_NAME = "Gerrit Trigger";
    public static final String SYMBOL_NAME = "gerrit-trigger";
    public static final PermissionGroup PERMISSION_GROUP = new PermissionGroup(PluginImpl.class, Messages._GerritPermissionGroup());
    public static final Permission MANUAL_TRIGGER = new Permission(PERMISSION_GROUP, "ManualTrigger", Messages._ManualTriggerPermissionDescription(), Jenkins.ADMINISTER);
    public static final Permission RETRIGGER = new Permission(PERMISSION_GROUP, "Retrigger", Messages._RetriggerPermissionDescription(), Item.BUILD);
    private static final Logger logger = LoggerFactory.getLogger(PluginImpl.class);
    private final List<GerritServer> servers = new CopyOnWriteArrayList<GerritServer>();
    private transient GerritHandler gerritEventManager;
    private volatile transient boolean active = false;
    @Deprecated
    private transient IGerritHudsonTriggerConfig config;
    private PluginConfig pluginConfig;
    public static final String DEFAULT_SERVER_NAME = "defaultServer";
    public static final String TEST_SSH_KEYFILE_LOCATION_PROPERTY = PluginImpl.class.getName() + "_test_ssh_key_file";

    public Api getApi() {
        return new Api((Object)this);
    }

    @CheckForNull
    public static PluginImpl getInstance() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            return (PluginImpl)((Object)GlobalConfiguration.all().get(PluginImpl.class));
        }
        logger.debug("Error, Jenkins could not be found, so no plugin!");
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    @Exported
    public List<GerritServer> getServers() {
        return this.servers;
    }

    @NonNull
    public static List<GerritServer> getServers_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("PluginImpl instance not found!");
            return Collections.emptyList();
        }
        return plugin.getServers();
    }

    public List<String> getServerNames() {
        LinkedList<String> names = new LinkedList<String>();
        for (GerritServer s : this.getServers()) {
            names.add(s.getName());
        }
        return names;
    }

    @NonNull
    public static List<String> getServerNames_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("PluginImpl instance not found!");
            return Collections.emptyList();
        }
        return plugin.getServerNames();
    }

    public GerritServer getServer(String name) {
        for (GerritServer s : this.servers) {
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    @CheckForNull
    public static GerritServer getServer_(String name) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getServer(name);
    }

    public GerritServer getServer(GerritTriggeredEvent event) {
        Provider provider = event.getProvider();
        if (provider == null) {
            logger.warn("The event {} has no provider specified. BUG!", (Object)event);
            return null;
        }
        GerritServer gerritServer = PluginImpl.getServer_(provider.getName());
        if (gerritServer == null) {
            logger.warn("Could not find server config for {} - no such server.", (Object)provider.getName());
            return null;
        }
        return gerritServer;
    }

    @CheckForNull
    public static GerritServer getServer_(GerritTriggeredEvent event) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getServer(event);
    }

    @CheckForNull
    public GerritServer getFirstServer() {
        if (!this.servers.isEmpty()) {
            return this.servers.get(0);
        }
        return null;
    }

    @CheckForNull
    public static GerritServer getFirstServer_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getFirstServer();
    }

    public void setServers(List<GerritServer> servers) {
        this.checkAdmin();
        ArrayList<String> serverNames = new ArrayList<String>();
        for (GerritServer server : servers) {
            String name = server.getName();
            if (serverNames.contains(name)) {
                throw new IllegalArgumentException("Multiple gerrit servers with name: " + name);
            }
            serverNames.add(name);
        }
        if (serverNames.contains("__ANY__")) {
            throw new IllegalArgumentException("Illegal gerrit server name: __ANY__");
        }
        if (this.servers != servers) {
            this.servers.clear();
            this.servers.addAll(servers);
        }
    }

    public List<GerritServer> addServer(GerritServer s) {
        this.checkAdmin();
        this.servers.add(s);
        return this.servers;
    }

    public List<GerritServer> removeServer(GerritServer s) {
        this.checkAdmin();
        this.servers.remove(s);
        return this.servers;
    }

    private void checkAdmin() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            jenkins.checkPermission(Jenkins.ADMINISTER);
        }
    }

    public boolean containsServer(String serverName) {
        boolean contains = false;
        for (GerritServer s : this.getServers()) {
            if (!s.getName().equals(serverName)) continue;
            contains = true;
        }
        return contains;
    }

    public static boolean containsServer_(String serverName) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return false;
        }
        return plugin.containsServer(serverName);
    }

    public static IGerritHudsonTriggerConfig getServerConfig(GerritTriggeredEvent event) {
        Provider provider = event.getProvider();
        if (provider != null) {
            GerritServer gerritServer = PluginImpl.getServer_(provider.getName());
            if (gerritServer != null) {
                return gerritServer.getConfig();
            }
            logger.warn("Could not find server config for {} - no such server.", (Object)provider.getName());
        } else {
            logger.warn("The event {} has no provider specified. BUG!", (Object)event);
        }
        return null;
    }

    public synchronized PluginConfig getPluginConfig() {
        return this.pluginConfig;
    }

    public synchronized void setPluginConfig(PluginConfig pluginConfig) {
        this.pluginConfig = pluginConfig;
    }

    @CheckForNull
    public static PluginConfig getPluginConfig_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getPluginConfig();
    }

    public static void save_() throws IOException {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return;
        }
        plugin.save();
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.get().getRootDir(), "gerrit-trigger.xml"));
    }

    @NonNull
    public GerritHandler getHandler() {
        if (this.gerritEventManager == null) {
            throw new IllegalStateException("Plugin is not started yet, or it is stopped already");
        }
        return this.gerritEventManager;
    }

    @CheckForNull
    public static GerritHandler getHandler_() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return null;
        }
        return plugin.getHandler();
    }

    public List<Job> getConfiguredJobs(String serverName) {
        LinkedList<Job> configuredJobs = new LinkedList<Job>();
        for (Job project : Jenkins.get().getItems(Job.class)) {
            GerritTrigger gerritTrigger = GerritTrigger.getTrigger(project);
            if (gerritTrigger == null || !gerritTrigger.getServerName().equals(serverName)) continue;
            configuredJobs.add(project);
        }
        return configuredJobs;
    }

    @NonNull
    public static List<Job> getConfiguredJobs_(String serverName) {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            logger.debug("Error, plugin instance could not be found!");
            return Collections.emptyList();
        }
        return plugin.getConfiguredJobs(serverName);
    }

    public void start() {
        logger.info("Starting Gerrit-Trigger Plugin");
        logger.trace("Loading configs");
        this.load();
        GerritSendCommandQueue.initialize((GerritWorkersConfig)this.pluginConfig);
        this.gerritEventManager = new JenkinsAwareGerritHandler(this.pluginConfig.getNumberOfReceivingWorkerThreads());
        for (GerritServer s : this.servers) {
            s.start();
        }
        this.active = true;
    }

    @Initializer(after=InitMilestone.SYSTEM_CONFIG_ADAPTED)
    public static void initializeDispatchers() {
        try {
            ExtensionList.lookupSingleton(ReplicationQueueTaskDispatcher.class);
        }
        catch (IllegalStateException e) {
            logger.warn("Failed to initialize Replication Queue.", (Throwable)e);
        }
        try {
            ExtensionList.lookupSingleton(DependencyQueueTaskDispatcher.class);
        }
        catch (IllegalStateException e) {
            logger.warn("Failed to initialize Dependency Queue.", (Throwable)e);
        }
    }

    public void load() {
        super.load();
        if (this.pluginConfig == null) {
            PluginConfig conf = new PluginConfig();
            if (this.config != null) {
                conf.setNumberOfReceivingWorkerThreads(this.config.getNumberOfReceivingWorkerThreads());
                conf.setNumberOfSendingWorkerThreads(this.config.getNumberOfSendingWorkerThreads());
            }
            this.pluginConfig = conf;
        }
        if (this.servers.isEmpty()) {
            if (this.config != null) {
                GerritServer defaultServer = new GerritServer(DEFAULT_SERVER_NAME);
                defaultServer.setConfig(this.config);
                this.servers.add(defaultServer);
            }
            this.save();
        }
        this.pluginConfig.updateEventFilter();
        if (System.getProperty(TEST_SSH_KEYFILE_LOCATION_PROPERTY) != null && !this.servers.isEmpty()) {
            File location = new File(System.getProperty(TEST_SSH_KEYFILE_LOCATION_PROPERTY));
            for (GerritServer server : this.servers) {
                ((Config)server.getConfig()).setGerritAuthKeyFile(location);
            }
        }
    }

    protected static void doXStreamRegistrations() {
        logger.trace("doing XStream alias registrations.");
        Items.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Jenkins.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Run.XSTREAM.registerConverter((Converter)new TriggerContextConverter());
        Run.XSTREAM2.addCompatibilityAlias("com.sonyericsson.hudson.plugins.gerrit.gerritevents.dto.events.ManualPatchsetCreated", ManualPatchsetCreated.class);
        Items.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        Jenkins.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        Run.XSTREAM.aliasPackage("com.sonyericsson.hudson.plugins.gerrit.gerritevents", "com.sonymobile.tools.gerrit.gerritevents");
        logger.trace("XStream alias registrations done.");
    }

    public void stop() {
        this.active = false;
        for (GerritServer s : this.servers) {
            s.stop();
        }
        if (this.gerritEventManager != null) {
            this.gerritEventManager.shutdown(false);
            this.gerritEventManager = null;
        }
        GerritSendCommandQueue.shutdown();
        this.servers.clear();
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    @Restricted(value={DoNotUse.class})
    public static void gerritStart() {
        PluginImpl instance = PluginImpl.getInstance();
        if (instance == null) {
            throw new IllegalStateException("Jenkins is not up");
        }
        instance.start();
    }

    @Terminator(after=TermMilestone.COMPLETED)
    @Restricted(value={DoNotUse.class})
    public static void gerritStop() {
        PluginImpl instance = PluginImpl.getInstance();
        if (instance == null) {
            throw new IllegalStateException("Jenkins is not up");
        }
        instance.stop();
    }

    static {
        PluginImpl.doXStreamRegistrations();
    }
}

