/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.hudson.plugins.gerrit.trigger;

import com.sonyericsson.hudson.plugins.gerrit.trigger.GerritServer;
import com.sonyericsson.hudson.plugins.gerrit.trigger.NamedGerritEventListener;
import com.sonyericsson.hudson.plugins.gerrit.trigger.PluginImpl;
import com.sonyericsson.hudson.plugins.gerrit.trigger.config.IGerritHudsonTriggerConfig;
import com.sonyericsson.hudson.plugins.gerrit.trigger.utils.StringUtil;
import com.sonymobile.tools.gerrit.gerritevents.ConnectionListener;
import com.sonymobile.tools.gerrit.gerritevents.GerritEventListener;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ProjectCreated;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GerritProjectListUpdater
implements ConnectionListener,
NamedGerritEventListener {
    public static final String GERRIT_LS_PROJECTS = "gerrit ls-projects";
    private static final int MAX_WAIT_TIME = 64;
    private static final int DEFAULT_TIMER_PERIOD = 5;
    private int timerUpdatePeriod = 5;
    private Timer timer;
    private AtomicBoolean connected = new AtomicBoolean(false);
    private boolean shutdown = false;
    private static final Logger logger = LoggerFactory.getLogger(GerritProjectListUpdater.class);
    private List<String> gerritProjects;
    private String serverName;

    public GerritProjectListUpdater(String serverName) {
        this.serverName = serverName;
        this.addThisAsListener();
    }

    public int getTimerUpdatePeriod() {
        return this.timerUpdatePeriod;
    }

    public void setTimerUpdatePeriod(int timerUpdatePeriod) {
        this.timerUpdatePeriod = timerUpdatePeriod;
        this.scheduleProjectListUpdate(0, (int)TimeUnit.MINUTES.toSeconds(timerUpdatePeriod));
    }

    public String getServerName() {
        return this.serverName;
    }

    private void addThisAsListener() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin == null) {
            return;
        }
        GerritServer server = plugin.getServer(this.serverName);
        if (server != null) {
            server.addListener(this.connectionListener());
            this.connected.set(server.isConnected());
        } else {
            logger.error("Could not find the server {}", (Object)this.serverName);
        }
    }

    private ConnectionListener connectionListener() {
        return this;
    }

    private GerritEventListener gerritEventListener() {
        return this;
    }

    public synchronized void connectionEstablished() {
        this.setConnected(true);
        this.notify();
    }

    public synchronized void connectionDown() {
        this.setConnected(false);
    }

    public void gerritEvent(GerritEvent gerritEvent) {
    }

    public void gerritEvent(ProjectCreated gerritEvent) {
        this.addGerritProject(gerritEvent.getProjectName());
        logger.debug("Added project {} to project lists", (Object)gerritEvent.getProjectName());
    }

    public void initProjectListUpdater() {
        logger.info("Init project list updater");
        if (this.timer == null) {
            if (!this.getConfig().isEnableProjectAutoCompletion()) {
                return;
            }
            this.timer = new Timer(this.serverName);
            this.scheduleProjectListUpdate(this.getConfig().getProjectListFetchDelay(), this.getConfig().getProjectListRefreshInterval());
        } else {
            logger.error("Can't create two timers for the same Gerrit instance: " + this.serverName);
        }
    }

    public void cancelProjectListUpdater() {
        try {
            if (this.timer != null) {
                this.timer.cancel();
                this.shutdown = true;
                this.timer = null;
            } else {
                logger.error("Unable to cancel project list update task because timer is null");
            }
        }
        catch (Exception e) {
            logger.error("Error canceling project list updater: ", (Throwable)e);
        }
    }

    public void scheduleProjectListUpdate(int initDelay, int updatePeriod) {
        logger.info("Start timer to update project list");
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = new Timer(this.serverName);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    GerritProjectListUpdater.this.tryLoadProjectList();
                }
            }, TimeUnit.SECONDS.toMillis(initDelay), TimeUnit.SECONDS.toMillis(updatePeriod));
        } else {
            logger.error("Unable to schedule project list update task because timer is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(long delay) {
        try {
            GerritProjectListUpdater gerritProjectListUpdater = this;
            synchronized (gerritProjectListUpdater) {
                long startTime = System.nanoTime();
                while (System.nanoTime() - startTime < TimeUnit.SECONDS.toNanos(delay) && !this.shutdown) {
                    this.wait(TimeUnit.SECONDS.toMillis(1L));
                }
            }
        }
        catch (InterruptedException ex) {
            logger.warn("InterruptedException: ", (Throwable)ex);
        }
    }

    private void tryLoadProjectList() {
        int interval = 1;
        while (!this.isConnected() && !this.shutdown) {
            logger.info("Not connected to {}, waiting for {} second(s)", (Object)this.serverName, (Object)interval);
            this.waitFor(interval);
            if (interval >= 64) continue;
            interval *= 2;
        }
        try {
            if (this.isConnected()) {
                logger.info("Trying to load project list.");
                IGerritHudsonTriggerConfig activeConfig = this.getConfig();
                SshConnection sshConnection = SshConnectionFactory.getConnection((String)activeConfig.getGerritHostName(), (int)activeConfig.getGerritSshPort(), (String)activeConfig.getGerritProxy(), (Authentication)activeConfig.getGerritAuthentication());
                List<String> projects = GerritProjectListUpdater.readProjects(sshConnection.executeCommandReader(GERRIT_LS_PROJECTS));
                if (projects.size() > 0) {
                    this.setGerritProjects(projects);
                    logger.info("Project list from {} contains {} entries", (Object)this.serverName, (Object)projects.size());
                } else {
                    logger.warn("Project list from {} contains 0 projects", (Object)this.serverName);
                }
                sshConnection.disconnect();
            } else {
                logger.warn("Could not connect to Gerrit server when updating Gerrit project list: Server is not connected (timeout)");
            }
        }
        catch (SshException ex) {
            logger.warn("Could not connect to Gerrit server when updating Gerrit project list: ", (Throwable)ex);
        }
        catch (IOException ex) {
            logger.error("Could not read stream with Gerrit projects: ", (Throwable)ex);
        }
    }

    private IGerritHudsonTriggerConfig getConfig() {
        PluginImpl plugin = PluginImpl.getInstance();
        if (plugin != null) {
            GerritServer server = plugin.getServer(this.serverName);
            if (server != null) {
                IGerritHudsonTriggerConfig config = server.getConfig();
                if (config != null) {
                    return config;
                }
                logger.error("Could not find the server config");
            } else {
                logger.error("Could not find server {}", (Object)this.serverName);
            }
        }
        return null;
    }

    public static List<String> readProjects(Reader commandReader) throws IOException {
        ArrayList<String> projects = new ArrayList<String>();
        BufferedReader br = new BufferedReader(commandReader);
        String line = br.readLine();
        while (line != null) {
            projects.add(line);
            line = br.readLine();
        }
        return projects;
    }

    public synchronized boolean isConnected() {
        return this.connected.get();
    }

    public synchronized void setConnected(boolean connected) {
        this.connected.set(connected);
    }

    public synchronized void addGerritProject(String gerritProject) {
        this.gerritProjects.add(gerritProject);
    }

    public synchronized void setGerritProjects(List<String> projects) {
        this.gerritProjects = projects;
    }

    public synchronized List<String> getGerritProjects() {
        if (this.gerritProjects == null) {
            this.gerritProjects = new ArrayList<String>();
        }
        return this.gerritProjects;
    }

    @Override
    public String getDisplayName() {
        return StringUtil.getDefaultDisplayNameForSpecificServer(this, this.getServerName());
    }
}

