/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.workers.rest;

import com.google.gson.Gson;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ChangeId;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewInput;
import com.sonymobile.tools.gerrit.gerritevents.rest.RestConnectionConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestCommandJob2
implements Callable<String> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRestCommandJob2.class);
    private static final Gson GSON = new Gson();
    protected final String frontEndUrl;
    protected final String httpProxy;
    protected final Credentials credentials;
    protected final PrintStream altLogger;
    protected final ChangeBasedEvent event;

    public AbstractRestCommandJob2(RestConnectionConfig config, PrintStream altLogger, ChangeBasedEvent event) {
        this.frontEndUrl = config.getGerritFrontEndUrl();
        this.httpProxy = config.getGerritProxy();
        this.credentials = config.getHttpCredentials();
        this.altLogger = altLogger;
        this.event = event;
    }

    @Override
    public String call() throws IOException {
        String response;
        block10: {
            HttpHost proxy;
            BasicCredentialsProvider credProvider;
            HttpPost httpPost;
            block9: {
                String reviewEndpoint;
                response = "";
                ReviewInput reviewInput = this.createReview();
                httpPost = this.createHttpPostEntity(reviewInput, reviewEndpoint = this.resolveEndpointURL());
                if (httpPost == null) {
                    return response;
                }
                credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(AuthScope.ANY, this.credentials);
                proxy = null;
                if (this.httpProxy != null && !this.httpProxy.isEmpty()) {
                    try {
                        URL url = new URL(this.httpProxy);
                        proxy = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                    }
                    catch (MalformedURLException e) {
                        logger.error("Could not parse proxy URL, attempting without proxy.", (Throwable)e);
                        if (this.altLogger == null) break block9;
                        this.altLogger.print("ERROR Could not parse proxy URL, attempting without proxy. " + e.getMessage());
                    }
                }
            }
            HttpClientBuilder builder = HttpClients.custom();
            builder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            if (proxy != null) {
                builder.setProxy(proxy);
            }
            CloseableHttpClient httpClient = builder.build();
            try {
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    logger.error("Gerrit response: {}", (Object)httpResponse.getStatusLine().getReasonPhrase());
                    if (this.altLogger != null) {
                        this.altLogger.print("ERROR Gerrit response: " + httpResponse.getStatusLine().getReasonPhrase());
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to submit result to Gerrit", (Throwable)e);
                if (this.altLogger == null) break block10;
                this.altLogger.print("ERROR Failed to submit result to Gerrit" + e.toString());
            }
        }
        return response;
    }

    protected abstract ReviewInput createReview();

    private HttpPost createHttpPostEntity(ReviewInput reviewInput, String reviewEndpoint) {
        HttpPost httpPost = new HttpPost(reviewEndpoint);
        String asJson = GSON.toJson((Object)reviewInput);
        StringEntity entity = null;
        try {
            entity = new StringEntity(asJson);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to create JSON for posting to Gerrit", (Throwable)e);
            if (this.altLogger != null) {
                this.altLogger.print("ERROR Failed to create JSON for posting to Gerrit: " + e.toString());
            }
            return null;
        }
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }

    private String resolveEndpointURL() {
        String gerritFrontEndUrl = this.frontEndUrl;
        if (!gerritFrontEndUrl.endsWith("/")) {
            gerritFrontEndUrl = gerritFrontEndUrl + "/";
        }
        ChangeId changeId = new ChangeId(this.event.getChange().getProject(), this.event.getChange().getBranch(), this.event.getChange().getId());
        return gerritFrontEndUrl + "a/changes/" + changeId.asUrlPart() + "/revisions/" + this.event.getPatchSet().getRevision() + "/review";
    }
}

