/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.workers.rest;

import com.google.gson.Gson;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.ChangeBasedEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ChangeId;
import com.sonymobile.tools.gerrit.gerritevents.dto.rest.ReviewInput;
import com.sonymobile.tools.gerrit.gerritevents.rest.RestConnectionConfig;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRestCommandJob
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRestCommandJob.class);
    private static final Gson GSON = new Gson();
    private final RestConnectionConfig config;
    protected final PrintStream altLogger;
    protected final ChangeBasedEvent event;

    public AbstractRestCommandJob(RestConnectionConfig config, PrintStream altLogger, ChangeBasedEvent event) {
        this.config = config;
        this.altLogger = altLogger;
        this.event = event;
    }

    @Override
    public void run() {
        block9: {
            HttpClientBuilder builder;
            HttpPost httpPost;
            block8: {
                String reviewEndpoint;
                ReviewInput reviewInput = this.createReview();
                httpPost = this.createHttpPostEntity(reviewInput, reviewEndpoint = this.resolveEndpointURL());
                if (httpPost == null) {
                    return;
                }
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(null, -1), this.config.getHttpCredentials());
                builder = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
                if (this.config.getGerritProxy() != null && !this.config.getGerritProxy().isEmpty()) {
                    try {
                        URL url = new URL(this.config.getGerritProxy());
                        HttpHost proxy = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
                        builder.setProxy(proxy);
                    }
                    catch (MalformedURLException e) {
                        logger.error("Could not parse proxy URL, attempting without proxy.", (Throwable)e);
                        if (this.altLogger == null) break block8;
                        this.altLogger.print("ERROR Could not parse proxy URL, attempting without proxy. " + e.getMessage());
                    }
                }
            }
            CloseableHttpClient httpclient = builder.build();
            try {
                HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent(), (String)"UTF-8");
                if (httpResponse.getStatusLine().getStatusCode() != 200) {
                    logger.error("Gerrit response: {}", (Object)httpResponse.getStatusLine().getReasonPhrase());
                    if (this.altLogger != null) {
                        this.altLogger.print("ERROR Gerrit response: " + httpResponse.getStatusLine().getReasonPhrase());
                    }
                }
            }
            catch (Exception e) {
                logger.error("Failed to submit result to Gerrit", (Throwable)e);
                if (this.altLogger == null) break block9;
                this.altLogger.print("ERROR Failed to submit result to Gerrit" + e.toString());
            }
        }
    }

    protected abstract ReviewInput createReview();

    private HttpPost createHttpPostEntity(ReviewInput reviewInput, String reviewEndpoint) {
        HttpPost httpPost = new HttpPost(reviewEndpoint);
        String asJson = GSON.toJson((Object)reviewInput);
        StringEntity entity = null;
        try {
            entity = new StringEntity(asJson);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to create JSON for posting to Gerrit", (Throwable)e);
            if (this.altLogger != null) {
                this.altLogger.print("ERROR Failed to create JSON for posting to Gerrit: " + e.toString());
            }
            return null;
        }
        entity.setContentType("application/json");
        httpPost.setEntity((HttpEntity)entity);
        return httpPost;
    }

    private String resolveEndpointURL() {
        String gerritFrontEndUrl = this.config.getGerritFrontEndUrl();
        if (!gerritFrontEndUrl.endsWith("/")) {
            gerritFrontEndUrl = gerritFrontEndUrl + "/";
        }
        ChangeId changeId = new ChangeId(this.event.getChange().getProject(), this.event.getChange().getBranch(), this.event.getChange().getId());
        return gerritFrontEndUrl + "a/changes/" + changeId.asUrlPart() + "/revisions/" + this.event.getPatchSet().getRevision() + "/review";
    }

    public RestConnectionConfig getConfig() {
        return this.config;
    }
}

