/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.workers.cmd;

import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.ssh.Authentication;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendCommandJob2
implements Callable<String> {
    protected static Logger logger = LoggerFactory.getLogger(AbstractSendCommandJob2.class);
    protected final String host;
    protected final int port;
    protected final String proxy;
    protected final Authentication auth;

    protected AbstractSendCommandJob2(GerritConnectionConfig2 config) {
        this.host = config.getGerritHostName();
        this.port = config.getGerritSshPort();
        this.proxy = config.getGerritProxy();
        this.auth = config.getGerritAuthentication();
    }

    protected abstract String createGerritCommand();

    @Override
    public String call() throws IOException {
        String str = null;
        SshConnection ssh = null;
        try {
            ssh = SshConnectionFactory.getConnection(this.host, this.port, this.proxy, this.auth);
            str = ssh.executeCommand(this.createGerritCommand());
        }
        catch (Exception ex) {
            throw new IOException("Error during sending command", ex);
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
        return str;
    }
}

