/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.workers.cmd;

import com.sonymobile.tools.gerrit.gerritevents.GerritCmdRunner;
import com.sonymobile.tools.gerrit.gerritevents.GerritCmdRunner2;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig;
import com.sonymobile.tools.gerrit.gerritevents.GerritConnectionConfig2;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnection;
import com.sonymobile.tools.gerrit.gerritevents.ssh.SshConnectionFactory;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSendCommandJob
implements Runnable,
GerritCmdRunner,
GerritCmdRunner2 {
    protected static Logger logger = LoggerFactory.getLogger(AbstractSendCommandJob.class);
    private GerritConnectionConfig2 config;

    protected AbstractSendCommandJob(GerritConnectionConfig2 config) {
        this.config = config;
    }

    public GerritConnectionConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean sendCommand(String command) {
        try {
            this.sendCommand2(command);
        }
        catch (Exception ex) {
            logger.error("Could not run command " + command, (Throwable)ex);
            return false;
        }
        return true;
    }

    @Override
    public String sendCommandStr(String command) {
        String str = null;
        try {
            str = this.sendCommand2(command);
        }
        catch (Exception ex) {
            logger.error("Could not run command " + command, (Throwable)ex);
        }
        return str;
    }

    @Override
    public String sendCommand2(String command) throws IOException {
        String str = null;
        SshConnection ssh = null;
        try {
            ssh = SshConnectionFactory.getConnection(this.config.getGerritHostName(), this.config.getGerritSshPort(), this.config.getGerritProxy(), this.config.getGerritAuthentication());
            str = ssh.executeCommand(command);
        }
        catch (Exception ex) {
            throw new IOException("Error during sending command", ex);
        }
        finally {
            if (ssh != null) {
                ssh.disconnect();
            }
        }
        return str;
    }
}

