/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.workers;

import com.sonymobile.tools.gerrit.gerritevents.GerritJsonEventFactory;
import com.sonymobile.tools.gerrit.gerritevents.dto.GerritJsonEvent;
import com.sonymobile.tools.gerrit.gerritevents.dto.attr.Provider;
import com.sonymobile.tools.gerrit.gerritevents.dto.events.GerritTriggeredEvent;
import com.sonymobile.tools.gerrit.gerritevents.workers.AbstractGerritEventWork;
import com.sonymobile.tools.gerrit.gerritevents.workers.Coordinator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonObjectWork
extends AbstractGerritEventWork {
    private static final Logger logger = LoggerFactory.getLogger(AbstractJsonObjectWork.class);
    private final long createdOn = System.currentTimeMillis();

    public long createdOn() {
        return this.createdOn;
    }

    protected void perform(JSONObject json, Coordinator coordinator, Provider provider) {
        logger.trace("Extracting event from JSON.");
        GerritJsonEvent event = GerritJsonEventFactory.getEvent(json);
        if (event != null) {
            if (event instanceof GerritTriggeredEvent) {
                GerritTriggeredEvent gerritTriggeredEvent = (GerritTriggeredEvent)event;
                gerritTriggeredEvent.setProvider(provider);
                gerritTriggeredEvent.setReceivedOn(this.createdOn);
            }
            logger.debug("Event is: {}", (Object)event);
            this.perform(event, coordinator);
        } else {
            logger.debug("No event extracted!");
        }
    }
}

