/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.watchdog;

import java.util.Calendar;
import java.util.List;
import net.sf.json.JSONObject;

public class WatchTimeExceptionData {
    private int[] daysOfWeek;
    private List<TimeSpan> timesOfDay;

    public WatchTimeExceptionData(int[] daysOfWeek, List<TimeSpan> timesOfDay) {
        this.daysOfWeek = daysOfWeek;
        this.timesOfDay = timesOfDay;
    }

    public WatchTimeExceptionData() {
    }

    public int[] getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public List<TimeSpan> getTimesOfDay() {
        return this.timesOfDay;
    }

    public boolean isExceptionNow() {
        return this.isExceptionToday() || this.isExceptionAtThisTime();
    }

    public boolean isExceptionAtThisTime() {
        Time now = new Time();
        for (TimeSpan span : this.timesOfDay) {
            if (!span.isWithin(now)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionToday() {
        if (this.daysOfWeek != null && this.daysOfWeek.length > 0) {
            int dayOfWeekNow = Calendar.getInstance().get(7);
            for (int exceptionDay : this.daysOfWeek) {
                if (exceptionDay != dayOfWeekNow) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled() {
        if (this.daysOfWeek != null && this.daysOfWeek.length > 0) {
            return true;
        }
        return this.timesOfDay != null && this.timesOfDay.size() > 0;
    }

    public boolean isExceptionDay(int day) {
        for (int i : this.daysOfWeek) {
            if (day != i) continue;
            return true;
        }
        return false;
    }

    public static class Time {
        public static final int MIN_HOUR = 0;
        public static final int MAX_HOUR = 23;
        public static final int MIN_MINUTE = 0;
        public static final int MAX_MINUTE = 59;
        protected static final int MINIMUM_TWO_DIGIT_NUMBER = 10;
        private int hour;
        private int minute;

        public Time() {
            Calendar now = Calendar.getInstance();
            this.hour = now.get(11);
            this.minute = now.get(12);
        }

        public Time(int hour, int minute) {
            if (hour < 0 || hour > 23) {
                throw new IllegalArgumentException("Hour should be in 24 hour format");
            }
            if (minute < 0 || minute > 59) {
                throw new IllegalArgumentException("there are 60 minutes in an hour.");
            }
            this.hour = hour;
            this.minute = minute;
        }

        public static Time createTimeFromString(String timeString) {
            String[] split = timeString.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("Time should be on the hh:mm format.");
            }
            int parsedHour = Integer.parseInt(split[0]);
            int parsedMinute = Integer.parseInt(split[1]);
            if (parsedHour < 0 || parsedHour > 23) {
                throw new IllegalArgumentException("Hour should be in 24 hour format.");
            }
            if (parsedMinute < 0 || parsedMinute > 59) {
                throw new IllegalArgumentException("There are 60 minutes in an hour.");
            }
            return new Time(parsedHour, parsedMinute);
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public String getHourAsString() {
            if (this.hour < 10) {
                return "0" + this.hour;
            }
            return String.valueOf(this.hour);
        }

        public String getMinuteAsString() {
            if (this.minute < 10) {
                return "0" + this.minute;
            }
            return String.valueOf(this.minute);
        }

        public boolean before(Time time) {
            if (this.hour < time.hour) {
                return true;
            }
            if (this.hour == time.hour) {
                return this.minute < time.minute;
            }
            return false;
        }

        public boolean after(Time time) {
            if (this.hour > time.hour) {
                return true;
            }
            if (this.hour == time.hour) {
                return this.minute > time.minute;
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Time time = (Time)o;
            if (this.hour != time.hour) {
                return false;
            }
            return this.minute == time.minute;
        }

        public int hashCode() {
            int result = this.hour;
            result = 31 * result + this.minute;
            return result;
        }
    }

    public static class TimeSpan {
        private Time from;
        private Time to;

        TimeSpan() {
        }

        public TimeSpan(Time from, Time to) {
            if (!from.before(to)) {
                throw new IllegalArgumentException("From should be before to.");
            }
            this.from = from;
            this.to = to;
        }

        public static TimeSpan createTimeSpanFromJSONObject(JSONObject jsonObject) {
            String from = jsonObject.getString("from");
            String to = jsonObject.getString("to");
            return new TimeSpan(Time.createTimeFromString(from), Time.createTimeFromString(to));
        }

        public Time getFrom() {
            return this.from;
        }

        public Time getTo() {
            return this.to;
        }

        public boolean isWithin(Time time) {
            return !(!this.from.before(time) && !this.from.equals(time) || !this.to.after(time) && !this.to.equals(time));
        }
    }
}

