/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.watchdog;

import com.sonymobile.tools.gerrit.gerritevents.Connector;
import com.sonymobile.tools.gerrit.gerritevents.watchdog.WatchTimeExceptionData;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamWatchdog
extends TimerTask {
    public static final long DEFAULT_CHECK_START_DELAY = TimeUnit.MINUTES.toMillis(1L);
    public static final long DEFAULT_CHECK_PERIOD = TimeUnit.SECONDS.toMillis(20L);
    private static final Logger logger = LoggerFactory.getLogger(StreamWatchdog.class);
    private long lastSignal;
    private Timer timer;
    private Connector connector;
    private int timeoutSeconds;
    private WatchTimeExceptionData exceptionData;

    public StreamWatchdog(Connector connector, int timeoutSeconds, WatchTimeExceptionData exceptionData) {
        this(connector, timeoutSeconds, exceptionData, DEFAULT_CHECK_START_DELAY, DEFAULT_CHECK_PERIOD);
    }

    public StreamWatchdog(Connector connector, int timeoutSeconds, WatchTimeExceptionData exceptionData, long checkStartDelay, long checkPeriod) {
        this.connector = connector;
        this.timeoutSeconds = timeoutSeconds;
        this.exceptionData = exceptionData;
        this.lastSignal = System.currentTimeMillis();
        this.timer = new Timer(StreamWatchdog.class.getName());
        this.timer.schedule((TimerTask)this, checkStartDelay, checkPeriod);
    }

    @Override
    public void run() {
        if (!this.exceptionData.isExceptionNow()) {
            long quietTime = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.getLastSignal());
            logger.debug("Quiet time: {}", (Object)quietTime);
            if (quietTime >= (long)this.timeoutSeconds) {
                logger.info("Last lively connection with Gerrit was {} seconds ago; reconnecting.", (Object)quietTime);
                this.connector.reconnect();
            }
        }
    }

    public synchronized long getLastSignal() {
        return this.lastSignal;
    }

    public synchronized void signal() {
        this.lastSignal = System.currentTimeMillis();
    }

    public void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

