/*
 * Decompiled with CFR 0.152.
 */
package com.sonymobile.tools.gerrit.gerritevents.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import java.io.File;

public final class SshUtil {
    private SshUtil() {
    }

    public static boolean isPrivateKeyFileValid(File keyFile) {
        return SshUtil.parsePrivateKeyFile(keyFile) != null;
    }

    private static KeyPair parsePrivateKeyFile(File keyFile) {
        if (keyFile == null) {
            return null;
        }
        try {
            JSch jsch = new JSch();
            KeyPair key = KeyPair.load((JSch)jsch, (String)keyFile.getAbsolutePath());
            return key;
        }
        catch (JSchException ex) {
            return null;
        }
    }

    public static boolean checkPassPhrase(File keyFilePath, String passPhrase) {
        boolean isValidPhrase;
        KeyPair key = SshUtil.parsePrivateKeyFile(keyFilePath);
        boolean bl = isValidPhrase = passPhrase != null && !passPhrase.trim().isEmpty();
        if (key == null) {
            return false;
        }
        if (key.isEncrypted() != isValidPhrase) {
            return false;
        }
        if (key.isEncrypted()) {
            return key.decrypt(passPhrase);
        }
        return true;
    }
}

